/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.groups.utils.serializer;

import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlinx.serialization.KSerializer;
import su.plo.voice.libs.kotlinx.serialization.descriptors.PrimitiveKind;
import su.plo.voice.libs.kotlinx.serialization.descriptors.SerialDescriptor;
import su.plo.voice.libs.kotlinx.serialization.descriptors.SerialDescriptorsKt;
import su.plo.voice.libs.kotlinx.serialization.encoding.Decoder;
import su.plo.voice.libs.kotlinx.serialization.encoding.Encoder;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lsu/plo/voice/groups/utils/serializer/UUIDSerializer;", "Lsu/plo/voice/libs/kotlinx/serialization/KSerializer;", "Ljava/util/UUID;", "()V", "descriptor", "Lsu/plo/voice/libs/kotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lsu/plo/voice/libs/kotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lsu/plo/voice/libs/kotlinx/serialization/encoding/Encoder;", "value", "jar"})
public final class UUIDSerializer
implements KSerializer<UUID> {
    @NotNull
    public static final UUIDSerializer INSTANCE = new UUIDSerializer();
    @NotNull
    private static final SerialDescriptor descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"UUID", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));

    private UUIDSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @NotNull
    public UUID deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        UUID uUID = UUID.fromString(decoder.decodeString());
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(decoder.decodeString())");
        return uUID;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull UUID value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.toString()");
        encoder.encodeString(string);
    }
}

