/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.groups.group;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.chat.component.McTranslatableText;
import su.plo.slib.api.chat.style.McTextClickEvent;
import su.plo.slib.api.chat.style.McTextHoverEvent;
import su.plo.slib.api.command.McCommandSource;
import su.plo.slib.api.entity.player.McGameProfile;
import su.plo.voice.api.server.audio.line.ServerPlayerSet;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.groups.command.CommandHandler;
import su.plo.voice.groups.group.Group;
import su.plo.voice.groups.group.GroupData;
import su.plo.voice.groups.utils.extend.McCommandSourceKt;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.collections.CollectionsKt;
import su.plo.voice.libs.kotlin.comparisons.ComparisonsKt;
import su.plo.voice.libs.kotlin.jvm.functions.Function1;
import su.plo.voice.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u001bJ,\u0010/\u001a\b\u0012\u0004\u0012\u0002000)2\u0006\u00101\u001a\u0002022\n\b\u0002\u00103\u001a\u0004\u0018\u0001042\n\b\u0002\u00105\u001a\u0004\u0018\u00010\u001bJ\u000e\u00106\u001a\u00020-2\u0006\u0010.\u001a\u00020\u001bJ\u000e\u00107\u001a\u00020\n2\u0006\u00103\u001a\u000204J\u0006\u00108\u001a\u000200J\b\u00109\u001a\u000200H\u0002J\u000e\u0010:\u001a\u00020\n2\u0006\u0010;\u001a\u00020\u0005J\u000e\u0010<\u001a\u00020\n2\u0006\u0010.\u001a\u00020\u001bJ\u0006\u0010=\u001a\u000200J\u0006\u0010>\u001a\u000200J\u0006\u0010?\u001a\u000200J\u0010\u0010@\u001a\u00020-2\u0006\u0010A\u001a\u000200H\u0002J'\u0010B\u001a\u00020-2\u0006\u0010C\u001a\u00020\u00072\u0012\u0010D\u001a\n\u0012\u0006\b\u0001\u0012\u00020F0E\"\u00020F\u00a2\u0006\u0002\u0010GJ\u000e\u0010H\u001a\u00020-2\u0006\u0010.\u001a\u00020\u001bJ\u000e\u0010I\u001a\u00020\n2\u0006\u0010;\u001a\u00020\u0005J\u000e\u0010I\u001a\u00020\n2\u0006\u0010.\u001a\u00020\u001bJ\u000e\u0010J\u001a\u00020\n2\u0006\u0010;\u001a\u00020\u0005J\u000e\u0010J\u001a\u00020\n2\u0006\u0010.\u001a\u00020\u001bJ\u000e\u0010K\u001a\u00020\n2\u0006\u0010.\u001a\u00020\u000fR\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001b0)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006L"}, d2={"Lsu/plo/voice/groups/group/Group;", "Lsu/plo/voice/groups/group/GroupData;", "playerSet", "Lsu/plo/voice/api/server/audio/line/ServerPlayerSet;", "id", "Ljava/util/UUID;", "name", "", "password", "persistent", "", "playersIds", "", "bannedPlayers", "", "Lsu/plo/slib/api/entity/player/McGameProfile;", "owner", "(Lsu/plo/voice/api/server/audio/line/ServerPlayerSet;Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;ZLjava/util/Set;Ljava/util/List;Lsu/plo/slib/api/entity/player/McGameProfile;)V", "joinCommand", "joinCommandWithPassword", "leaveCommand", "onlinePlayerCount", "", "getOnlinePlayerCount", "()I", "onlinePlayers", "", "Lsu/plo/voice/api/server/player/VoicePlayer;", "getOnlinePlayers", "()Ljava/util/Collection;", "permissionsFilter", "Ljava/util/HashSet;", "getPermissionsFilter", "()Ljava/util/HashSet;", "setPermissionsFilter", "(Ljava/util/HashSet;)V", "playerCount", "getPlayerCount", "getPlayerSet", "()Lsu/plo/voice/api/server/audio/line/ServerPlayerSet;", "sortedOnlinePlayers", "", "getSortedOnlinePlayers", "()Ljava/util/List;", "addPlayer", "", "player", "asTextComponents", "Lsu/plo/slib/api/chat/component/McTextComponent;", "handler", "Lsu/plo/voice/groups/command/CommandHandler;", "source", "Lsu/plo/slib/api/command/McCommandSource;", "sourcePlayer", "banPlayer", "hasPermission", "inlineChatComponent", "inviteButton", "isBanned", "playerUuid", "isOwner", "joinButton", "joinButtonWithPassword", "leaveButton", "notifyPlayers", "text", "notifyPlayersTranslatable", "key", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "onPlayerJoin", "onPlayerQuit", "removePlayer", "unbanPlayer", "jar"})
@SourceDebugExtension(value={"SMAP\nGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Group.kt\nsu/plo/voice/groups/group/Group\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n1045#2:207\n1747#2,3:208\n1747#2,3:211\n1855#2,2:214\n2624#2,3:216\n766#2:219\n857#2,2:220\n1#3:222\n*S KotlinDebug\n*F\n+ 1 Group.kt\nsu/plo/voice/groups/group/Group\n*L\n55#1:207\n86#1:208,3\n100#1:211,3\n108#1:214,2\n180#1:216,3\n194#1:219\n194#1:220,2\n*E\n"})
public final class Group
extends GroupData {
    @NotNull
    private final ServerPlayerSet playerSet;
    @NotNull
    private HashSet<String> permissionsFilter;
    @NotNull
    private final String joinCommand;
    @NotNull
    private final String joinCommandWithPassword;
    @NotNull
    private final String leaveCommand;

    public Group(@NotNull ServerPlayerSet playerSet, @NotNull UUID id, @NotNull String name, @Nullable String password, boolean persistent, @NotNull Set<UUID> playersIds, @NotNull List<McGameProfile> bannedPlayers, @Nullable McGameProfile owner) {
        Intrinsics.checkNotNullParameter((Object)playerSet, (String)"playerSet");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(playersIds, (String)"playersIds");
        Intrinsics.checkNotNullParameter(bannedPlayers, (String)"bannedPlayers");
        super(id, name, password, persistent, playersIds, bannedPlayers, owner);
        this.playerSet = playerSet;
        this.permissionsFilter = new HashSet();
        this.joinCommand = "/groups join " + id;
        this.joinCommandWithPassword = "/groups join " + id + ' ' + password;
        this.leaveCommand = "/groups leave";
    }

    public /* synthetic */ Group(ServerPlayerSet serverPlayerSet, UUID uUID, String string, String string2, boolean bl, Set set, List list, McGameProfile mcGameProfile, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            Set set2 = Sets.newConcurrentHashSet();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"newConcurrentHashSet()");
            set = set2;
        }
        if ((n & 0x40) != 0) {
            list = new CopyOnWriteArrayList();
        }
        if ((n & 0x80) != 0) {
            mcGameProfile = null;
        }
        this(serverPlayerSet, uUID, string, string2, bl, set, list, mcGameProfile);
    }

    @NotNull
    public final ServerPlayerSet getPlayerSet() {
        return this.playerSet;
    }

    @NotNull
    public final HashSet<String> getPermissionsFilter() {
        return this.permissionsFilter;
    }

    public final void setPermissionsFilter(@NotNull HashSet<String> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, (String)"<set-?>");
        this.permissionsFilter = hashSet;
    }

    @NotNull
    public final Collection<VoicePlayer> getOnlinePlayers() {
        return this.playerSet.getPlayers();
    }

    public final int getPlayerCount() {
        return this.getPlayersIds().size();
    }

    public final int getOnlinePlayerCount() {
        return this.getOnlinePlayers().size();
    }

    @NotNull
    public final List<VoicePlayer> getSortedOnlinePlayers() {
        Iterable $this$sortedBy$iv = this.getOnlinePlayers();
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                VoicePlayer it = (VoicePlayer)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getInstance().getName());
                it = (VoicePlayer)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getInstance().getName())));
            }
        });
    }

    public final void addPlayer(@NotNull VoicePlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.getPlayersIds().add(player.getInstance().getUuid());
        this.onPlayerJoin(player);
    }

    public final boolean removePlayer(@NotNull VoicePlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.removePlayer(player.getInstance().getUuid());
    }

    public final boolean removePlayer(@NotNull UUID playerUuid) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)playerUuid, (String)"playerUuid");
        boolean it = bl = this.getPlayersIds().remove(playerUuid);
        boolean bl2 = false;
        this.onPlayerQuit(playerUuid);
        return bl;
    }

    public final void onPlayerJoin(@NotNull VoicePlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.playerSet.addPlayer(player);
    }

    public final boolean onPlayerQuit(@NotNull VoicePlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.onPlayerQuit(player.getInstance().getUuid());
    }

    public final boolean onPlayerQuit(@NotNull UUID playerUuid) {
        Intrinsics.checkNotNullParameter((Object)playerUuid, (String)"playerUuid");
        return this.playerSet.removePlayer(playerUuid);
    }

    public final boolean isBanned(@NotNull UUID playerUuid) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)playerUuid, (String)"playerUuid");
            Iterable $this$any$iv = this.getBannedPlayers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    McGameProfile it = (McGameProfile)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)playerUuid)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void banPlayer(@NotNull VoicePlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.getBannedPlayers().add(player.getInstance().getGameProfile());
    }

    public final boolean unbanPlayer(@NotNull McGameProfile player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.getBannedPlayers().removeIf(arg_0 -> Group.unbanPlayer$lambda$3((Function1)new Function1<McGameProfile, Boolean>(player){
            final /* synthetic */ McGameProfile $player;
            {
                this.$player = $player;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull McGameProfile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getId(), (Object)this.$player.getId());
            }
        }, arg_0));
    }

    public final boolean isOwner(@NotNull VoicePlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        McGameProfile mcGameProfile = this.getOwner();
        return Intrinsics.areEqual((Object)(mcGameProfile != null ? mcGameProfile.getId() : null), (Object)player.getInstance().getUuid());
    }

    public final boolean hasPermission(@NotNull McCommandSource source) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (this.permissionsFilter.isEmpty()) {
                return true;
            }
            Iterable $this$any$iv = this.permissionsFilter;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!source.hasPermission(it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void notifyPlayers(McTextComponent text) {
        McTextComponent[] mcTextComponentArray = new McTextComponent[1];
        Object[] objectArray = new Object[]{this.getName()};
        mcTextComponentArray[0] = McTextComponent.Companion.translatable("pv.addon.groups.format.group_name", objectArray);
        McTextComponent mcTextComponent = McTextComponent.Companion.empty().append(mcTextComponentArray);
        mcTextComponentArray = new McTextComponent[]{McTextComponent.Companion.literal(" ")};
        McTextComponent mcTextComponent2 = mcTextComponent.append(mcTextComponentArray);
        mcTextComponentArray = new McTextComponent[]{text};
        McTextComponent component = mcTextComponent2.append(mcTextComponentArray);
        Iterable $this$forEach$iv = this.getOnlinePlayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VoicePlayer it = (VoicePlayer)element$iv;
            boolean bl = false;
            it.getInstance().sendMessage(component);
        }
    }

    public final void notifyPlayersTranslatable(@NotNull String key, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.notifyPlayers((McTextComponent)McTextComponent.Companion.translatable(key, Arrays.copyOf(args, args.length)));
    }

    @NotNull
    public final McTextComponent joinButton() {
        McTranslatableText it = McTextComponent.Companion.translatable("pv.addon.groups.button.join", new Object[0]);
        boolean bl = false;
        return (this.getPassword() == null ? it.clickEvent(McTextClickEvent.Companion.runCommand(this.joinCommand)) : it.clickEvent(McTextClickEvent.Companion.suggestCommand(this.joinCommand + ' '))).hoverEvent(McTextHoverEvent.Companion.showText((McTextComponent)McTextComponent.Companion.literal(this.joinCommand)));
    }

    @NotNull
    public final McTextComponent joinButtonWithPassword() {
        McTranslatableText it = McTextComponent.Companion.translatable("pv.addon.groups.button.join", new Object[0]);
        boolean bl = false;
        return this.getPassword() == null ? it.clickEvent(McTextClickEvent.Companion.runCommand(this.joinCommand)).hoverEvent(McTextHoverEvent.Companion.showText((McTextComponent)McTextComponent.Companion.literal(this.joinCommand))) : it.clickEvent(McTextClickEvent.Companion.runCommand(this.joinCommandWithPassword)).hoverEvent(McTextHoverEvent.Companion.showText((McTextComponent)McTextComponent.Companion.literal(this.joinCommand + " *******")));
    }

    @NotNull
    public final McTextComponent inlineChatComponent() {
        Object[] objectArray = new Object[]{this.getName()};
        return (McTextComponent)McTextComponent.Companion.translatable("pv.addon.groups.format.group_name", objectArray);
    }

    @NotNull
    public final McTextComponent leaveButton() {
        McTextComponent[] mcTextComponentArray = new McTextComponent[]{McTextComponent.Companion.literal("  ")};
        McTextComponent mcTextComponent = McTextComponent.Companion.translatable("pv.addon.groups.button.leave", new Object[0]).clickEvent(McTextClickEvent.Companion.runCommand(this.leaveCommand)).hoverEvent(McTextHoverEvent.Companion.showText((McTextComponent)McTextComponent.Companion.literal(this.leaveCommand))).append(mcTextComponentArray);
        mcTextComponentArray = new McTextComponent[]{this.inviteButton()};
        return mcTextComponent.append(mcTextComponentArray);
    }

    private final McTextComponent inviteButton() {
        return McTextComponent.Companion.translatable("pv.addon.groups.button.invite", new Object[0]).clickEvent(McTextClickEvent.Companion.suggestCommand("/groups invite ")).hoverEvent(McTextHoverEvent.Companion.showText((McTextComponent)McTextComponent.Companion.literal("/groups invite")));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final List<McTextComponent> asTextComponents(@NotNull CommandHandler handler, @Nullable McCommandSource source, @Nullable VoicePlayer sourcePlayer) {
        block10: {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            var4_4 = new McTextComponent[3];
            if (this.getPassword() != null) {
                var5_5 = new McTextComponent[]{McTextComponent.Companion.literal(" ")};
                v0 = McTextComponent.Companion.translatable("pv.addon.groups.icons.password_protected", new Object[0]).append((McTextComponent[])var5_5).hoverEvent(McTextHoverEvent.Companion.showText((McTextComponent)McTextComponent.Companion.translatable("pv.addon.groups.tooltip.password_protected", new Object[0])));
            } else {
                v0 = McTextComponent.Companion.empty();
            }
            var5_5 = new McTextComponent[1];
            var6_6 = new Object[]{this.getName()};
            v1 = McTextComponent.Companion.translatable("pv.addon.groups.format.group_name", var6_6);
            var6_6 = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)this.getId().toString(), (String)"id.toString()");
            v2 = v1.hoverEvent(McTextHoverEvent.Companion.showText((McTextComponent)McTextComponent.Companion.translatable("pv.addon.groups.tooltip.group_uuid", var6_6)));
            v3 = this.getId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"id.toString()");
            var5_5[0] = v2.clickEvent(McTextClickEvent.Companion.suggestCommand(v3));
            var4_4[0] = v0.append((McTextComponent[])var5_5);
            v4 = var4_4;
            v5 = 1;
            if (this.getOwner() == null) ** GOTO lbl-1000
            var5_5 = handler.getAddon().getVisibleOnlinePlayers(sourcePlayer);
            var19_9 = v5;
            var18_10 = v4;
            $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                v6 = true;
            } else {
                for (T element$iv : $this$none$iv) {
                    it = (VoicePlayer)element$iv;
                    $i$a$-none-Group$asTextComponents$1 = false;
                    v7 = this.getOwner();
                    Intrinsics.checkNotNull((Object)v7);
                    if (!Intrinsics.areEqual((Object)v7.getId(), (Object)it.getInstance().getUuid())) continue;
                    v6 = false;
                    break block10;
                }
                v6 = true;
            }
        }
        var20_19 = v6;
        v4 = var18_10;
        v5 = var19_9;
        if (var20_19) lbl-1000:
        // 2 sources

        {
            var5_5 = new Object[]{this.getOnlinePlayerCount()};
            v8 = McTextComponent.Companion.translatable("pv.addon.groups.format.only_players", var5_5);
        } else {
            var5_5 = new Object[2];
            var5_5[0] = this.getOnlinePlayerCount();
            v9 = this.getOwner();
            Intrinsics.checkNotNull((Object)v9);
            var5_5[1] = v9.getName();
            v8 = McTextComponent.Companion.translatable("pv.addon.groups.format.players_and_owner", var5_5);
        }
        $i$f$none = this.getSortedOnlinePlayers();
        var22_21 = McTextComponent.Companion;
        var21_22 = McTextHoverEvent.Companion;
        var20_20 /* !! */  = v8;
        var19_9 = v5;
        var18_10 = v4;
        $i$a$-let-Group$asTextComponents$2 = false;
        visiblePlayers = handler.getAddon().getVisibleOnlinePlayers(sourcePlayer);
        $this$filter$iv = this.getSortedOnlinePlayers();
        $i$f$filter = false;
        var11_23 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (VoicePlayer)element$iv$iv;
            $i$a$-filter-Group$asTextComponents$2$1 = false;
            if (!visiblePlayers.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        var23_30 = (List)destination$iv$iv;
        var18_10[var19_9] = var20_20 /* !! */ .hoverEvent(var21_22.showText((McTextComponent)var22_21.literal(CollectionsKt.joinToString$default((Iterable)var23_30, (CharSequence)", ", null, null, (int)0, null, (Function1)asTextComponents.3.INSTANCE, (int)30, null))));
        v10 = var4_4;
        v11 = 2;
        if (source != null && (var5_5 = McCommandSourceKt.getVoicePlayer(source, handler.getVoiceServer())) != null) {
            $i$a$-let-Group$asTextComponents$2 = var5_5;
            var19_9 = v11;
            var18_10 = v10;
            $i$a$-let-Group$asTextComponents$4 = false;
            var20_20 /* !! */  = handler.getGroupManager().getGroupByPlayer().get(it.getInstance().getUuid());
            v10 = var18_10;
            v11 = var19_9;
            v12 = var20_20 /* !! */ ;
        } else {
            v12 = null;
        }
        it = v12;
        var19_9 = v11;
        var18_10 = v10;
        $i$a$-let-Group$asTextComponents$5 = false;
        v13 = it;
        var20_20 /* !! */  = Intrinsics.areEqual((Object)this.getId(), (Object)(v13 != null ? v13.getId() : null)) != false ? this.leaveButton() : this.joinButton();
        var18_10[var19_9] = var20_20 /* !! */ ;
        return CollectionsKt.listOf((Object[])var4_4);
    }

    public static /* synthetic */ List asTextComponents$default(Group group, CommandHandler commandHandler, McCommandSource mcCommandSource, VoicePlayer voicePlayer, int n, Object object) {
        if ((n & 2) != 0) {
            mcCommandSource = null;
        }
        if ((n & 4) != 0) {
            McCommandSource mcCommandSource2 = mcCommandSource;
            voicePlayer = mcCommandSource2 != null ? McCommandSourceKt.getVoicePlayer(mcCommandSource2, commandHandler.getVoiceServer()) : null;
        }
        return group.asTextComponents(commandHandler, mcCommandSource, voicePlayer);
    }

    private static final boolean unbanPlayer$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

