/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.groups.command.subcommand;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import su.plo.slib.api.command.McCommandSource;
import su.plo.slib.api.permission.PermissionDefault;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.groups.command.CommandHandler;
import su.plo.voice.groups.command.SubCommand;
import su.plo.voice.groups.group.Group;
import su.plo.voice.groups.utils.extend.McCommandSourceKt;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.Pair;
import su.plo.voice.libs.kotlin.TuplesKt;
import su.plo.voice.libs.kotlin.collections.ArraysKt;
import su.plo.voice.libs.kotlin.collections.CollectionsKt;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;
import su.plo.voice.libs.kotlin.text.StringsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J#\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J)\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017H\u0016\u00a2\u0006\u0002\u0010\u001aR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR&\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lsu/plo/voice/groups/command/subcommand/UnsetCommand;", "Lsu/plo/voice/groups/command/SubCommand;", "handler", "Lsu/plo/voice/groups/command/CommandHandler;", "(Lsu/plo/voice/groups/command/CommandHandler;)V", "name", "", "getName", "()Ljava/lang/String;", "permissions", "", "Lsu/plo/voice/libs/kotlin/Pair;", "Lsu/plo/slib/api/permission/PermissionDefault;", "getPermissions", "()Ljava/util/List;", "unsetFlags", "checkCanExecute", "", "source", "Lsu/plo/slib/api/command/McCommandSource;", "execute", "", "arguments", "", "(Lsu/plo/slib/api/command/McCommandSource;[Ljava/lang/String;)V", "suggest", "(Lsu/plo/slib/api/command/McCommandSource;[Ljava/lang/String;)Ljava/util/List;", "jar"})
@SourceDebugExtension(value={"SMAP\nUnsetCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsetCommand.kt\nsu/plo/voice/groups/command/subcommand/UnsetCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n766#2:109\n857#2,2:110\n766#2:112\n857#2,2:113\n*S KotlinDebug\n*F\n+ 1 UnsetCommand.kt\nsu/plo/voice/groups/command/subcommand/UnsetCommand\n*L\n29#1:109\n29#1:110,2\n59#1:112\n59#1:113,2\n*E\n"})
public final class UnsetCommand
extends SubCommand {
    @NotNull
    private final String name;
    @NotNull
    private final List<Pair<String, PermissionDefault>> permissions;
    @NotNull
    private final List<String> unsetFlags;

    public UnsetCommand(@NotNull CommandHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        super(handler);
        this.name = "unset";
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"unset.owner", (Object)PermissionDefault.TRUE), TuplesKt.to((Object)"unset.*", (Object)PermissionDefault.OP), TuplesKt.to((Object)"unset.all", (Object)PermissionDefault.OP)};
        this.permissions = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"password", "permissions"};
        this.unsetFlags = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<Pair<String, PermissionDefault>> getPermissions() {
        return this.permissions;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> suggest(@NotNull McCommandSource source, @NotNull String[] arguments) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        String string = (String)ArraysKt.getOrNull((Object[])arguments, (int)1);
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String flagName = string;
        if (arguments.length == 2) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.unsetFlags;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!(StringsKt.startsWith$default((String)it, (String)flagName, (boolean)false, (int)2, null) && McCommandSourceKt.hasFlagPermission(source, it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(@NotNull McCommandSource source, @NotNull String[] arguments) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        VoicePlayer voicePlayer = McCommandSourceKt.getVoicePlayer(source, this.getHandler().getVoiceServer());
        if (voicePlayer == null) {
            McCommandSourceKt.playerOnlyCommandError(source);
            return;
        }
        VoicePlayer player = voicePlayer;
        Group group = this.getHandler().getGroupManager().getGroupByPlayer().get(player.getInstance().getUuid());
        if (group == null) {
            McCommandSourceKt.notInGroupError(source);
            return;
        }
        Group group2 = group;
        boolean isOwner = group2.isOwner(player);
        if (!(McCommandSourceKt.hasAddonPermission(source, "unset.all") || McCommandSourceKt.hasAddonPermission(source, "unset.*") || McCommandSourceKt.hasAddonPermission(source, "unset.owner") && isOwner)) {
            McCommandSourceKt.noPermissionError(source, isOwner ? "unset.owner" : "unset.all");
            return;
        }
        String string = (String)ArraysKt.getOrNull((Object[])arguments, (int)1);
        if (string == null) {
            UnsetCommand $this$execute_u24lambda_u241 = this;
            boolean bl = false;
            McCommandSourceKt.sendTranslatable(source, "pv.addon.groups.command.unset.error.usage", new Object[0]);
            return;
        }
        String flagName = string;
        if (!this.unsetFlags.contains(flagName)) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Object[] objectArray = new Object[2];
            objectArray[0] = flagName;
            Iterable iterable = this.unsetFlags;
            int n = 1;
            Object[] objectArray2 = objectArray;
            String string2 = "pv.addon.groups.command.set.error.unknown_flag";
            McCommandSource mcCommandSource = source;
            boolean $i$f$filter = false;
            void bl = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (!McCommandSourceKt.hasFlagPermission(source, it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            objectArray2[n] = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            McCommandSourceKt.sendTranslatable(mcCommandSource, string2, objectArray);
            return;
        }
        if (!McCommandSourceKt.hasFlagPermission(source, flagName)) {
            McCommandSourceKt.noPermissionError(source, "flag." + flagName);
            return;
        }
        String string3 = flagName;
        if (Intrinsics.areEqual((Object)string3, (Object)"password")) {
            if (group2.getPassword() == null) {
                McCommandSourceKt.sendTranslatable(source, "pv.addon.groups.command.set.error.password_not_set", new Object[0]);
                return;
            }
            group2.setPassword(null);
            group2.notifyPlayersTranslatable("pv.addon.groups.notifications.password_unset", new Object[0]);
        } else if (Intrinsics.areEqual((Object)string3, (Object)"permissions")) {
            if (group2.getPermissionsFilter().isEmpty()) {
                McCommandSourceKt.sendTranslatable(source, "pv.addon.groups.command.set.error.permissions_not_set", new Object[0]);
                return;
            }
            group2.getPermissionsFilter().clear();
            group2.notifyPlayersTranslatable("pv.addon.groups.notifications.permissions_unset", new Object[0]);
        } else {
            McCommandSourceKt.sendTranslatable(source, "pv.addon.groups.error.unknown", new Object[0]);
            return;
        }
    }

    @Override
    public boolean checkCanExecute(@NotNull McCommandSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        VoicePlayer voicePlayer = McCommandSourceKt.getVoicePlayer(source, this.getHandler().getVoiceServer());
        if (voicePlayer == null) {
            return false;
        }
        VoicePlayer player = voicePlayer;
        Group group = this.getHandler().getGroupManager().getGroupByPlayer().get(player.getInstance().getUuid());
        if (group == null) {
            return false;
        }
        Group group2 = group;
        boolean isOwner = group2.isOwner(player);
        return McCommandSourceKt.hasAddonPermission(source, "unset.owner") && isOwner ? true : (McCommandSourceKt.hasAddonPermission(source, "unset.all") ? true : McCommandSourceKt.hasAddonPermission(source, "unset.*"));
    }
}

