/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.groups.command.subcommand;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import su.plo.slib.api.command.McCommandSource;
import su.plo.slib.api.entity.player.McGameProfile;
import su.plo.slib.api.permission.PermissionDefault;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.groups.command.CommandHandler;
import su.plo.voice.groups.command.SubCommand;
import su.plo.voice.groups.group.Group;
import su.plo.voice.groups.utils.extend.McCommandSourceKt;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.Pair;
import su.plo.voice.libs.kotlin.TuplesKt;
import su.plo.voice.libs.kotlin.collections.ArraysKt;
import su.plo.voice.libs.kotlin.collections.CollectionsKt;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;
import su.plo.voice.libs.kotlin.text.StringsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J#\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J)\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016H\u0016\u00a2\u0006\u0002\u0010\u0019R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR&\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lsu/plo/voice/groups/command/subcommand/TransferCommand;", "Lsu/plo/voice/groups/command/SubCommand;", "handler", "Lsu/plo/voice/groups/command/CommandHandler;", "(Lsu/plo/voice/groups/command/CommandHandler;)V", "name", "", "getName", "()Ljava/lang/String;", "permissions", "", "Lsu/plo/voice/libs/kotlin/Pair;", "Lsu/plo/slib/api/permission/PermissionDefault;", "getPermissions", "()Ljava/util/List;", "checkCanExecute", "", "source", "Lsu/plo/slib/api/command/McCommandSource;", "execute", "", "arguments", "", "(Lsu/plo/slib/api/command/McCommandSource;[Ljava/lang/String;)V", "suggest", "(Lsu/plo/slib/api/command/McCommandSource;[Ljava/lang/String;)Ljava/util/List;", "jar"})
@SourceDebugExtension(value={"SMAP\nTransferCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransferCommand.kt\nsu/plo/voice/groups/command/subcommand/TransferCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1549#2:107\n1620#2,3:108\n766#2:111\n857#2,2:112\n288#2,2:114\n1#3:116\n*S KotlinDebug\n*F\n+ 1 TransferCommand.kt\nsu/plo/voice/groups/command/subcommand/TransferCommand\n*L\n33#1:107\n33#1:108,3\n34#1:111\n34#1:112,2\n74#1:114,2\n*E\n"})
public final class TransferCommand
extends SubCommand {
    @NotNull
    private final String name;
    @NotNull
    private final List<Pair<String, PermissionDefault>> permissions;

    public TransferCommand(@NotNull CommandHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        super(handler);
        this.name = "transfer";
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"transfer.owner", (Object)PermissionDefault.TRUE), TuplesKt.to((Object)"transfer.all", (Object)PermissionDefault.OP), TuplesKt.to((Object)"transfer.*", (Object)PermissionDefault.OP)};
        this.permissions = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<Pair<String, PermissionDefault>> getPermissions() {
        return this.permissions;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> suggest(@NotNull McCommandSource source, @NotNull String[] arguments) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        if (arguments.length != 2) {
            return CollectionsKt.emptyList();
        }
        String string = (String)ArraysKt.getOrNull((Object[])arguments, (int)1);
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String arg = string;
        VoicePlayer player = McCommandSourceKt.getVoicePlayer(source, this.getHandler().getVoiceServer());
        Iterable iterable = this.getHandler().getAddon().getVisibleOnlinePlayers(player);
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            VoicePlayer voicePlayer = (VoicePlayer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getInstance().getName());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VoicePlayer voicePlayer;
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(StringsKt.startsWith$default((String)it, (String)arg, (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)it, (voicePlayer = player) != null && (voicePlayer = voicePlayer.getInstance()) != null ? voicePlayer.getName() : null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(@NotNull McCommandSource source, @NotNull String[] arguments) {
        block8: {
            Object v3;
            Group group;
            VoicePlayer player;
            block7: {
                void $this$firstOrNull$iv;
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
                VoicePlayer voicePlayer = McCommandSourceKt.getVoicePlayer(source, this.getHandler().getVoiceServer());
                if (voicePlayer == null) {
                    TransferCommand $this$execute_u24lambda_u242 = this;
                    boolean bl = false;
                    McCommandSourceKt.playerOnlyCommandError(source);
                    return;
                }
                player = voicePlayer;
                Group group2 = this.getHandler().getGroupManager().getGroupByPlayer().get(player.getInstance().getUuid());
                if (group2 == null) {
                    TransferCommand $this$execute_u24lambda_u243 = this;
                    boolean bl = false;
                    McCommandSourceKt.notInGroupError(source);
                    return;
                }
                group = group2;
                boolean isOwner = group.isOwner(player);
                if (!(McCommandSourceKt.hasAddonPermission(source, "transfer.all") || McCommandSourceKt.hasAddonPermission(source, "transfer.*") || McCommandSourceKt.hasAddonPermission(source, "transfer.owner") && isOwner)) {
                    McCommandSourceKt.noPermissionError(source, isOwner ? "transfer.owner" : "transfer.all");
                    return;
                }
                String string = (String)ArraysKt.getOrNull((Object[])arguments, (int)1);
                if (string == null) {
                    TransferCommand $this$execute_u24lambda_u244 = this;
                    boolean bl = false;
                    McCommandSourceKt.sendTranslatable(source, "pv.addon.groups.command.transfer.error.usage", new Object[0]);
                    return;
                }
                String playerName = string;
                Iterable $this$execute_u24lambda_u244 = this.getHandler().getAddon().getVisibleOnlinePlayers(player);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    VoicePlayer it = (VoicePlayer)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getInstance().getName(), (Object)playerName)) continue;
                    v3 = element$iv;
                    break block7;
                }
                v3 = null;
            }
            VoicePlayer voicePlayer = v3;
            if (voicePlayer == null) {
                TransferCommand $this$execute_u24lambda_u246 = this;
                boolean bl = false;
                McCommandSourceKt.sendTranslatable(source, "pv.addon.groups.error.player_not_found", new Object[0]);
                return;
            }
            VoicePlayer newOwner = voicePlayer;
            if (Intrinsics.areEqual((Object)newOwner.getInstance().getName(), (Object)player.getInstance().getName())) {
                McCommandSourceKt.sendTranslatable(source, "pv.addon.groups.command.transfer.error.already_owner", new Object[0]);
                return;
            }
            group.setOwner(newOwner.getInstance().getGameProfile());
            McGameProfile mcGameProfile = group.getOwner();
            if (mcGameProfile == null) break block8;
            McGameProfile it = mcGameProfile;
            boolean bl = false;
            Object[] objectArray = new Object[]{it.getName()};
            group.notifyPlayersTranslatable("pv.addon.groups.notifications.new_owner", objectArray);
        }
    }

    @Override
    public boolean checkCanExecute(@NotNull McCommandSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        VoicePlayer voicePlayer = McCommandSourceKt.getVoicePlayer(source, this.getHandler().getVoiceServer());
        if (voicePlayer == null) {
            return false;
        }
        VoicePlayer player = voicePlayer;
        Group group = this.getHandler().getGroupManager().getGroupByPlayer().get(player.getInstance().getUuid());
        if (group == null) {
            return false;
        }
        Group group2 = group;
        boolean isOwner = group2.isOwner(player);
        return McCommandSourceKt.hasAddonPermission(source, "transfer.owner") && isOwner ? true : (McCommandSourceKt.hasAddonPermission(source, "transfer.all") ? true : McCommandSourceKt.hasAddonPermission(source, "transfer.*"));
    }
}

