/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.groups.command.subcommand;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import su.plo.slib.api.command.McCommandSource;
import su.plo.slib.api.entity.player.McPlayer;
import su.plo.slib.api.permission.PermissionDefault;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.groups.command.CommandHandler;
import su.plo.voice.groups.command.SubCommand;
import su.plo.voice.groups.group.Group;
import su.plo.voice.groups.utils.extend.McCommandSourceKt;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.Pair;
import su.plo.voice.libs.kotlin.TuplesKt;
import su.plo.voice.libs.kotlin.collections.ArraysKt;
import su.plo.voice.libs.kotlin.collections.CollectionsKt;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;
import su.plo.voice.libs.kotlin.text.StringsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J#\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J)\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016H\u0016\u00a2\u0006\u0002\u0010\u0019R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR&\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lsu/plo/voice/groups/command/subcommand/SetCommand;", "Lsu/plo/voice/groups/command/SubCommand;", "handler", "Lsu/plo/voice/groups/command/CommandHandler;", "(Lsu/plo/voice/groups/command/CommandHandler;)V", "name", "", "getName", "()Ljava/lang/String;", "permissions", "", "Lsu/plo/voice/libs/kotlin/Pair;", "Lsu/plo/slib/api/permission/PermissionDefault;", "getPermissions", "()Ljava/util/List;", "checkCanExecute", "", "source", "Lsu/plo/slib/api/command/McCommandSource;", "execute", "", "arguments", "", "(Lsu/plo/slib/api/command/McCommandSource;[Ljava/lang/String;)V", "suggest", "(Lsu/plo/slib/api/command/McCommandSource;[Ljava/lang/String;)Ljava/util/List;", "jar"})
@SourceDebugExtension(value={"SMAP\nSetCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetCommand.kt\nsu/plo/voice/groups/command/subcommand/SetCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n766#2:167\n857#2,2:168\n766#2:170\n857#2,2:171\n1549#2:173\n1620#2,3:174\n766#2:177\n857#2,2:178\n1855#2,2:180\n*S KotlinDebug\n*F\n+ 1 SetCommand.kt\nsu/plo/voice/groups/command/subcommand/SetCommand\n*L\n24#1:167\n24#1:168,2\n62#1:170\n62#1:171,2\n110#1:173\n110#1:174,3\n124#1:177\n124#1:178,2\n125#1:180,2\n*E\n"})
public final class SetCommand
extends SubCommand {
    @NotNull
    private final String name;
    @NotNull
    private final List<Pair<String, PermissionDefault>> permissions;

    public SetCommand(@NotNull CommandHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        super(handler);
        this.name = "set";
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"set.owner", (Object)PermissionDefault.TRUE), TuplesKt.to((Object)"set.*", (Object)PermissionDefault.OP), TuplesKt.to((Object)"set.all", (Object)PermissionDefault.OP)};
        this.permissions = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<Pair<String, PermissionDefault>> getPermissions() {
        return this.permissions;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> suggest(@NotNull McCommandSource source, @NotNull String[] arguments) {
        List list;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        String string = (String)ArraysKt.getOrNull((Object[])arguments, (int)1);
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String flagName = string;
        if (arguments.length == 2) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.getHandler().getFlags().keySet();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!(StringsKt.startsWith$default((String)it, (String)flagName, (boolean)false, (int)2, null) && McCommandSourceKt.hasFlagPermission(source, it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        if (!McCommandSourceKt.hasFlagPermission(source, flagName)) {
            return CollectionsKt.emptyList();
        }
        if (Intrinsics.areEqual((Object)flagName, (Object)"name")) {
            list = CollectionsKt.listOf((Object)this.getHandler().getTranslationByKey("pv.addon.groups.arg.name", source));
        } else if (Intrinsics.areEqual((Object)flagName, (Object)"password") && arguments.length == 3) {
            list = CollectionsKt.listOf((Object)this.getHandler().getTranslationByKey("pv.addon.groups.arg.password", source));
        } else if (Intrinsics.areEqual((Object)flagName, (Object)"permissions")) {
            list = CollectionsKt.listOf((Object)this.getHandler().getTranslationByKey("pv.addon.groups.arg.permissions", source));
        } else if (Intrinsics.areEqual((Object)flagName, (Object)"persistent") && arguments.length == 3) {
            Object[] objectArray = new String[]{"true", "false"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(@NotNull McCommandSource source, @NotNull String[] arguments) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        VoicePlayer voicePlayer = McCommandSourceKt.getVoicePlayer(source, this.getHandler().getVoiceServer());
        if (voicePlayer == null) {
            McCommandSourceKt.playerOnlyCommandError(source);
            return;
        }
        VoicePlayer player = voicePlayer;
        Group group = this.getHandler().getGroupManager().getGroupByPlayer().get(player.getInstance().getUuid());
        if (group == null) {
            McCommandSourceKt.notInGroupError(source);
            return;
        }
        Group group2 = group;
        boolean isOwner = group2.isOwner(player);
        if (!(McCommandSourceKt.hasAddonPermission(source, "set.all") || McCommandSourceKt.hasAddonPermission(source, "set.*") || McCommandSourceKt.hasAddonPermission(source, "set.owner") && isOwner)) {
            McCommandSourceKt.noPermissionError(source, isOwner ? "set.owner" : "set.all");
            return;
        }
        String string = (String)ArraysKt.getOrNull((Object[])arguments, (int)1);
        if (string == null) {
            SetCommand $this$execute_u24lambda_u241 = this;
            boolean bl = false;
            McCommandSourceKt.sendTranslatable(source, "pv.addon.groups.command.set.error.usage", new Object[0]);
            return;
        }
        String flagName = string;
        if (!this.getHandler().getFlags().keySet().contains(flagName)) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Object[] objectArray = new Object[2];
            objectArray[0] = flagName;
            Iterable iterable = this.getHandler().getFlags().keySet();
            int n = 1;
            Object[] objectArray2 = objectArray;
            String string2 = "pv.addon.groups.command.set.error.unknown_flag";
            McCommandSource mcCommandSource = source;
            boolean $i$f$filter = false;
            void bl = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (!McCommandSourceKt.hasFlagPermission(source, it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            objectArray2[n] = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            McCommandSourceKt.sendTranslatable(mcCommandSource, string2, objectArray);
            return;
        }
        if (!McCommandSourceKt.hasFlagPermission(source, flagName)) {
            McCommandSourceKt.noPermissionError(source, "flag." + flagName);
            return;
        }
        if ((String)ArraysKt.getOrNull((Object[])arguments, (int)2) == null) {
            SetCommand $this$execute_u24lambda_u243 = this;
            boolean bl = false;
            McCommandSourceKt.sendTranslatable(source, "pv.addon.groups.command.set.error.usage", new Object[0]);
            return;
        }
        String flagValue = CollectionsKt.joinToString$default((Iterable)ArraysKt.drop((Object[])arguments, (int)2), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        switch (flagName) {
            case "name": {
                if (Intrinsics.areEqual((Object)group2.getName(), (Object)flagValue)) {
                    McCommandSourceKt.sendTranslatable(source, "pv.addon.groups.command.set.error.identical_value", new Object[0]);
                    return;
                }
                int min = this.getHandler().getGroupManager().getConfig().getMinimumNameLength();
                int max = this.getHandler().getGroupManager().getConfig().getMaximumNameLength();
                int destination$iv$iv = flagValue.length();
                if (!(min <= destination$iv$iv ? destination$iv$iv <= max : false)) {
                    McCommandSourceKt.sendTranslatable(source, "pv.addon.groups.error.name_length", new Object[0]);
                    return;
                }
                String oldName = group2.getName();
                group2.setName(flagValue);
                Object[] $i$f$filterTo = new Object[]{oldName, group2.getName()};
                group2.notifyPlayersTranslatable("pv.addon.groups.notifications.name_change", $i$f$filterTo);
                break;
            }
            case "password": {
                if (Intrinsics.areEqual((Object)group2.getPassword(), (Object)flagValue)) {
                    McCommandSourceKt.sendTranslatable(source, "pv.addon.groups.command.set.error.identical_value", new Object[0]);
                    return;
                }
                group2.setPassword(flagValue);
                group2.notifyPlayersTranslatable("pv.addon.groups.notifications.password_changed", new Object[0]);
                break;
            }
            case "permissions": {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                VoicePlayer it;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Object max = new String[]{","};
                max = StringsKt.split$default((CharSequence)flagValue, (String[])max, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map = false;
                void $i$f$filterTo = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string3 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
                }
                HashSet newValue = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
                if (Intrinsics.areEqual(group2.getPermissionsFilter(), (Object)newValue)) {
                    McCommandSourceKt.sendTranslatable(source, "pv.addon.groups.command.set.error.identical_value", new Object[0]);
                    return;
                }
                group2.setPermissionsFilter(newValue);
                group2.notifyPlayersTranslatable("pv.addon.groups.notifications.permissions_changed", new Object[0]);
                $this$map$iv = group2.getOnlinePlayers();
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (VoicePlayer)element$iv$iv;
                    boolean bl = false;
                    McPlayer mcPlayer = it.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)mcPlayer, (String)"it.instance");
                    if (!(!group2.hasPermission((McCommandSource)mcPlayer))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    VoicePlayer it2 = (VoicePlayer)element$iv;
                    boolean bl = false;
                    this.getHandler().getGroupManager().leave(it2);
                    McPlayer mcPlayer = it2.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)mcPlayer, (String)"it.instance");
                    McCommandSourceKt.sendTranslatable((McCommandSource)mcPlayer, "pv.addon.groups.notifications.kicked", new Object[0]);
                    Object[] objectArray = new Object[]{it2.getInstance().getName()};
                    group2.notifyPlayersTranslatable("pv.addon.groups.notifications.player_kicked", objectArray);
                }
                break;
            }
            case "persistent": {
                boolean newValue;
                Boolean bl = StringsKt.toBooleanStrictOrNull((String)flagValue);
                boolean bl3 = newValue = bl != null ? bl : false;
                if (group2.getPersistent() == newValue) {
                    McCommandSourceKt.sendTranslatable(source, "pv.addon.groups.command.set.error.identical_value", new Object[0]);
                    return;
                }
                group2.setPersistent(newValue);
                if (group2.getPersistent()) {
                    group2.notifyPlayersTranslatable("pv.addon.groups.notifications.persistent_true", new Object[0]);
                    break;
                }
                group2.notifyPlayersTranslatable("pv.addon.groups.notifications.persistent_false", new Object[0]);
                break;
            }
            default: {
                McCommandSourceKt.sendTranslatable(source, "pv.addon.groups.error.unknown", new Object[0]);
                return;
            }
        }
    }

    @Override
    public boolean checkCanExecute(@NotNull McCommandSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        VoicePlayer voicePlayer = McCommandSourceKt.getVoicePlayer(source, this.getHandler().getVoiceServer());
        if (voicePlayer == null) {
            return false;
        }
        VoicePlayer player = voicePlayer;
        Group group = this.getHandler().getGroupManager().getGroupByPlayer().get(player.getInstance().getUuid());
        if (group == null) {
            return false;
        }
        Group group2 = group;
        boolean isOwner = group2.isOwner(player);
        return McCommandSourceKt.hasAddonPermission(source, "set.owner") && isOwner ? true : (McCommandSourceKt.hasAddonPermission(source, "set.all") ? true : McCommandSourceKt.hasAddonPermission(source, "set.*"));
    }
}

