/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.groups.command.subcommand;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import su.plo.slib.api.command.McCommandSource;
import su.plo.slib.api.permission.PermissionDefault;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.groups.command.CommandHandler;
import su.plo.voice.groups.command.SubCommand;
import su.plo.voice.groups.group.Group;
import su.plo.voice.groups.utils.extend.McCommandSourceKt;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.Pair;
import su.plo.voice.libs.kotlin.TuplesKt;
import su.plo.voice.libs.kotlin.collections.ArraysKt;
import su.plo.voice.libs.kotlin.collections.CollectionsKt;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J3\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ#\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0019H\u0016\u00a2\u0006\u0002\u0010\u001dJ)\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0019H\u0016\u00a2\u0006\u0002\u0010\u001fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR&\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lsu/plo/voice/groups/command/subcommand/JoinCommand;", "Lsu/plo/voice/groups/command/SubCommand;", "handler", "Lsu/plo/voice/groups/command/CommandHandler;", "(Lsu/plo/voice/groups/command/CommandHandler;)V", "name", "", "getName", "()Ljava/lang/String;", "permissions", "", "Lsu/plo/voice/libs/kotlin/Pair;", "Lsu/plo/slib/api/permission/PermissionDefault;", "getPermissions", "()Ljava/util/List;", "checkCanExecute", "", "source", "Lsu/plo/slib/api/command/McCommandSource;", "checkCantJoin", "group", "Lsu/plo/voice/groups/group/Group;", "player", "Lsu/plo/voice/api/server/player/VoicePlayer;", "arguments", "", "(Lsu/plo/voice/groups/group/Group;Lsu/plo/voice/api/server/player/VoicePlayer;Lsu/plo/slib/api/command/McCommandSource;[Ljava/lang/String;)Z", "execute", "", "(Lsu/plo/slib/api/command/McCommandSource;[Ljava/lang/String;)V", "suggest", "(Lsu/plo/slib/api/command/McCommandSource;[Ljava/lang/String;)Ljava/util/List;", "jar"})
@SourceDebugExtension(value={"SMAP\nJoinCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JoinCommand.kt\nsu/plo/voice/groups/command/subcommand/JoinCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1549#2:125\n1620#2,3:126\n37#3,2:129\n1#4:131\n*S KotlinDebug\n*F\n+ 1 JoinCommand.kt\nsu/plo/voice/groups/command/subcommand/JoinCommand\n*L\n22#1:125\n22#1:126,3\n22#1:129,2\n*E\n"})
public final class JoinCommand
extends SubCommand {
    @NotNull
    private final String name;
    @NotNull
    private final List<Pair<String, PermissionDefault>> permissions;

    public JoinCommand(@NotNull CommandHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        super(handler);
        this.name = "join";
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"join", (Object)PermissionDefault.TRUE), TuplesKt.to((Object)"join.all", (Object)PermissionDefault.OP), TuplesKt.to((Object)"join.*", (Object)PermissionDefault.OP)};
        this.permissions = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<Pair<String, PermissionDefault>> getPermissions() {
        return this.permissions;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> suggest(@NotNull McCommandSource source, @NotNull String[] arguments) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Iterable iterable = this.getPermissions();
        McCommandSource mcCommandSource = source;
        CommandHandler commandHandler = this.getHandler();
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getFirst());
        }
        collection = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        if (!commandHandler.hasPermission(mcCommandSource, thisCollection$iv.toArray(new String[0]))) {
            return CollectionsKt.emptyList();
        }
        if (arguments.length == 2) {
            return CollectionsKt.listOf((Object)this.getHandler().getTranslationByKey("pv.addon.groups.arg.groups_uuid", source));
        }
        if (arguments.length == 3) {
            UUID it = McCommandSourceKt.parseUuidOrPrintError(source, arguments[1]);
            boolean bl = false;
            UUID uUID = it;
            if (uUID == null) {
                return CollectionsKt.emptyList();
            }
            it = uUID;
            boolean bl2 = false;
            Group group = this.getHandler().getGroupManager().getGroups().get(it);
            if (group == null) {
                return CollectionsKt.emptyList();
            }
            Group group2 = group;
            if (group2.getPassword() == null) {
                return CollectionsKt.emptyList();
            }
            return CollectionsKt.listOf((Object)this.getHandler().getTranslationByKey("pv.addon.groups.arg.password", source));
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public void execute(@NotNull McCommandSource source, @NotNull String[] arguments) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        if (McCommandSourceKt.checkAddonPermissionAndPrintError(source, "join")) {
            return;
        }
        VoicePlayer voicePlayer = McCommandSourceKt.getVoicePlayer(source, this.getHandler().getVoiceServer());
        if (voicePlayer == null) {
            JoinCommand $this$execute_u24lambda_u243 = this;
            boolean bl = false;
            McCommandSourceKt.playerOnlyCommandError(source);
            return;
        }
        VoicePlayer player = voicePlayer;
        String string = (String)ArraysKt.getOrNull((Object[])arguments, (int)1);
        if (string == null) {
            boolean bl = false;
            McCommandSourceKt.sendTranslatable(source, "pv.addon.groups.command.join.error.usage", new Object[0]);
            return;
        }
        String uuidArg = string;
        UUID it = McCommandSourceKt.parseUuidOrPrintError(source, uuidArg);
        boolean bl = false;
        UUID uUID = it;
        if (uUID == null) {
            return;
        }
        it = uUID;
        boolean bl2 = false;
        Group group = this.getHandler().getGroupManager().getGroups().get(it);
        if (group == null) {
            JoinCommand $this$execute_u24lambda_u247_u24lambda_u246 = this;
            boolean bl3 = false;
            McCommandSourceKt.groupNotFoundError(source);
            return;
        }
        Group group2 = group;
        Object[] objectArray = this.getHandler().getGroupManager().getGroupByPlayer().get(player.getInstance().getUuid());
        if (objectArray != null) {
            Object[] objectArray2;
            Object[] it2 = objectArray2 = objectArray;
            boolean bl4 = false;
            if (Intrinsics.areEqual((Object)group2.getId(), (Object)it2.getId())) {
                McCommandSourceKt.sendTranslatable(source, "pv.addon.groups.command.join.error.already_joined", new Object[0]);
                return;
            }
            it2 = objectArray2;
            boolean bl5 = false;
            this.getHandler().getGroupManager().leave(player);
            Object[] objectArray3 = new Object[]{player.getInstance().getName()};
            it2.notifyPlayersTranslatable("pv.addon.groups.notifications.player_left", objectArray3);
        }
        if (this.checkCantJoin(group2, player, source, arguments)) {
            return;
        }
        objectArray = new Object[]{player.getInstance().getName()};
        group2.notifyPlayersTranslatable("pv.addon.groups.notifications.player_join", objectArray);
        this.getHandler().getGroupManager().join(player, group2);
        objectArray = new Object[]{group2.getName()};
        McCommandSourceKt.sendTranslatable(source, "pv.addon.groups.command.join.success", objectArray);
    }

    @Override
    public boolean checkCanExecute(@NotNull McCommandSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return McCommandSourceKt.hasAddonPermission(source, "join");
    }

    private final boolean checkCantJoin(Group group, VoicePlayer player, McCommandSource source, String[] arguments) {
        if (McCommandSourceKt.hasAddonPermission(source, "join.add") || McCommandSourceKt.hasAddonPermission(source, "join.*")) {
            return false;
        }
        if (group.isBanned(player.getInstance().getUuid())) {
            McCommandSourceKt.sendTranslatable(source, "pv.addon.groups.command.join.error.banned", new Object[0]);
            return true;
        }
        if (!group.hasPermission(source)) {
            McCommandSourceKt.sendTranslatable(source, "pv.addon.groups.command.join.error.no_permission", new Object[0]);
            return true;
        }
        if (group.getPassword() != null) {
            String string = (String)ArraysKt.getOrNull((Object[])arguments, (int)2);
            if (string == null) {
                JoinCommand $this$checkCantJoin_u24lambda_u2410 = this;
                boolean bl = false;
                McCommandSourceKt.sendTranslatable(source, "pv.addon.groups.command.join.error.password_arg_missing", new Object[0]);
                return true;
            }
            String passwordArg = string;
            if (!Intrinsics.areEqual((Object)group.getPassword(), (Object)passwordArg)) {
                McCommandSourceKt.sendTranslatable(source, "pv.addon.groups.command.join.error.wrong_password", new Object[0]);
                return true;
            }
        }
        return false;
    }
}

