/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.groups.command.subcommand;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import su.plo.slib.api.command.McCommandSource;
import su.plo.slib.api.permission.PermissionDefault;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.groups.command.CommandHandler;
import su.plo.voice.groups.command.SubCommand;
import su.plo.voice.groups.group.Group;
import su.plo.voice.groups.utils.extend.McCommandSourceKt;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.Pair;
import su.plo.voice.libs.kotlin.TuplesKt;
import su.plo.voice.libs.kotlin.collections.CollectionsKt;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J#\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J)\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016H\u0016\u00a2\u0006\u0002\u0010\u0019R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR&\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lsu/plo/voice/groups/command/subcommand/DeleteCommand;", "Lsu/plo/voice/groups/command/SubCommand;", "handler", "Lsu/plo/voice/groups/command/CommandHandler;", "(Lsu/plo/voice/groups/command/CommandHandler;)V", "name", "", "getName", "()Ljava/lang/String;", "permissions", "", "Lsu/plo/voice/libs/kotlin/Pair;", "Lsu/plo/slib/api/permission/PermissionDefault;", "getPermissions", "()Ljava/util/List;", "checkCanExecute", "", "source", "Lsu/plo/slib/api/command/McCommandSource;", "execute", "", "arguments", "", "(Lsu/plo/slib/api/command/McCommandSource;[Ljava/lang/String;)V", "suggest", "(Lsu/plo/slib/api/command/McCommandSource;[Ljava/lang/String;)Ljava/util/List;", "jar"})
public final class DeleteCommand
extends SubCommand {
    @NotNull
    private final String name;
    @NotNull
    private final List<Pair<String, PermissionDefault>> permissions;

    public DeleteCommand(@NotNull CommandHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        super(handler);
        this.name = "delete";
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"delete.owner", (Object)PermissionDefault.TRUE), TuplesKt.to((Object)"delete.all", (Object)PermissionDefault.OP), TuplesKt.to((Object)"delete.*", (Object)PermissionDefault.OP)};
        this.permissions = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<Pair<String, PermissionDefault>> getPermissions() {
        return this.permissions;
    }

    @Override
    @NotNull
    public List<String> suggest(@NotNull McCommandSource source, @NotNull String[] arguments) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        return CollectionsKt.emptyList();
    }

    @Override
    public void execute(@NotNull McCommandSource source, @NotNull String[] arguments) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        VoicePlayer voicePlayer = McCommandSourceKt.getVoicePlayer(source, this.getHandler().getVoiceServer());
        if (voicePlayer == null) {
            DeleteCommand $this$execute_u24lambda_u240 = this;
            boolean bl = false;
            McCommandSourceKt.playerOnlyCommandError(source);
            return;
        }
        VoicePlayer player = voicePlayer;
        Group group = this.getHandler().getGroupManager().getGroupByPlayer().get(player.getInstance().getUuid());
        if (group == null) {
            DeleteCommand $this$execute_u24lambda_u241 = this;
            boolean bl = false;
            McCommandSourceKt.notInGroupError(source);
            return;
        }
        Group group2 = group;
        boolean isOwner = group2.isOwner(player);
        if (!(McCommandSourceKt.hasAddonPermission(source, "delete.all") || McCommandSourceKt.hasAddonPermission(source, "delete.*") || McCommandSourceKt.hasAddonPermission(source, "delete.owner") && isOwner)) {
            McCommandSourceKt.noPermissionError(source, isOwner ? "delete.owner" : "delete.all");
            return;
        }
        group2.notifyPlayersTranslatable("pv.addon.groups.notifications.group_deleted", new Object[0]);
        this.getHandler().getGroupManager().deleteGroup(group2);
    }

    @Override
    public boolean checkCanExecute(@NotNull McCommandSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        VoicePlayer voicePlayer = McCommandSourceKt.getVoicePlayer(source, this.getHandler().getVoiceServer());
        if (voicePlayer == null) {
            return false;
        }
        VoicePlayer player = voicePlayer;
        Group group = this.getHandler().getGroupManager().getGroupByPlayer().get(player.getInstance().getUuid());
        if (group == null) {
            return false;
        }
        Group group2 = group;
        boolean isOwner = group2.isOwner(player);
        return McCommandSourceKt.hasAddonPermission(source, "delete.owner") && isOwner ? true : (McCommandSourceKt.hasAddonPermission(source, "delete.all") ? true : McCommandSourceKt.hasAddonPermission(source, "delete.*"));
    }
}

