/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.groups.command.subcommand;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.chat.component.McTranslatableText;
import su.plo.slib.api.chat.style.McTextClickEvent;
import su.plo.slib.api.chat.style.McTextHoverEvent;
import su.plo.slib.api.command.McCommandSource;
import su.plo.slib.api.permission.PermissionDefault;
import su.plo.voice.groups.command.CommandHandler;
import su.plo.voice.groups.command.SubCommand;
import su.plo.voice.groups.group.Group;
import su.plo.voice.groups.utils.extend.McCommandSourceKt;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.Pair;
import su.plo.voice.libs.kotlin.TuplesKt;
import su.plo.voice.libs.kotlin.collections.ArraysKt;
import su.plo.voice.libs.kotlin.collections.CollectionsKt;
import su.plo.voice.libs.kotlin.comparisons.ComparisonsKt;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;
import su.plo.voice.libs.kotlin.text.StringsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J#\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nH\u0002J)\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018H\u0016\u00a2\u0006\u0002\u0010\u001fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lsu/plo/voice/groups/command/subcommand/BrowseCommand;", "Lsu/plo/voice/groups/command/SubCommand;", "handler", "Lsu/plo/voice/groups/command/CommandHandler;", "(Lsu/plo/voice/groups/command/CommandHandler;)V", "name", "", "getName", "()Ljava/lang/String;", "perPage", "", "permissions", "", "Lsu/plo/voice/libs/kotlin/Pair;", "Lsu/plo/slib/api/permission/PermissionDefault;", "getPermissions", "()Ljava/util/List;", "checkCanExecute", "", "source", "Lsu/plo/slib/api/command/McCommandSource;", "execute", "", "arguments", "", "(Lsu/plo/slib/api/command/McCommandSource;[Ljava/lang/String;)V", "getPagesInfo", "Lsu/plo/slib/api/chat/component/McTextComponent;", "page", "chunksSize", "suggest", "(Lsu/plo/slib/api/command/McCommandSource;[Ljava/lang/String;)Ljava/util/List;", "jar"})
@SourceDebugExtension(value={"SMAP\nBrowseCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrowseCommand.kt\nsu/plo/voice/groups/command/subcommand/BrowseCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1#2:106\n766#3:107\n857#3,2:108\n1054#3:110\n1855#3,2:111\n*S KotlinDebug\n*F\n+ 1 BrowseCommand.kt\nsu/plo/voice/groups/command/subcommand/BrowseCommand\n*L\n43#1:107\n43#1:108,2\n45#1:110\n61#1:111,2\n*E\n"})
public final class BrowseCommand
extends SubCommand {
    @NotNull
    private final String name;
    private final int perPage;
    @NotNull
    private final List<Pair<String, PermissionDefault>> permissions;

    public BrowseCommand(@NotNull CommandHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        super(handler);
        this.name = "browse";
        this.perPage = 3;
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"browse", (Object)PermissionDefault.TRUE), TuplesKt.to((Object)"browse.all", (Object)PermissionDefault.OP), TuplesKt.to((Object)"browse.*", (Object)PermissionDefault.OP)};
        this.permissions = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<Pair<String, PermissionDefault>> getPermissions() {
        return this.permissions;
    }

    @Override
    @NotNull
    public List<String> suggest(@NotNull McCommandSource source, @NotNull String[] arguments) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        if (arguments.length == 2) {
            return CollectionsKt.listOf((Object)this.getHandler().getTranslationByKey("pv.addon.groups.arg.page", source));
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(@NotNull McCommandSource source, @NotNull String[] arguments) {
        int n;
        void $this$sortedByDescending$iv;
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        if (McCommandSourceKt.checkAddonPermissionAndPrintError(source, "browse")) {
            return;
        }
        Object object = (String)ArraysKt.getOrNull((Object[])arguments, (int)1);
        int page = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 1;
        Collection it = this.getHandler().getGroupManager().getGroups().values();
        boolean bl = false;
        if (McCommandSourceKt.hasAddonPermission(source, "browse.all")) {
            collection = it;
        } else if (McCommandSourceKt.hasAddonPermission(source, "browse.*")) {
            collection = it;
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = it;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Group it2 = (Group)element$iv$iv;
                boolean bl2 = false;
                if (!it2.hasPermission(source)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
        }
        Iterable iterable = collection;
        boolean $i$f$sortedByDescending = false;
        iterable = CollectionsKt.chunked((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Group it = (Group)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getOnlinePlayerCount());
                it = (Group)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getOnlinePlayerCount()));
            }
        }), (int)this.perPage);
        if (iterable.isEmpty()) {
            n = 0;
            McCommandSourceKt.printDivider(source);
            McCommandSourceKt.sendTranslatable(source, "pv.addon.groups.command.browse.error.no_groups", new Object[0]);
            McCommandSourceKt.printDivider(source);
            return;
        }
        List chunks = (List)iterable;
        iterable = chunks;
        n = page - 1;
        if (n < 0 || n > CollectionsKt.getLastIndex((List)iterable)) {
            int it3 = n;
            boolean bl3 = false;
            McCommandSourceKt.sendTranslatable(source, "pv.addon.groups.command.browse.error.page_not_found", new Object[0]);
            return;
        }
        List chunk = (List)iterable.get(n);
        boolean bl4 = false;
        McCommandSourceKt.printDivider(source);
        Iterable $this$forEach$iv = chunk;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Group group = (Group)element$iv;
            boolean bl5 = false;
            McCommandSourceKt.sendMessage(source, Group.asTextComponents$default(group, this.getHandler(), source, null, 4, null));
            McCommandSourceKt.printDivider(source);
        }
        source.sendMessage(this.getPagesInfo(page, chunks.size()));
    }

    private final McTextComponent getPagesInfo(int page, int chunksSize) {
        McTextComponent mcTextComponent;
        McTextComponent mcTextComponent2;
        Object[] objectArray;
        if (page > 1) {
            String command = "/groups browse " + (page - 1);
            objectArray = new McTextComponent[]{McTextComponent.Companion.literal(" ")};
            mcTextComponent2 = McTextComponent.Companion.translatable("pv.addon.groups.button.prev", new Object[0]).append((McTextComponent[])objectArray).hoverEvent(McTextHoverEvent.Companion.showText((McTextComponent)McTextComponent.Companion.literal(command))).clickEvent(McTextClickEvent.Companion.runCommand(command));
        } else {
            mcTextComponent2 = McTextComponent.Companion.empty();
        }
        McTextComponent prevButton = mcTextComponent2;
        objectArray = new Object[]{page, chunksSize};
        McTranslatableText pageInfo = McTextComponent.Companion.translatable("pv.addon.groups.format.page", objectArray);
        if (page < chunksSize) {
            String command = "/groups browse " + (page + 1);
            McTextComponent[] mcTextComponentArray = new McTextComponent[]{McTextComponent.Companion.translatable("pv.addon.groups.button.next", new Object[0])};
            mcTextComponent = McTextComponent.Companion.literal(" ").append(mcTextComponentArray).hoverEvent(McTextHoverEvent.Companion.showText((McTextComponent)McTextComponent.Companion.literal(command))).clickEvent(McTextClickEvent.Companion.runCommand(command));
        } else {
            mcTextComponent = McTextComponent.Companion.empty();
        }
        McTextComponent nextButton = mcTextComponent;
        McTextComponent[] mcTextComponentArray = new McTextComponent[]{pageInfo};
        McTextComponent mcTextComponent3 = prevButton.append(mcTextComponentArray);
        mcTextComponentArray = new McTextComponent[]{nextButton};
        return mcTextComponent3.append(mcTextComponentArray);
    }

    @Override
    public boolean checkCanExecute(@NotNull McCommandSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return McCommandSourceKt.hasAddonPermission(source, "browse");
    }
}

