/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.groups;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.McLib;
import su.plo.slib.api.command.McCommandSource;
import su.plo.slib.api.entity.player.McGameProfile;
import su.plo.slib.api.entity.player.McPlayer;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.api.server.PlasmoBaseVoiceServer;
import su.plo.voice.api.server.audio.capture.ServerActivation;
import su.plo.voice.api.server.audio.line.BaseServerSourceLine;
import su.plo.voice.api.server.audio.line.ServerPlayerSetManager;
import su.plo.voice.api.server.audio.source.ServerAudioSource;
import su.plo.voice.api.server.audio.source.ServerBroadcastSource;
import su.plo.voice.api.server.event.connection.UdpClientConnectedEvent;
import su.plo.voice.api.server.event.connection.UdpClientDisconnectedEvent;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.groups.Config;
import su.plo.voice.groups.GroupsAddon;
import su.plo.voice.groups.GroupsManager$Data$;
import su.plo.voice.groups.group.Group;
import su.plo.voice.groups.group.GroupData;
import su.plo.voice.groups.group.GroupData$;
import su.plo.voice.groups.utils.extend.McCommandSourceKt;
import su.plo.voice.groups.utils.serializer.UUIDSerializer;
import su.plo.voice.libs.kotlin.Deprecated;
import su.plo.voice.libs.kotlin.DeprecationLevel;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.Pair;
import su.plo.voice.libs.kotlin.ReplaceWith;
import su.plo.voice.libs.kotlin.TuplesKt;
import su.plo.voice.libs.kotlin.Unit;
import su.plo.voice.libs.kotlin.collections.CollectionsKt;
import su.plo.voice.libs.kotlin.collections.MapsKt;
import su.plo.voice.libs.kotlin.io.FilesKt;
import su.plo.voice.libs.kotlin.jvm.JvmField;
import su.plo.voice.libs.kotlin.jvm.JvmStatic;
import su.plo.voice.libs.kotlin.jvm.functions.Function1;
import su.plo.voice.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;
import su.plo.voice.libs.kotlin.random.Random;
import su.plo.voice.libs.kotlinx.serialization.KSerializer;
import su.plo.voice.libs.kotlinx.serialization.Serializable;
import su.plo.voice.libs.kotlinx.serialization.SerializationStrategy;
import su.plo.voice.libs.kotlinx.serialization.StringFormat;
import su.plo.voice.libs.kotlinx.serialization.descriptors.SerialDescriptor;
import su.plo.voice.libs.kotlinx.serialization.encoding.CompositeEncoder;
import su.plo.voice.libs.kotlinx.serialization.internal.ArrayListSerializer;
import su.plo.voice.libs.kotlinx.serialization.internal.LinkedHashMapSerializer;
import su.plo.voice.libs.kotlinx.serialization.internal.PluginExceptionsKt;
import su.plo.voice.libs.kotlinx.serialization.internal.SerializationConstructorMarker;
import su.plo.voice.libs.kotlinx.serialization.json.Json;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00014B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"J\u0015\u0010#\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0014\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u0014H\u0002J\u0016\u0010&\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u0014J\u0016\u0010'\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"J\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0013J\u000e\u0010(\u001a\u00020)2\u0006\u0010!\u001a\u00020\"J\u0010\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020-H\u0007J\u0010\u0010.\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020/H\u0007J\u000e\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u0005J\u0016\u00102\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u000203R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u001d\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001a0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lsu/plo/voice/groups/GroupsManager;", "", "config", "Lsu/plo/voice/groups/Config;", "voiceServer", "Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;", "addon", "Lsu/plo/voice/groups/GroupsAddon;", "activation", "Lsu/plo/voice/api/server/audio/capture/ServerActivation;", "sourceLine", "Lsu/plo/voice/api/server/audio/line/BaseServerSourceLine;", "(Lsu/plo/voice/groups/Config;Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;Lsu/plo/voice/groups/GroupsAddon;Lsu/plo/voice/api/server/audio/capture/ServerActivation;Lsu/plo/voice/api/server/audio/line/BaseServerSourceLine;)V", "getActivation", "()Lsu/plo/voice/api/server/audio/capture/ServerActivation;", "getConfig", "()Lsu/plo/voice/groups/Config;", "groupByPlayer", "", "Ljava/util/UUID;", "Lsu/plo/voice/groups/group/Group;", "getGroupByPlayer", "()Ljava/util/Map;", "groups", "getGroups", "sourceByPlayer", "Lsu/plo/voice/api/server/audio/source/ServerBroadcastSource;", "getSourceByPlayer", "getSourceLine", "()Lsu/plo/voice/api/server/audio/line/BaseServerSourceLine;", "ban", "", "group", "player", "Lsu/plo/voice/api/server/player/VoicePlayer;", "deleteGroup", "(Lsu/plo/voice/groups/group/Group;)Lkotlin/Unit;", "initSource", "join", "kick", "leave", "", "playerUuid", "onPlayerJoin", "event", "Lsu/plo/voice/api/server/event/connection/UdpClientConnectedEvent;", "onPlayerLeave", "Lsu/plo/voice/api/server/event/connection/UdpClientDisconnectedEvent;", "onVoiceServerShutdown", "server", "unban", "Lsu/plo/slib/api/entity/player/McGameProfile;", "Data", "jar"})
@SourceDebugExtension(value={"SMAP\nGroupsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroupsManager.kt\nsu/plo/voice/groups/GroupsManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,158:1\n1#2:159\n1855#3,2:160\n766#3:162\n857#3,2:163\n125#4:165\n152#4,3:166\n113#5:169\n*S KotlinDebug\n*F\n+ 1 GroupsManager.kt\nsu/plo/voice/groups/GroupsManager\n*L\n107#1:160,2\n140#1:162\n140#1:163,2\n145#1:165\n145#1:166,3\n143#1:169\n*E\n"})
public final class GroupsManager {
    @NotNull
    private final Config config;
    @NotNull
    private final PlasmoBaseVoiceServer voiceServer;
    @NotNull
    private final GroupsAddon addon;
    @NotNull
    private final ServerActivation activation;
    @NotNull
    private final BaseServerSourceLine sourceLine;
    @NotNull
    private final Map<UUID, Group> groupByPlayer;
    @NotNull
    private final Map<UUID, Group> groups;
    @NotNull
    private final Map<UUID, ServerBroadcastSource> sourceByPlayer;

    public GroupsManager(@NotNull Config config, @NotNull PlasmoBaseVoiceServer voiceServer, @NotNull GroupsAddon addon, @NotNull ServerActivation activation, @NotNull BaseServerSourceLine sourceLine) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)voiceServer, (String)"voiceServer");
        Intrinsics.checkNotNullParameter((Object)addon, (String)"addon");
        Intrinsics.checkNotNullParameter((Object)activation, (String)"activation");
        Intrinsics.checkNotNullParameter((Object)sourceLine, (String)"sourceLine");
        this.config = config;
        this.voiceServer = voiceServer;
        this.addon = addon;
        this.activation = activation;
        this.sourceLine = sourceLine;
        this.groupByPlayer = new ConcurrentHashMap();
        this.groups = new ConcurrentHashMap();
        this.sourceByPlayer = new ConcurrentHashMap();
    }

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    @NotNull
    public final ServerActivation getActivation() {
        return this.activation;
    }

    @NotNull
    public final BaseServerSourceLine getSourceLine() {
        return this.sourceLine;
    }

    @NotNull
    public final Map<UUID, Group> getGroupByPlayer() {
        return this.groupByPlayer;
    }

    @NotNull
    public final Map<UUID, Group> getGroups() {
        return this.groups;
    }

    @NotNull
    public final Map<UUID, ServerBroadcastSource> getSourceByPlayer() {
        return this.sourceByPlayer;
    }

    public final void join(@NotNull VoicePlayer player, @NotNull Group group) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            this.leave(player.getInstance().getUuid());
            this.initSource(player, group);
            this.groupByPlayer.put(player.getInstance().getUuid(), group);
            group.addPlayer(player);
            ServerPlayerSetManager serverPlayerSetManager = this.sourceLine.getPlayerSetManager();
            if (serverPlayerSetManager == null) break block0;
            serverPlayerSetManager.setPlayerSet(player, group.getPlayerSet());
        }
    }

    private final void initSource(VoicePlayer player, Group group) {
        ServerBroadcastSource source = BaseServerSourceLine.createBroadcastSource$default((BaseServerSourceLine)this.sourceLine, (boolean)false, (int)1, null);
        source.setPlayers(group.getOnlinePlayers());
        source.addFilter(arg_0 -> GroupsManager.initSource$lambda$0((Function1)new Function1<VoicePlayer, Boolean>(player){
            final /* synthetic */ VoicePlayer $player;
            {
                this.$player = $player;
                super(1);
            }

            @NotNull
            public final Boolean invoke(VoicePlayer it) {
                return !Intrinsics.areEqual((Object)it.getInstance(), (Object)this.$player.getInstance());
            }
        }, arg_0));
        source.setSender(player);
        this.sourceByPlayer.put(player.getInstance().getUuid(), source);
    }

    public final void kick(@NotNull Group group, @NotNull VoicePlayer player) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.leave(player);
        McPlayer mcPlayer = player.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)mcPlayer, (String)"player.instance");
        McCommandSourceKt.sendTranslatable((McCommandSource)mcPlayer, "pv.addon.groups.notifications.kicked", new Object[0]);
        Object[] objectArray = new Object[]{player.getInstance().getName()};
        group.notifyPlayersTranslatable("pv.addon.groups.notifications.player_kicked", objectArray);
    }

    public final void ban(@NotNull Group group, @NotNull VoicePlayer player) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        boolean didLeft = this.leave(player);
        group.banPlayer(player);
        Object[] objectArray = new Object[]{player.getInstance().getName()};
        group.notifyPlayersTranslatable("pv.addon.groups.notifications.player_banned", objectArray);
        if (didLeft) {
            McPlayer mcPlayer = player.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)mcPlayer, (String)"player.instance");
            objectArray = new Object[]{group.inlineChatComponent()};
            McCommandSourceKt.sendTranslatable((McCommandSource)mcPlayer, "pv.addon.groups.notifications.banned", objectArray);
        }
    }

    public final void unban(@NotNull Group group, @NotNull McGameProfile player) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        group.unbanPlayer(player);
        Object[] objectArray = new Object[]{player.getName()};
        group.notifyPlayersTranslatable("pv.addon.groups.notifications.player_unbanned", objectArray);
    }

    public final boolean leave(@NotNull VoicePlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.leave(player.getInstance().getUuid());
    }

    public final boolean leave(@NotNull UUID playerUuid) {
        Boolean bl;
        Group group;
        Intrinsics.checkNotNullParameter((Object)playerUuid, (String)"playerUuid");
        ServerBroadcastSource serverBroadcastSource = this.sourceByPlayer.remove(playerUuid);
        if (serverBroadcastSource != null) {
            ServerBroadcastSource it = serverBroadcastSource;
            boolean bl2 = false;
            this.sourceLine.removeSource((ServerAudioSource)it);
        }
        Group group2 = group = this.groupByPlayer.remove(playerUuid);
        Boolean it = bl = group2 != null ? Boolean.valueOf(group2.removePlayer(playerUuid)) : null;
        boolean bl3 = false;
        VoicePlayer voicePlayer = this.voiceServer.getPlayerManager().getPlayerById(playerUuid).orElse(null);
        if (voicePlayer != null) {
            VoicePlayer it2 = voicePlayer;
            boolean bl4 = false;
            ServerPlayerSetManager serverPlayerSetManager = this.sourceLine.getPlayerSetManager();
            if (serverPlayerSetManager != null) {
                serverPlayerSetManager.setPlayerSet(it2, null);
            }
        }
        Boolean didLeft = bl;
        if (!Intrinsics.areEqual((Object)didLeft, (Object)true)) {
            return false;
        }
        Group group3 = group;
        boolean bl5 = group3 != null ? !group3.getPersistent() : false;
        if (bl5) {
            McGameProfile mcGameProfile = group.getOwner();
            if (Intrinsics.areEqual((Object)(mcGameProfile != null ? mcGameProfile.getId() : null), (Object)playerUuid)) {
                VoicePlayer voicePlayer2 = (VoicePlayer)CollectionsKt.randomOrNull(group.getOnlinePlayers(), (Random)((Random)Random.Default));
                group.setOwner(voicePlayer2 != null && (voicePlayer2 = voicePlayer2.getInstance()) != null ? voicePlayer2.getGameProfile() : null);
                McGameProfile mcGameProfile2 = group.getOwner();
                if (mcGameProfile2 != null) {
                    McGameProfile it3 = mcGameProfile2;
                    boolean bl6 = false;
                    Object[] objectArray = new Object[]{it3.getName()};
                    group.notifyPlayersTranslatable("pv.addon.groups.notifications.new_owner", objectArray);
                }
            }
            if (group.getOnlinePlayers().isEmpty()) {
                this.deleteGroup(group);
            }
        }
        return true;
    }

    @Nullable
    public final Unit deleteGroup(@NotNull Group group) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Group group2 = this.groups.remove(group.getId());
        if (group2 != null) {
            Group group3 = group2;
            boolean bl = false;
            Iterable $this$forEach$iv = group3.getPlayersIds();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UUID it = (UUID)element$iv;
                boolean bl2 = false;
                this.leave(it);
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @EventSubscribe
    public final void onPlayerJoin(@NotNull UdpClientConnectedEvent event) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            VoicePlayer voicePlayer = event.getConnection().getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)voicePlayer, (String)"event.connection.player");
            VoicePlayer player = voicePlayer;
            UUID playerId = player.getInstance().getUuid();
            Group group = this.groupByPlayer.get(playerId);
            if (group == null) break block2;
            Group group2 = group;
            boolean bl = false;
            McGameProfile mcGameProfile = group2.getOwner();
            if (Intrinsics.areEqual((Object)(mcGameProfile != null ? mcGameProfile.getId() : null), (Object)playerId)) {
                group2.setOwner(player.getInstance().getGameProfile());
            }
            group2.onPlayerJoin(player);
            ServerPlayerSetManager serverPlayerSetManager = this.sourceLine.getPlayerSetManager();
            if (serverPlayerSetManager != null) {
                serverPlayerSetManager.setPlayerSet(player, group2.getPlayerSet());
            }
            this.initSource(player, group2);
        }
    }

    @EventSubscribe
    public final void onPlayerLeave(@NotNull UdpClientDisconnectedEvent event) {
        block2: {
            Object it;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            UUID playerId = event.getConnection().getPlayer().getInstance().getUuid();
            ServerBroadcastSource serverBroadcastSource = this.sourceByPlayer.remove(playerId);
            if (serverBroadcastSource != null) {
                it = serverBroadcastSource;
                boolean bl = false;
                this.sourceLine.removeSource((ServerAudioSource)it);
            }
            Group group = this.groupByPlayer.get(playerId);
            if (group == null) break block2;
            it = group;
            boolean bl = false;
            ((Group)it).onPlayerQuit(playerId);
            if (((Group)it).getOnlinePlayers().isEmpty() && !((GroupData)it).getPersistent()) {
                this.deleteGroup((Group)it);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void onVoiceServerShutdown(@NotNull PlasmoBaseVoiceServer server) {
        void $this$encodeToString$iv;
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Iterable $this$filter$iv = this.groups.values();
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Group it = (Group)element$iv$iv;
            boolean bl = false;
            if (!it.getPersistent()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List groups = (List)destination$iv$iv;
        McLib mcLib = server.getMinecraftServer();
        Intrinsics.checkNotNullExpressionValue((Object)mcLib, (String)"server.minecraftServer");
        $this$filter$iv = (StringFormat)Json.Default;
        Map<UUID, Group> $i$f$filter22 = this.groupByPlayer;
        List list = groups;
        File file = new File(this.addon.getAddonFolder(mcLib), "groups.json");
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry bl = item$iv$iv = iterator.next();
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(TuplesKt.to(it.getKey(), (Object)((Group)it.getValue()).getId()));
        }
        collection = (List)destination$iv$iv2;
        Map map = MapsKt.toMap((Iterable)collection);
        List list2 = list;
        Data value$iv = new Data(list2, map);
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        FilesKt.writeText$default((File)file, (String)$this$encodeToString$iv.encodeToString((SerializationStrategy)Data.Companion.serializer(), (Object)value$iv), null, (int)2, null);
    }

    private static final boolean initSource$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Serializable
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 &2\u00020\u0001:\u0002%&B]\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00122\u0010\u0007\u001a.\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\t0\f\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\t0\f\u0018\u00010\b\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fBE\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00120\u0010\u0007\u001a,\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\t0\f\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\t0\f0\b\u00a2\u0006\u0002\u0010\u0010J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J3\u0010\u0016\u001a,\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\t0\f\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\t0\f0\bH\u00c6\u0003JM\u0010\u0017\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u000522\b\u0002\u0010\u0007\u001a,\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\t0\f\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\t0\f0\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J!\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u00c7\u0001R;\u0010\u0007\u001a,\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\t0\f\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\t0\f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006'"}, d2={"Lsu/plo/voice/groups/GroupsManager$Data;", "", "seen1", "", "groups", "", "Lsu/plo/voice/groups/group/GroupData;", "groupByPlayer", "", "Ljava/util/UUID;", "Lsu/plo/voice/libs/kotlinx/serialization/Serializable;", "with", "Lsu/plo/voice/groups/utils/serializer/UUIDSerializer;", "serializationConstructorMarker", "Lsu/plo/voice/libs/kotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/List;Ljava/util/Map;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/util/List;Ljava/util/Map;)V", "getGroupByPlayer", "()Ljava/util/Map;", "getGroups", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lsu/plo/voice/libs/kotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lsu/plo/voice/libs/kotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "jar"})
    public static final class Data {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<GroupData> groups;
        @NotNull
        private final Map<UUID, UUID> groupByPlayer;
        @JvmField
        @NotNull
        private static final KSerializer<Object>[] $childSerializers;

        public Data(@NotNull List<? extends GroupData> groups, @NotNull Map<UUID, UUID> groupByPlayer) {
            Intrinsics.checkNotNullParameter(groups, (String)"groups");
            Intrinsics.checkNotNullParameter(groupByPlayer, (String)"groupByPlayer");
            this.groups = groups;
            this.groupByPlayer = groupByPlayer;
        }

        @NotNull
        public final List<GroupData> getGroups() {
            return this.groups;
        }

        @NotNull
        public final Map<UUID, UUID> getGroupByPlayer() {
            return this.groupByPlayer;
        }

        @NotNull
        public final List<GroupData> component1() {
            return this.groups;
        }

        @NotNull
        public final Map<UUID, UUID> component2() {
            return this.groupByPlayer;
        }

        @NotNull
        public final Data copy(@NotNull List<? extends GroupData> groups, @NotNull Map<UUID, UUID> groupByPlayer) {
            Intrinsics.checkNotNullParameter(groups, (String)"groups");
            Intrinsics.checkNotNullParameter(groupByPlayer, (String)"groupByPlayer");
            return new Data(groups, groupByPlayer);
        }

        public static /* synthetic */ Data copy$default(Data data, List list, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                list = data.groups;
            }
            if ((n & 2) != 0) {
                map = data.groupByPlayer;
            }
            return data.copy(list, map);
        }

        @NotNull
        public String toString() {
            return "Data(groups=" + this.groups + ", groupByPlayer=" + this.groupByPlayer + ')';
        }

        public int hashCode() {
            int result = ((Object)this.groups).hashCode();
            result = result * 31 + ((Object)this.groupByPlayer).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data = (Data)other;
            if (!Intrinsics.areEqual(this.groups, data.groups)) {
                return false;
            }
            return Intrinsics.areEqual(this.groupByPlayer, data.groupByPlayer);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self(Data self, CompositeEncoder output, SerialDescriptor serialDesc) {
            KSerializer<Object>[] kSerializerArray = $childSerializers;
            output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], self.groups);
            output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)kSerializerArray[1], self.groupByPlayer);
        }

        @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
        public /* synthetic */ Data(int seen1, List groups, Map groupByPlayer, SerializationConstructorMarker serializationConstructorMarker) {
            if (3 != (3 & seen1)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)3, (SerialDescriptor)Data$$serializer.INSTANCE.getDescriptor());
            }
            this.groups = groups;
            this.groupByPlayer = groupByPlayer;
        }

        public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            KSerializer[] kSerializerArray = new KSerializer[]{new ArrayListSerializer((KSerializer)GroupData$.serializer.INSTANCE), new LinkedHashMapSerializer((KSerializer)UUIDSerializer.INSTANCE, (KSerializer)UUIDSerializer.INSTANCE)};
            $childSerializers = kSerializerArray;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lsu/plo/voice/groups/GroupsManager$Data$Companion;", "", "()V", "serializer", "Lsu/plo/voice/libs/kotlinx/serialization/KSerializer;", "Lsu/plo/voice/groups/GroupsManager$Data;", "jar"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Data> serializer() {
                return (KSerializer)Data$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

