/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.groups;

import org.jetbrains.annotations.NotNull;
import su.plo.voice.api.server.audio.capture.PlayerActivationInfo;
import su.plo.voice.api.server.audio.capture.ServerActivation;
import su.plo.voice.api.server.audio.source.ServerBroadcastSource;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.groups.GroupsManager;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.tcp.clientbound.SourceAudioEndPacket;
import su.plo.voice.proto.packets.tcp.serverbound.PlayerAudioEndPacket;
import su.plo.voice.proto.packets.udp.clientbound.SourceAudioPacket;
import su.plo.voice.proto.packets.udp.serverbound.PlayerAudioPacket;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u000eH\u0002J \u0010\u0013\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lsu/plo/voice/groups/ActivationListener;", "", "groupManager", "Lsu/plo/voice/groups/GroupsManager;", "activation", "Lsu/plo/voice/api/server/audio/capture/ServerActivation;", "(Lsu/plo/voice/groups/GroupsManager;Lsu/plo/voice/api/server/audio/capture/ServerActivation;)V", "onActivation", "Lsu/plo/voice/api/server/audio/capture/ServerActivation$Result;", "player", "Lsu/plo/voice/api/server/player/VoicePlayer;", "packet", "Lsu/plo/voice/proto/packets/udp/serverbound/PlayerAudioPacket;", "onActivationEnd", "Lsu/plo/voice/proto/packets/tcp/serverbound/PlayerAudioEndPacket;", "sendAudioEndPacket", "", "source", "Lsu/plo/voice/api/server/audio/source/ServerBroadcastSource;", "sendAudioPacket", "jar"})
public final class ActivationListener {
    @NotNull
    private final GroupsManager groupManager;

    public ActivationListener(@NotNull GroupsManager groupManager, @NotNull ServerActivation activation) {
        Intrinsics.checkNotNullParameter((Object)groupManager, (String)"groupManager");
        Intrinsics.checkNotNullParameter((Object)activation, (String)"activation");
        this.groupManager = groupManager;
        activation.onPlayerActivation(this::onActivation);
        activation.onPlayerActivationEnd(this::onActivationEnd);
    }

    private final ServerActivation.Result onActivation(VoicePlayer player, PlayerAudioPacket packet) {
        ServerBroadcastSource serverBroadcastSource = this.groupManager.getSourceByPlayer().get(player.getInstance().getUuid());
        if (serverBroadcastSource != null) {
            ServerBroadcastSource it = serverBroadcastSource;
            boolean bl = false;
            if (this.sendAudioPacket(player, it, packet)) {
                return ServerActivation.Result.HANDLED;
            }
        }
        return ServerActivation.Result.IGNORED;
    }

    @NotNull
    public final ServerActivation.Result onActivationEnd(@NotNull VoicePlayer player, @NotNull PlayerAudioEndPacket packet) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        ServerBroadcastSource serverBroadcastSource = this.groupManager.getSourceByPlayer().get(player.getInstance().getUuid());
        if (serverBroadcastSource != null) {
            ServerBroadcastSource it = serverBroadcastSource;
            boolean bl = false;
            if (this.sendAudioEndPacket(it, packet)) {
                return ServerActivation.Result.HANDLED;
            }
        }
        return ServerActivation.Result.IGNORED;
    }

    private final boolean sendAudioPacket(VoicePlayer player, ServerBroadcastSource source, PlayerAudioPacket packet) {
        SourceAudioPacket sourcePacket = new SourceAudioPacket(packet.getSequenceNumber(), (byte)source.getState(), packet.getData(), source.getId(), 0);
        return source.sendAudioPacket(sourcePacket, new PlayerActivationInfo(player, packet));
    }

    private final boolean sendAudioEndPacket(ServerBroadcastSource source, PlayerAudioEndPacket packet) {
        SourceAudioEndPacket sourcePacket = new SourceAudioEndPacket(source.getId(), packet.getSequenceNumber());
        return source.sendPacket((Packet)sourcePacket);
    }
}

