/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.server.socket.UdpServer;
import su.plo.voice.server.BaseVoiceServer;
import su.plo.voice.server.socket.NettyPacketHandler;
import su.plo.voice.server.socket.NettyUdpKeepAlive;
import su.plo.voice.socket.NettyExceptionHandler;
import su.plo.voice.socket.NettyPacketUdpDecoder;

public final class NettyUdpServer
implements UdpServer {
    private final boolean useEpoll = System.getProperty("plasmovoice.use_epoll", "true").equals("true") && Epoll.isAvailable();
    private final EventLoopGroup loopGroup;
    private final ChannelGroup channelGroup = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private final BaseVoiceServer voiceServer;
    private NettyUdpKeepAlive keepAlive;
    private InetSocketAddress socketAddress;

    public NettyUdpServer(@NotNull BaseVoiceServer voiceServer) {
        this.voiceServer = voiceServer;
        this.loopGroup = this.useEpoll ? new EpollEventLoopGroup() : new NioEventLoopGroup();
    }

    @Override
    public void start(String ip, int port) {
        this.keepAlive = new NettyUdpKeepAlive(this.voiceServer);
        Class channelClass = this.useEpoll ? EpollDatagramChannel.class : NioDatagramChannel.class;
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)bootstrap.group(this.loopGroup)).channel(channelClass);
        bootstrap.handler((ChannelHandler)new ChannelInitializer<DatagramChannel>(){

            protected void initChannel(@NotNull DatagramChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("decoder", (ChannelHandler)new NettyPacketUdpDecoder());
                pipeline.addLast("handler", (ChannelHandler)new NettyPacketHandler(NettyUdpServer.this.voiceServer));
                pipeline.addLast("exception_handler", (ChannelHandler)new NettyExceptionHandler());
            }
        });
        try {
            ChannelFuture channelFuture = bootstrap.bind(ip, port).sync();
            Channel channel = channelFuture.channel();
            this.channelGroup.add((Object)channel);
            this.keepAlive.start(channel);
            this.socketAddress = (InetSocketAddress)channelFuture.channel().localAddress();
        }
        catch (InterruptedException e) {
            this.stop();
            return;
        }
        catch (Exception e) {
            this.stop();
            throw e;
        }
        BaseVoice.LOGGER.info("{} UDP server is started on {}", channelClass.getSimpleName(), this.socketAddress);
    }

    @Override
    public void stop() {
        this.voiceServer.getUdpConnectionManager().clearConnections();
        if (this.keepAlive != null) {
            this.keepAlive.close();
        }
        this.channelGroup.close();
        this.loopGroup.shutdownGracefully();
        BaseVoice.LOGGER.info("UDP server is stopped", new Object[0]);
    }

    @Override
    public Optional<InetSocketAddress> getRemoteAddress() {
        return Optional.ofNullable(this.socketAddress);
    }
}

