/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.source;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.server.entity.player.McServerPlayer;
import su.plo.slib.api.server.position.ServerPos3d;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.audio.line.ServerSourceLine;
import su.plo.voice.api.server.audio.source.ServerPlayerSource;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.functions.Function1;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.data.audio.source.PlayerSourceInfo;
import su.plo.voice.server.audio.source.VoiceServerProximitySource;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B9\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001eH\u0002R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006 "}, d2={"Lsu/plo/voice/server/audio/source/VoiceServerPlayerSource;", "Lsu/plo/voice/server/audio/source/VoiceServerProximitySource;", "Lsu/plo/voice/proto/data/audio/source/PlayerSourceInfo;", "Lsu/plo/voice/api/server/audio/source/ServerPlayerSource;", "voiceServer", "Lsu/plo/voice/api/server/PlasmoVoiceServer;", "addon", "Lsu/plo/voice/api/addon/AddonContainer;", "line", "Lsu/plo/voice/api/server/audio/line/ServerSourceLine;", "decoderInfo", "Lsu/plo/voice/proto/data/audio/codec/CodecInfo;", "stereo", "", "player", "Lsu/plo/voice/api/server/player/VoiceServerPlayer;", "<init>", "(Lsu/plo/voice/api/server/PlasmoVoiceServer;Lsu/plo/voice/api/addon/AddonContainer;Lsu/plo/voice/api/server/audio/line/ServerSourceLine;Lsu/plo/voice/proto/data/audio/codec/CodecInfo;ZLsu/plo/voice/api/server/player/VoiceServerPlayer;)V", "getPlayer", "()Lsu/plo/voice/api/server/player/VoiceServerPlayer;", "position", "Lsu/plo/slib/api/server/position/ServerPos3d;", "getPosition", "()Lsu/plo/slib/api/server/position/ServerPos3d;", "sourceInfo", "getSourceInfo", "()Lsu/plo/voice/proto/data/audio/source/PlayerSourceInfo;", "resolveSourceInfo", "Ljava/util/concurrent/CompletableFuture;", "filterSelf", "Lsu/plo/voice/api/server/player/VoicePlayer;", "filterVanish", "common"})
public final class VoiceServerPlayerSource
extends VoiceServerProximitySource<PlayerSourceInfo>
implements ServerPlayerSource {
    @NotNull
    private final VoiceServerPlayer player;

    public VoiceServerPlayerSource(@NotNull PlasmoVoiceServer voiceServer, @NotNull AddonContainer addon, @NotNull ServerSourceLine line, @Nullable CodecInfo decoderInfo, boolean stereo, @NotNull VoiceServerPlayer player) {
        Intrinsics.checkNotNullParameter(voiceServer, "voiceServer");
        Intrinsics.checkNotNullParameter(addon, "addon");
        Intrinsics.checkNotNullParameter(line, "line");
        Intrinsics.checkNotNullParameter(player, "player");
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "randomUUID(...)");
        super(voiceServer, addon, uUID, line, decoderInfo, stereo);
        this.player = player;
        this.addFilter(arg_0 -> VoiceServerPlayerSource._init_$lambda$0(new Function1<VoicePlayer, Boolean>((Object)this){

            @Override
            public final Boolean invoke(VoicePlayer p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((VoiceServerPlayerSource)this.receiver).filterSelf(p0);
            }
        }, arg_0));
        this.addFilter(arg_0 -> VoiceServerPlayerSource._init_$lambda$1(new Function1<VoicePlayer, Boolean>((Object)this){

            @Override
            public final Boolean invoke(VoicePlayer p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((VoiceServerPlayerSource)this.receiver).filterVanish(p0);
            }
        }, arg_0));
    }

    @Override
    @NotNull
    public VoiceServerPlayer getPlayer() {
        return this.player;
    }

    @Override
    @NotNull
    public ServerPos3d getPosition() {
        return this.getPlayer().getInstance().getServerPosition();
    }

    @Override
    @NotNull
    public PlayerSourceInfo getSourceInfo() {
        return new PlayerSourceInfo(this.addon.getId(), this.id, this.line.getId(), this.name, (byte)this.state.get(), this.decoderInfo, this.stereo, this.iconVisible, this.getAngle(), this.getPlayer().createPlayerInfo());
    }

    @Override
    @NotNull
    public CompletableFuture<PlayerSourceInfo> resolveSourceInfo() {
        CompletableFuture<PlayerSourceInfo> completableFuture = CompletableFuture.completedFuture(this.getSourceInfo());
        Intrinsics.checkNotNullExpressionValue(completableFuture, "completedFuture(...)");
        return completableFuture;
    }

    private final boolean filterSelf(VoicePlayer player) {
        return !Intrinsics.areEqual(player, this.getPlayer());
    }

    private final boolean filterVanish(VoicePlayer player) {
        Intrinsics.checkNotNull(player, "null cannot be cast to non-null type su.plo.voice.api.server.player.VoiceServerPlayer");
        McServerPlayer mcServerPlayer = ((VoiceServerPlayer)player).getInstance();
        McServerPlayer mcServerPlayer2 = this.getPlayer().getInstance();
        Intrinsics.checkNotNullExpressionValue(mcServerPlayer2, "getInstance(...)");
        return mcServerPlayer.canSee(mcServerPlayer2);
    }

    private static final boolean _init_$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean _init_$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

