/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.gui.components;

import java.util.function.Consumer;
import net.minecraft.class_11876;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.mod.client.gui.components.AbstractButton;
import su.plo.lib.mod.client.gui.narration.NarrationOutput;
import su.plo.lib.mod.client.render.gui.GuiRenderContext;
import su.plo.slib.api.chat.component.McTextComponent;

public class Button
extends AbstractButton {
    public static final OnTooltip NO_TOOLTIP = (button, render, mouseX, mouseY) -> {};
    public static final OnPress NO_ACTION = button -> {};
    protected final OnPress pressAction;
    protected final OnTooltip tooltipAction;

    public Button(int x, int y, int width, int height, @NotNull McTextComponent text, @NotNull OnPress pressAction, @NotNull OnTooltip tooltipAction) {
        super(x, y, width, height, text);
        this.pressAction = pressAction;
        this.tooltipAction = tooltipAction;
    }

    @Override
    public void onPress() {
        this.pressAction.onPress(this);
    }

    @Override
    public void renderButton(@NotNull GuiRenderContext context, int mouseX, int mouseY, float delta) {
        super.renderButton(context, mouseX, mouseY, delta);
        if (this.isHoveredOrFocused()) {
            this.renderToolTip(context, mouseX, mouseY);
        }
        if (this.isHovered()) {
            context.requestCursor(this.isActive() ? class_11876.field_62455 : class_11876.field_62459);
        }
    }

    @Override
    public void renderToolTip(@NotNull GuiRenderContext context, int mouseX, int mouseY) {
        this.tooltipAction.onTooltip(this, context, mouseX, mouseY);
    }

    @Override
    public void updateNarration(@NotNull NarrationOutput narrationOutput) {
        super.updateNarration(narrationOutput);
        this.tooltipAction.narrateTooltip(component -> narrationOutput.add(NarrationOutput.Type.HINT, (McTextComponent)component));
    }

    public static interface OnPress {
        public void onPress(Button var1);
    }

    public static interface OnTooltip {
        public void onTooltip(Button var1, GuiRenderContext var2, int var3, int var4);

        default public void narrateTooltip(Consumer<McTextComponent> consumer2) {
        }
    }
}

