/*
 * Decompiled with CFR 0.152.
 */
package com.plasmoverse.rnnoise;

import com.plasmoverse.rnnoise.DenoiseException;
import com.plasmoverse.rnnoise.DenoiseLibrary;
import java.io.IOException;

public final class Denoise {
    private final long pointer;

    public static Denoise create() throws IOException, DenoiseException {
        DenoiseLibrary.load();
        long pointer = Denoise.createNative();
        return new Denoise(pointer);
    }

    private static native long createNative();

    private Denoise(long pointer) {
        this.pointer = pointer;
    }

    public float[] process(float[] samples) throws DenoiseException {
        if (!this.isOpen()) {
            throw new DenoiseException("Denoise is closed");
        }
        return this.processNative(samples);
    }

    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.closeNative();
    }

    public boolean isOpen() {
        return this.pointer > 0L;
    }

    private native float[] processNative(float[] var1);

    private native void closeNative();
}

