/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.waypoint;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Since;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Pattern;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.waypoint.WaypointGroupStore;
import journeymap.common.waypoint.WaypointIcon;
import journeymap.common.waypoint.WaypointPos;
import journeymap.common.waypoint.WaypointSettings;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class WaypointImpl
implements Waypoint {
    public static final int VERSION = 1;
    public static final Gson GSON = new GsonBuilder().setVersion(1.0).create();
    private static final Pattern CSS_SAFE_PATTERN = Pattern.compile("[^\\w\\p{L}]+", 256);
    @Since(value=1.0)
    protected String version = "1";
    @Since(value=1.0)
    protected final String guid;
    protected String groupId;
    @Since(value=1.0)
    protected String modId;
    @Since(value=1.0)
    protected String name;
    @Since(value=1.0)
    protected WaypointPos pos;
    @Since(value=1.0)
    protected int color;
    @Since(value=1.0)
    protected String origin;
    @Since(value=1.0)
    protected WaypointSettings settings;
    @Since(value=1.0)
    protected WaypointIcon icon;
    @Since(value=1.0)
    protected TreeSet<String> dimensions;
    protected String customData;
    protected transient boolean dirty;

    public WaypointImpl() {
        this.guid = UUID.randomUUID().toString();
    }

    @ApiStatus.Internal
    public WaypointImpl(String name, String guid) {
        this.guid = guid;
        this.name = name;
        this.setGroupId("journeymap_default");
    }

    @Deprecated
    public WaypointImpl(WaypointImpl original) {
        this(original.name, original.pos, original.settings.isEnabled(), original.color, original.origin, original.dimensions == null || original.dimensions.isEmpty() ? null : original.dimensions.first(), original.dimensions, original.settings.showDeviation(), original.icon != null ? new WaypointIcon(original.getIcon()) : new WaypointIcon(), original.groupId);
        this.pos = original.pos;
        this.modId = original.modId;
    }

    @Deprecated
    private WaypointImpl(String name, WaypointPos pos, boolean enable, int color, String origin, String currentDimension, Collection<String> dimensions, boolean showDeviation, WaypointIcon icon, String groupId) {
        this.guid = UUID.randomUUID().toString();
        if (name == null) {
            name = WaypointImpl.createName(pos);
        }
        this.dimensions = dimensions == null ? new TreeSet() : new TreeSet<String>(dimensions);
        if (currentDimension != null) {
            this.dimensions.add(currentDimension);
        }
        this.name = name;
        this.color = color;
        this.origin = origin;
        if (this.settings == null) {
            this.settings = new WaypointSettings();
        }
        this.settings.setPersistent(true);
        this.settings.setEnabled(enable);
        this.settings.setShowDeviation(showDeviation);
        this.setGroupId(groupId);
        this.icon = icon;
        if (icon == null) {
            if (WaypointGroupStore.DEATH.getGuid().equals(groupId)) {
                this.setIcon(new WaypointIcon(WaypointIcon.DEFAULT_ICON_DEATH));
            } else {
                this.setIcon(new WaypointIcon(WaypointIcon.DEFAULT_ICON_NORMAL));
            }
        }
        this.pos = pos;
        this.setLocation(pos.x, pos.y, pos.z, currentDimension);
    }

    public WaypointImpl(String name, String version, String modId, String guid, String origin, String groupId, WaypointPos pos, Integer color, WaypointIcon icon, WaypointSettings settings, TreeSet<String> dimensions, Optional<String> customData) {
        this.name = name;
        this.guid = guid;
        this.origin = origin;
        this.pos = pos;
        this.color = color;
        this.icon = icon;
        this.dimensions = dimensions;
        this.version = version;
        this.modId = modId;
        this.settings = settings;
        this.setGroupId(groupId);
        customData.ifPresent(this::setCustomData);
        if (dimensions.size() == 1) {
            pos.setPrimaryDimension(dimensions.first());
        }
    }

    private static String createName(WaypointPos pos) {
        return String.format("%s, %s", pos.x, pos.y);
    }

    public void markDirty() {
        this.setDirty(true);
    }

    public boolean isDirty() {
        return this.dirty || this.settings.isDirty() || this.icon.isDirty();
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        if (this.settings != null) {
            this.settings.setDirty(dirty);
        }
        if (this.icon != null) {
            this.icon.setDirty(dirty);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getModId() {
        return this.modId;
    }

    public void setModId(String modId) {
        this.modId = modId;
        this.markDirty();
    }

    public String getId() {
        return String.format("%s_%s", this.modId, this.pos).replaceAll(CSS_SAFE_PATTERN.pattern(), "-");
    }

    public String getGuid() {
        return this.guid;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
        this.markDirty();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.markDirty();
    }

    public void setPos(int x, int y, int z) {
        this.setX(x);
        this.setZ(z);
        this.setY(y);
        this.markDirty();
    }

    public void setBlockPos(class_2338 pos) {
        this.setX(pos.method_10263());
        this.setZ(pos.method_10260());
        this.setY(pos.method_10264());
        this.markDirty();
    }

    public class_2338 getBlockPos() {
        return this.pos.asBlockPos();
    }

    public WaypointPos getPos() {
        return this.pos;
    }

    public void setPos(WaypointPos pos) {
        this.pos = pos;
        this.markDirty();
    }

    public int getX() {
        return this.pos.x;
    }

    public void setX(int x) {
        this.pos.setX(x);
        this.markDirty();
    }

    public int getY() {
        return this.pos.y;
    }

    public void setY(int y) {
        this.pos.setY(y);
        this.markDirty();
    }

    public int getZ() {
        return this.pos.z;
    }

    public void setZ(int z) {
        this.pos.setZ(z);
        this.markDirty();
    }

    public int getRed() {
        return this.color >> 16 & 0xFF;
    }

    public void setRed(int red) {
        this.updateColors(red, this.getGreen(), this.getBlue());
        this.markDirty();
    }

    public int getGreen() {
        return this.color >> 8 & 0xFF;
    }

    public void setGreen(int green) {
        this.updateColors(this.getRed(), green, this.getBlue());
        this.markDirty();
    }

    public int getBlue() {
        return this.color & 0xFF;
    }

    public void setBlue(int blue) {
        this.updateColors(this.getRed(), this.getGreen(), blue);
        this.markDirty();
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
        this.markDirty();
    }

    public WaypointSettings getSettings() {
        return this.settings;
    }

    public void setSettings(WaypointSettings settings) {
        this.settings = settings;
        this.markDirty();
    }

    public WaypointIcon getIcon() {
        return this.icon;
    }

    public void setIcon(WaypointIcon icon) {
        this.icon = icon;
        this.markDirty();
    }

    public TreeSet<String> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Collection<String> dims) {
        this.dimensions = new TreeSet<String>(dims);
        this.markDirty();
    }

    public void setPrimaryDimension(String dimension) {
        this.pos.setPrimaryDimension(dimension);
        this.markDirty();
    }

    public String getPrimaryDimension() {
        return this.pos.getPrimaryDimension();
    }

    public boolean isPersistent() {
        return this.settings.isPersistent();
    }

    public void setPersistent(boolean persistent) {
        this.settings.setPersistent(persistent);
        this.markDirty();
    }

    public WaypointGroup getGroup() {
        return this.groupId == null ? WaypointGroupStore.getInstance().get(WaypointGroupStore.DEFAULT.getGuid()) : WaypointGroupStore.getInstance().get(this.groupId);
    }

    public boolean isEnabled() {
        try {
            return this.settings.isEnabled() && this.getGroup().isEnabled();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setEnabled(boolean enabled) {
        this.settings.setEnabled(enabled);
        this.markDirty();
    }

    public boolean showDeviation() {
        return this.settings.showDeviation();
    }

    public void setShowDeviation(boolean showDeviation) {
        this.settings.setShowDeviation(showDeviation);
        this.markDirty();
    }

    public int getIconRotation() {
        return this.icon.getRotation();
    }

    public void setIconRotation(int rotation) {
        this.icon.setRotation(rotation);
        this.markDirty();
    }

    public Integer getIconColor() {
        return this.icon.getColor();
    }

    public void setIconColor(Integer color) {
        this.icon.setColor(color);
        this.markDirty();
    }

    public float getIconOpacity() {
        return this.icon.getOpacity();
    }

    public void setIconOpacity(float opacity) {
        this.icon.setOpacity(opacity);
        this.markDirty();
    }

    public class_2960 getIconIdentifier() {
        return this.icon.getIdentifier();
    }

    public void setIconResourceLoctaion(class_2960 identifier) {
        this.icon.setIdentifier(identifier);
        this.markDirty();
    }

    public int getIconTextureWidth() {
        return this.icon.getTextureWidth();
    }

    public void setIconTextureWidth(Integer width) {
        this.icon.setTextureWidth(width);
        this.markDirty();
    }

    public int getIconTextureHeight() {
        return this.icon.getTextureHeight();
    }

    public void setIconTextureHeight(Integer height) {
        this.icon.setTextureHeight(height);
        this.markDirty();
    }

    public void setCustomData(@Nullable String customData) {
        this.customData = customData;
    }

    @Nullable
    public String getCustomData() {
        return this.customData;
    }

    public static WaypointImpl fromJsonString(String json) {
        return (WaypointImpl)GSON.fromJson(json, WaypointImpl.class);
    }

    public WaypointImpl setLocation(int x, int y, int z, String currentDimension) {
        this.pos.setX(x);
        this.pos.setY(y);
        this.pos.setZ(z);
        this.pos.setPrimaryDimension(currentDimension);
        this.markDirty();
        return this;
    }

    public boolean netherShiftLeft(class_1937 world) {
        return this.pos != null && "minecraft:the_nether".equalsIgnoreCase(this.pos.primaryDimension) && !DimensionHelper.isNetherWorld(world);
    }

    public boolean neitherShiftRight(class_1937 world) {
        return this.pos != null && !"minecraft:the_nether".equalsIgnoreCase(this.pos.primaryDimension) && DimensionHelper.isNetherWorld(world);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    private void updateColors(int red, int green, int blue) {
        this.color = 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
        this.markDirty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WaypointImpl waypoint = (WaypointImpl)o;
        if (this.getSettings().isEnabled() != waypoint.getSettings().isEnabled()) {
            return false;
        }
        if (this.color != waypoint.color) {
            return false;
        }
        if (this.pos.x != waypoint.pos.x) {
            return false;
        }
        if (this.pos.y != waypoint.pos.y) {
            return false;
        }
        if (this.pos.z != waypoint.pos.z) {
            return false;
        }
        if (!this.dimensions.equals(waypoint.dimensions)) {
            return false;
        }
        if (!this.icon.equals(waypoint.icon)) {
            return false;
        }
        if (!this.getId().equals(waypoint.getId())) {
            return false;
        }
        if (!this.name.equals(waypoint.name)) {
            return false;
        }
        if (this.origin.equals(waypoint.origin)) {
            return false;
        }
        if (this.getSettings().showDeviation() != waypoint.getSettings().showDeviation()) {
            return false;
        }
        return Objects.equals(this.getIcon().getColor(), waypoint.getIcon().getColor());
    }

    public String toString() {
        return GSON.toJson((Object)this);
    }
}

