/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt.waypoint;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.Map;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.common.codecs.WaypointCodecs;
import journeymap.common.codecs.WaypointGroupCodecs;
import journeymap.common.waypoint.WaypointGroupImpl;
import journeymap.common.waypoint.WaypointImpl;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;

public abstract class WaypointDAO {
    protected static final String GROUPS = "groups";
    protected static final String WAYPOINTS = "waypoints";
    protected class_2487 data;
    private boolean dirty = false;

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public abstract Map<String, WaypointGroupImpl> decodeGroups(class_2487 var1);

    public abstract class_2487 encodeGroups(Collection<WaypointGroupImpl> var1);

    public abstract Map<String, WaypointImpl> decodeWaypoints(class_2487 var1);

    public abstract class_2487 encodeWaypoints(Collection<WaypointImpl> var1);

    public abstract void save(boolean var1);

    public void deleteGroup(WaypointGroup group) {
        this.setDirty(true);
        ((class_2487)this.data.method_10562(GROUPS).get()).method_10551(group.getGuid());
    }

    public void deleteWaypoint(WaypointImpl waypoint) {
        this.setDirty(true);
        ((class_2487)this.data.method_10562(WAYPOINTS).get()).method_10551(waypoint.getGuid());
    }

    public void addGroup(WaypointGroup group) {
        DataResult result;
        this.setDirty(true);
        if (!this.data.method_10545(GROUPS)) {
            this.data.method_10566(GROUPS, (class_2520)new class_2487());
        }
        if ((result = WaypointGroupCodecs.V1_WAYPOINT_GROUP_CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)((WaypointGroupImpl)group))).result().isPresent()) {
            ((class_2487)this.data.method_10562(GROUPS).get()).method_10566(group.getGuid(), (class_2520)result.result().get());
        }
    }

    public void addWaypoint(WaypointImpl waypoint) {
        DataResult result;
        this.setDirty(true);
        if (!this.data.method_10545(WAYPOINTS)) {
            this.data.method_10566(WAYPOINTS, (class_2520)new class_2487());
        }
        if ((result = WaypointCodecs.V1_WAYPOINT_CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)waypoint)).result().isPresent()) {
            ((class_2487)this.data.method_10562(WAYPOINTS).get()).method_10566(waypoint.getGuid(), (class_2520)result.result().get());
        }
    }

    public abstract Map<String, WaypointGroupImpl> getGroups();

    public abstract Map<String, WaypointImpl> getWaypoints();

    public abstract WaypointImpl decodeWaypoint(class_2520 var1);

    public abstract class_2520 encodeWaypoint(WaypointImpl var1);

    public abstract WaypointImpl copyWaypoint(WaypointImpl var1);
}

