/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.buttons;

import java.util.ArrayList;
import java.util.Iterator;
import journeymap.client.Constants;
import journeymap.client.ui.component.buttons.Button;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_4185;

public class OnOffButton
extends Button {
    protected Boolean toggled = true;
    protected String labelOn;
    protected String labelOff;
    protected ArrayList<ToggleListener> toggleListeners = new ArrayList(0);

    public OnOffButton(String labelOn, String labelOff, boolean toggled, class_4185.class_4241 onPress) {
        super(toggled ? labelOn : labelOff, onPress);
        this.labelOn = labelOn;
        this.labelOff = labelOff;
        this.setToggled(toggled);
        this.finishInit();
    }

    public void setLabels(String labelOn, String labelOff) {
        this.labelOn = labelOn;
        this.labelOff = labelOff;
        this.updateLabel();
    }

    @Override
    protected void updateLabel() {
        if (this.labelOn != null && this.labelOff != null) {
            this.method_25355((class_2561)Constants.getStringTextComponent(this.getToggled() != false ? this.labelOn : this.labelOff));
        }
    }

    public void toggle() {
        this.setToggled(this.getToggled() == false);
    }

    @Override
    public int getFitWidth(class_327 fr) {
        int max = fr.method_1727(this.method_25369().getString());
        if (this.labelOn != null) {
            max = Math.max(max, fr.method_1727(this.labelOn));
        }
        if (this.labelOff != null) {
            max = Math.max(max, fr.method_1727(this.labelOff));
        }
        return max + this.WIDTH_PAD;
    }

    @Override
    public boolean method_37303() {
        return super.method_37303();
    }

    public Boolean getToggled() {
        return this.toggled;
    }

    public void setToggled(Boolean toggled) {
        this.setToggled(toggled, true);
    }

    public void setToggled(Boolean toggled, boolean notifyToggleListener) {
        if (this.toggled == toggled || !this.isEnabled() || !this.field_22764) {
            return;
        }
        boolean allowChange = true;
        try {
            if (notifyToggleListener && !this.toggleListeners.isEmpty()) {
                ToggleListener listener;
                Iterator<ToggleListener> iterator = this.toggleListeners.iterator();
                while (iterator.hasNext() && (allowChange = (listener = iterator.next()).onToggle(this, toggled))) {
                }
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error trying to toggle button '" + String.valueOf(this.method_25369()) + "': " + LogFormatter.toString(t));
            allowChange = false;
        }
        if (allowChange) {
            this.toggled = toggled;
            this.updateLabel();
        }
    }

    public void addToggleListener(ToggleListener toggleListener) {
        this.toggleListeners.add(toggleListener);
    }

    public static interface ToggleListener {
        public boolean onToggle(OnOffButton var1, boolean var2);
    }
}

