/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.load.registration;

import com.google.common.collect.ImmutableListMultimap;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.core.collect.ListMultiMap;
import mezz.jei.library.ingredients.TypedIngredient;
import net.minecraft.class_1799;
import net.minecraft.class_1935;

public class RecipeCatalystRegistration
implements IRecipeCatalystRegistration {
    private final ListMultiMap<IRecipeType<?>, ITypedIngredient<?>> recipeCatalysts = new ListMultiMap();
    private final IIngredientManager ingredientManager;
    private final IJeiHelpers jeiHelpers;

    public RecipeCatalystRegistration(IIngredientManager ingredientManager, IJeiHelpers jeiHelpers) {
        this.ingredientManager = ingredientManager;
        this.jeiHelpers = jeiHelpers;
    }

    @Override
    public IIngredientManager getIngredientManager() {
        return this.ingredientManager;
    }

    @Override
    public IJeiHelpers getJeiHelpers() {
        return this.jeiHelpers;
    }

    @Override
    public <T> void addCraftingStations(IRecipeType<?> recipeType, IIngredientType<T> ingredientType, List<T> ingredients) {
        ErrorUtil.checkNotNull(recipeType, "recipeType");
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotNull(ingredients, "ingredients");
        for (T ingredient : ingredients) {
            ITypedIngredient<T> typedIngredient = TypedIngredient.createAndFilterInvalid(this.ingredientManager, ingredientType, ingredient, true);
            if (typedIngredient == null) {
                throw new IllegalArgumentException("Recipe catalyst must be a valid ingredient");
            }
            this.recipeCatalysts.put(recipeType, typedIngredient);
        }
    }

    @Override
    public void addCraftingStation(IRecipeType<?> recipeType, class_1935 ... ingredients) {
        ErrorUtil.checkNotNull(recipeType, "recipeType");
        ErrorUtil.checkNotNull(ingredients, "ingredients");
        for (class_1935 itemLike : ingredients) {
            class_1799 itemStack = itemLike.method_8389().method_7854();
            ITypedIngredient<class_1799> typedIngredient = TypedIngredient.createAndFilterInvalid(this.ingredientManager, VanillaTypes.ITEM_STACK, itemStack, true);
            if (typedIngredient == null) {
                throw new IllegalArgumentException("Recipe catalyst must be a valid ingredient");
            }
            this.recipeCatalysts.put(recipeType, typedIngredient);
        }
    }

    @Override
    public <T> void addCraftingStation(IRecipeType<?> recipeType, IIngredientType<T> ingredientType, T ingredient) {
        ErrorUtil.checkNotNull(recipeType, "recipeType");
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        ITypedIngredient<T> typedIngredient = TypedIngredient.createAndFilterInvalid(this.ingredientManager, ingredientType, ingredient, true);
        if (typedIngredient == null) {
            throw new IllegalArgumentException("Recipe catalyst must be a valid ingredient");
        }
        this.recipeCatalysts.put(recipeType, typedIngredient);
    }

    @Override
    public <T> void addRecipeCatalyst(IIngredientType<T> ingredientType, T ingredient, IRecipeType<?> ... recipeTypes) {
        ErrorUtil.checkNotEmpty(recipeTypes, "recipeTypes");
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        for (IRecipeType<?> recipeType : recipeTypes) {
            ErrorUtil.checkNotNull(recipeType, "recipeType");
            ITypedIngredient<T> typedIngredient = TypedIngredient.createAndFilterInvalid(this.ingredientManager, ingredientType, ingredient, true);
            if (typedIngredient == null) {
                throw new IllegalArgumentException("Recipe catalyst must be a valid ingredient");
            }
            this.recipeCatalysts.put(recipeType, typedIngredient);
        }
    }

    public ImmutableListMultimap<IRecipeType<?>, ITypedIngredient<?>> getRecipeCatalysts() {
        return this.recipeCatalysts.toImmutable();
    }
}

