/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.compat;

import mod.crend.autohud.AutoHud;
import mod.crend.autohud.api.AutoHudApi;
import mod.crend.autohud.component.Component;
import mod.crend.autohud.component.Components;
import mod.crend.autohud.component.state.BooleanComponentState;
import mod.crend.autohud.config.ConfigHandler;
import mod.crend.autohud.render.ComponentRenderer;
import mod.crend.dynamiccrosshair.component.CrosshairHandler;
import mod.crend.dynamiccrosshair.render.CrosshairRenderer;
import mod.crend.dynamiccrosshair.style.CrosshairStyle;
import mod.crend.dynamiccrosshairapi.DynamicCrosshair;
import mod.crend.dynamiccrosshairapi.VersionUtils;
import mod.crend.dynamiccrosshairapi.crosshair.CrosshairPart;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_746;

public class AutoHudCompat
implements AutoHudApi {
    public static final Component CROSSHAIR_SECONDARY = Component.builder((class_2960)DynamicCrosshair.AUTOHUD_COMPONENT_SECONDARY).config((ConfigHandler.IComponent)AutoHud.config.crosshair()).build();
    public static final Component CROSSHAIR_MODIFIER = Component.builder((class_2960)DynamicCrosshair.AUTOHUD_COMPONENT_MODIFIER).config((ConfigHandler.IComponent)AutoHud.config.crosshair()).build();
    public static final ComponentRenderer CROSSHAIR_RENDER_PRIMARY = ComponentRenderer.builder((Component)Components.Crosshair).build();
    public static final ComponentRenderer CROSSHAIR_RENDER_SECONDARY = ComponentRenderer.builder((Component)CROSSHAIR_SECONDARY).build();
    public static final ComponentRenderer CROSSHAIR_RENDER_MODIFIER = ComponentRenderer.builder((Component)CROSSHAIR_MODIFIER).build();

    public String modId() {
        return "dynamiccrosshair";
    }

    public static boolean shouldRenderCrosshairPrimary() {
        return CrosshairHandler.getActiveCrosshair().getCrosshair().hasPrimaryInteraction();
    }

    public static boolean shouldRenderCrosshairSecondary() {
        return CrosshairHandler.getActiveCrosshair().getCrosshair().hasSecondaryInteraction();
    }

    public static boolean shouldRenderCrosshairModifier() {
        return AutoHudCompat.shouldRenderCrosshairPrimary();
    }

    public void initState(class_746 player) {
        Components.Crosshair.state = new BooleanComponentState(Components.Crosshair, AutoHudCompat::shouldRenderCrosshairPrimary);
        AutoHudCompat.CROSSHAIR_SECONDARY.state = new BooleanComponentState(CROSSHAIR_SECONDARY, AutoHudCompat::shouldRenderCrosshairSecondary);
        AutoHudCompat.CROSSHAIR_MODIFIER.state = new BooleanComponentState(CROSSHAIR_MODIFIER, AutoHudCompat::shouldRenderCrosshairModifier);
    }

    public void tickState(class_746 player) {
        CrosshairHandler.forceShowCrosshair = CrosshairRenderer.autoHudCompat = AutoHud.config.crosshair().active();
    }

    static ComponentRenderer getRenderer(CrosshairPart part) {
        return switch (part) {
            default -> throw new MatchException(null, null);
            case CrosshairPart.PRIMARY -> CROSSHAIR_RENDER_PRIMARY;
            case CrosshairPart.SECONDARY -> CROSSHAIR_RENDER_SECONDARY;
            case CrosshairPart.MODIFIER -> CROSSHAIR_RENDER_MODIFIER;
        };
    }

    public static void renderCrosshair(class_332 context, CrosshairPart part, CrosshairStyle style, int x, int y) {
        AutoHudCompat.getRenderer(part).wrap(context, () -> {
            int argb = style.color();
            CrosshairRenderer.renderCrosshair(context, style.identifier(), style.enableBlend() ? VersionUtils.getCrosshair() : VersionUtils.getGuiTextured(), x, y, argb);
        });
    }
}

