/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import org.jspecify.annotations.Nullable;
import snownee.jade.api.AccessorClientHandler;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.impl.EntityAccessorImpl;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.ui.JadeUIInternal;
import snownee.jade.network.RequestEntityPacket;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.WailaExceptionHandler;

public class EntityAccessorClientHandler
implements AccessorClientHandler<EntityAccessor> {
    @Override
    public boolean shouldDisplay(EntityAccessor accessor) {
        class_1542 itemEntity;
        IWailaConfig.General general = IWailaConfig.get().general();
        if (!general.getDisplayEntities()) {
            return false;
        }
        if (!general.getDisplayBosses() && CommonProxy.isBoss(accessor.getEntity())) {
            return false;
        }
        class_1297 class_12972 = accessor.getEntity();
        return !(class_12972 instanceof class_1542) || !(itemEntity = (class_1542)class_12972).method_6983().method_7960();
    }

    @Override
    public List<IServerDataProvider<EntityAccessor>> shouldRequestData(EntityAccessor accessor) {
        List<IServerDataProvider<EntityAccessor>> providers = WailaCommonRegistration.instance().entityDataProvidersOf(accessor.getEntity());
        if (providers.isEmpty()) {
            return List.of();
        }
        return providers.stream().filter(provider -> {
            try {
                return provider.shouldRequestData(accessor);
            }
            catch (Exception e) {
                WailaExceptionHandler.handleErr(e, provider, null);
                return false;
            }
        }).toList();
    }

    @Override
    public void requestData(EntityAccessor accessor, List<IServerDataProvider<EntityAccessor>> providers) {
        ClientProxy.sendPacket(new RequestEntityPacket(new EntityAccessorImpl.SyncData(accessor), providers));
    }

    @Override
    public @Nullable Element getIcon(EntityAccessor accessor) {
        Element icon = null;
        class_1297 entity = accessor.getEntity();
        if (entity instanceof class_1542) {
            icon = JadeUI.item(((class_1542)entity).method_6983());
        } else {
            class_1799 stack = accessor.getPickedResult();
            if (!(stack.method_7960() || stack.method_7909() instanceof class_1826 && entity instanceof class_1309)) {
                icon = JadeUI.item(stack);
            }
        }
        for (IComponentProvider<EntityAccessor> provider : WailaClientRegistration.instance().getEntityIconProviders(entity, this::isEnabled)) {
            try {
                Element element = provider.getIcon(accessor, IWailaConfig.get().plugin(), icon);
                if (JadeUI.isEmptyElement(element)) continue;
                icon = element;
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, provider, null);
            }
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gatherComponents(EntityAccessor accessor, Function<IJadeProvider, ITooltip> tooltipProvider) {
        for (IComponentProvider<EntityAccessor> provider : WailaClientRegistration.instance().getEntityProviders(accessor.getEntity(), this::isEnabled)) {
            ITooltip tooltip = tooltipProvider.apply(provider);
            try {
                JadeUIInternal.setContextUid(provider.getUid());
                provider.appendTooltip(tooltip, accessor, IWailaConfig.get().plugin());
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, provider, tooltip::add);
            }
            finally {
                JadeUIInternal.setContextUid(null);
            }
        }
    }
}

