/*
 * Decompiled with CFR 0.152.
 */
package thaumicboots.main.utils;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ChunkCoords {
    public final int dimension;
    public final int x;
    public final int y;
    public final int z;

    public ChunkCoords(TileEntity entity) {
        this(entity.func_145831_w(), entity.field_145851_c, entity.field_145848_d, entity.field_145849_e);
    }

    public ChunkCoords(Entity entity) {
        this(entity.field_70170_p, entity.field_70176_ah, entity.field_70162_ai, entity.field_70164_aj);
    }

    public ChunkCoords(World world, int xCoord, int yCoord, int zCoord) {
        this(world.field_73011_w.field_76574_g, xCoord, yCoord, zCoord);
    }

    public ChunkCoords(int dimId, int xCoord, int yCoord, int zCoord) {
        this.dimension = dimId;
        this.x = xCoord;
        this.y = yCoord;
        this.z = zCoord;
    }

    public ChunkCoords add(ChunkCoords coords) {
        return new ChunkCoords(coords.dimension, this.x + coords.x, this.y + coords.y, this.z + coords.z);
    }

    public ChunkCoords subtract(ChunkCoords coords) {
        return new ChunkCoords(coords.dimension, this.x - coords.x, this.y - coords.y, this.z - coords.z);
    }

    public ChunkCoords inDimension(int dimId) {
        return new ChunkCoords(dimId, this.x, this.y, this.z);
    }

    public ChunkCoords inDimension(World world) {
        return new ChunkCoords(world.field_73011_w.field_76574_g, this.x, this.y, this.z);
    }

    public static void writeToNBT(ChunkCoords obj, NBTTagCompound tagRoot) {
        if (obj != null) {
            NBTTagCompound coordsTag = new NBTTagCompound();
            coordsTag.func_74768_a("dim", obj.dimension);
            coordsTag.func_74768_a("xPos", obj.x);
            coordsTag.func_74768_a("yPos", obj.y);
            coordsTag.func_74768_a("zPos", obj.z);
            tagRoot.func_74782_a("chunkCoords", (NBTBase)coordsTag);
        }
    }

    public static ChunkCoords readFromNBT(NBTTagCompound tagRoot) {
        if (tagRoot.func_74764_b("chunkCoords")) {
            NBTTagCompound coordsTag = (NBTTagCompound)tagRoot.func_74781_a("chunkCoords");
            int dim = coordsTag.func_74762_e("dim");
            int x = coordsTag.func_74762_e("xPos");
            int y = coordsTag.func_74762_e("yPos");
            int z = coordsTag.func_74762_e("zPos");
            return new ChunkCoords(dim, x, y, z);
        }
        return null;
    }
}

