/*
 * Decompiled with CFR 0.152.
 */
package com.muxiu1997.sharewhereiam.network;

import com.muxiu1997.sharewhereiam.integration.Mods;
import com.muxiu1997.sharewhereiam.network.NetworkHandler;
import com.muxiu1997.sharewhereiam.util.WaypointUtil;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;

public class MessageShareWaypoint
implements IMessage {
    public String playerName;
    public String waypointJson;
    public String additionalInformation;

    public MessageShareWaypoint() {
    }

    @SideOnly(value=Side.CLIENT)
    public MessageShareWaypoint(WaypointUtil.PlayerWaypoint playerWaypoint) {
        this(playerWaypoint, "");
    }

    @SideOnly(value=Side.CLIENT)
    public MessageShareWaypoint(WaypointUtil.PlayerWaypoint playerWaypoint, String additionalInformation) {
        this.playerName = playerWaypoint.player.getDisplayName();
        this.waypointJson = playerWaypoint.waypoint.toString();
        this.additionalInformation = additionalInformation;
    }

    public void fromBytes(ByteBuf buf) {
        this.playerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.waypointJson = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.additionalInformation = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerName);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.waypointJson);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.additionalInformation);
    }

    public static class Handler
    implements IMessageHandler<MessageShareWaypoint, IMessage> {
        public IMessage onMessage(MessageShareWaypoint message, MessageContext ctx) {
            if (ctx.side.isClient()) {
                Handler.handleClientSideMessage(message);
            } else {
                Handler.handleServerSideMessage(message);
            }
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        private static void handleClientSideMessage(MessageShareWaypoint message) {
            if (Mods.JourneyMap.isLoaded()) {
                WaypointUtil.addShareWaypointChat(message.playerName, WaypointUtil.waypointFromString(message.waypointJson), message.additionalInformation);
            }
        }

        private static void handleServerSideMessage(MessageShareWaypoint message) {
            NetworkHandler.network.sendToAll((IMessage)message);
        }
    }
}

