/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.necrotempus.modules.features.title.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.github.cruciblemc.necrotempus.api.title.TitleComponent;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;

public class TitlePacket
implements IMessage {
    private TitleComponent component;
    private PacketType packetType = PacketType.SET;

    public TitlePacket() {
    }

    public TitlePacket(NBTTagCompound tagCompound, PacketType type) {
        this.component = TitleComponent.fromCompound(tagCompound);
        this.packetType = type;
    }

    public TitlePacket(TitleComponent title, PacketType type) {
        this.component = title;
        this.packetType = type;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tagCompound = ByteBufUtils.readTag((ByteBuf)buf);
        this.packetType = PacketType.valueOfString(tagCompound.func_74779_i("packetType"));
        this.component = TitleComponent.fromCompound(tagCompound);
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tagCompound = this.component.toNbt();
        tagCompound.func_74778_a("packetType", this.packetType.getName());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tagCompound);
    }

    public TitleComponent getComponent() {
        return this.component;
    }

    public PacketType getPacketType() {
        return this.packetType;
    }

    public static enum PacketType {
        SET("set"),
        REMOVE("remove");

        private final String name;

        private PacketType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static PacketType valueOfString(String name) {
            for (PacketType type : PacketType.values()) {
                if (!type.getName().equalsIgnoreCase(name)) continue;
                return type;
            }
            return SET;
        }
    }
}

