/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.necrotempus.modules.features.glyphs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.cruciblemc.necrotempus.NecroTempus;
import io.github.cruciblemc.necrotempus.modules.features.glyphs.CustomGlyphs;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Logger;

public class GlyphsRegistry
implements IResourceManagerReloadListener {
    private static final ConcurrentHashMap<Character, CustomGlyphs> GLYPHS_REGISTRY = new ConcurrentHashMap();

    public static void init() {
        ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)new GlyphsRegistry());
    }

    public static CustomGlyphs getCandidate(char key) {
        return GLYPHS_REGISTRY.get(Character.valueOf(key));
    }

    public void func_110549_a(IResourceManager resourceManager) {
        Logger logger = NecroTempus.getInstance().getLogger();
        JsonParser jsonParser = new JsonParser();
        GLYPHS_REGISTRY.clear();
        for (Object domain : resourceManager.func_135055_a()) {
            if (!(domain instanceof String)) continue;
            String dom = (String)domain;
            try {
                IResource resourceFile = resourceManager.func_110536_a(new ResourceLocation(dom, "glyphs/glyphs.json"));
                JsonElement jsonElement = jsonParser.parse((Reader)new InputStreamReader(resourceFile.func_110527_b()));
                JsonArray jsonArray = jsonElement.getAsJsonObject().getAsJsonArray("glyphs");
                if (jsonArray.size() == 0) {
                    logger.info(String.format("Resource domain (%s) has glyphs.json file, but this file is empty.", domain));
                    continue;
                }
                int loaded = 0;
                for (JsonElement entry : jsonArray) {
                    try {
                        JsonObject jsonObject = entry.getAsJsonObject();
                        char target = jsonObject.get("target").getAsCharacter();
                        String resource = jsonObject.get("resource").getAsString();
                        int horizontalPadding = jsonObject.get("horizontalPadding").getAsInt();
                        int verticalPadding = jsonObject.get("verticalPadding").getAsInt();
                        int width = jsonObject.get("width").getAsInt();
                        int height = jsonObject.get("height").getAsInt();
                        CustomGlyphs.FitMode fitMode = CustomGlyphs.FitMode.parse(jsonObject.get("fitMode").getAsString());
                        int charWidth = -1;
                        if (jsonObject.has("charWidth")) {
                            charWidth = jsonObject.get("charWidth").getAsInt();
                        }
                        CustomGlyphs customGlyphs = new CustomGlyphs(target, new ResourceLocation(resource), horizontalPadding, verticalPadding, width, height);
                        customGlyphs.setFitMode(fitMode);
                        customGlyphs.setCharWidth(charWidth);
                        GLYPHS_REGISTRY.put(Character.valueOf(target), customGlyphs);
                        ++loaded;
                    }
                    catch (Exception ignored) {
                        logger.error(String.format("Fail to parse a glyph {%s}", entry.toString()));
                    }
                }
                logger.info(String.format("Resource domain (%s) has glyphs.json file, registered %d elements", domain, loaded));
            }
            catch (Exception exception) {}
        }
    }
}

