/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.necrotempus.modules.features.bossbar.compat.crafttweaker;

import cpw.mods.fml.common.FMLCommonHandler;
import io.github.cruciblemc.necrotempus.api.bossbar.BossBarColor;
import io.github.cruciblemc.necrotempus.api.bossbar.BossBarType;
import io.github.cruciblemc.necrotempus.modules.features.bossbar.client.render.BossDisplayAdapterListener;
import io.github.cruciblemc.necrotempus.modules.features.bossbar.component.BossDisplayAdapter;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="necrotempus.crafttweaker.BossBar")
@ModOnly(value={"necrotempus"})
public class BossBar {
    @ZenMethod
    public static void customize(String entity, String type, int color) {
        MineTweakerAPI.apply((IUndoableAction)new BossBarCustomizeAction(entity, color, type));
    }

    public static class BossBarCustomizeAction
    implements IUndoableAction {
        private final String entity;
        private final BossBarColor color;
        private final BossBarType type;

        public BossBarCustomizeAction(Object entity, int color, Object type) {
            this.entity = (String)entity;
            this.color = BossBarColor.valueOfString("$" + color);
            this.type = BossBarType.valueOfString((String)type);
        }

        public boolean canUndo() {
            return true;
        }

        public void apply() {
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                BossDisplayAdapter bossDisplayAdapter = new BossDisplayAdapter(this.entity, this.color, this.type);
                BossDisplayAdapterListener.getCustomAdapters().add(bossDisplayAdapter);
            }
        }

        public void undo() {
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                BossDisplayAdapterListener.getCustomAdapters().removeIf(el -> el.getTargetClass().equalsIgnoreCase(this.entity));
            }
        }

        public String describe() {
            return String.format("Registering CustomBossBarAdapter for entity %s. (Color: RGB(%s), Type: %s)", this.entity, this.color.intValue(), this.type.getType());
        }

        public String describeUndo() {
            return String.format("Removing CustomBossBarAdapter for entity %s. (Color: RGB(%s), Type: %s)", this.entity, this.color.intValue(), this.type.getType());
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

