/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.necrotempus.modules.features.bossbar.client.render;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import io.github.cruciblemc.necrotempus.api.bossbar.BossBar;
import io.github.cruciblemc.necrotempus.api.bossbar.BossBarColor;
import io.github.cruciblemc.necrotempus.api.bossbar.BossBarType;
import io.github.cruciblemc.necrotempus.modules.features.bossbar.client.ClientBossBarManager;
import io.github.cruciblemc.necrotempus.modules.features.bossbar.component.BossDisplayAdapter;
import java.util.LinkedList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.util.ChatComponentText;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;

public class BossDisplayAdapterListener {
    private static BossDisplayAdapterListener instance;
    private static final LinkedList<BossDisplayAdapter> CUSTOM_ADAPTERS;

    public static BossDisplayAdapterListener getInstance() {
        return instance != null ? instance : new BossDisplayAdapterListener();
    }

    private BossDisplayAdapterListener() {
        instance = this;
    }

    public static LinkedList<BossDisplayAdapter> getCustomAdapters() {
        return CUSTOM_ADAPTERS;
    }

    @SubscribeEvent
    public void onRenderGameOverlayEvent(RenderGameOverlayEvent.Pre event) {
        if (event.type == RenderGameOverlayEvent.ElementType.BOSSHEALTH) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderLiving(RenderLivingEvent.Pre event) {
        EntityLivingBase entityLivingBase = event.entity;
        if (entityLivingBase instanceof IBossDisplayData) {
            IBossDisplayData bossDisplayData = (IBossDisplayData)entityLivingBase;
            BossBar bossBar = BossBar.createBossBar(event.entity.func_110124_au());
            bossBar.setText((ChatComponentText)bossDisplayData.func_145748_c_());
            bossBar.setPercentage(bossDisplayData.func_110143_aJ() / bossDisplayData.func_110138_aP());
            bossBar.setCreationTime(System.currentTimeMillis());
            boolean customized = false;
            for (BossDisplayAdapter adapter : CUSTOM_ADAPTERS) {
                if (!adapter.getTargetClass().equals(event.entity.getClass().getName())) continue;
                bossBar.setColor(adapter.getColor());
                if (adapter.getLazyColor() != -1) {
                    bossBar.setLazyColor(adapter.getLazyColor());
                }
                bossBar.setType(adapter.getType());
                customized = true;
                break;
            }
            if (!customized) {
                bossBar.setColor(BossBarColor.PINK);
                bossBar.setType(BossBarType.FLAT);
            }
            if (bossBar.getType() != BossBarType.NONE) {
                ClientBossBarManager.add(bossBar);
            }
        }
    }

    static {
        CUSTOM_ADAPTERS = new LinkedList<BossDisplayAdapter>(BossDisplayAdapter.defaultList());
    }
}

