/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.necrotempus.api.title;

import io.github.cruciblemc.necrotempus.api.title.TitleElement;
import io.github.cruciblemc.necrotempus.api.title.TitleManager;
import io.github.cruciblemc.necrotempus.api.title.TitleType;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class TitleComponent {
    private static TitleManager titleManager = new TitleManager();
    private int fadeIn = 500;
    private int stay = 3500;
    private int fadeOut = 1000;
    private final TitleElement[] elements = new TitleElement[2];

    public void addElement(TitleElement element) {
        this.elements[element.getType().ordinal()] = element;
    }

    public boolean hasElement(TitleType type) {
        return this.elements[type.ordinal()] != null;
    }

    public TitleElement getElement(TitleType type) {
        return this.elements[type.ordinal()];
    }

    public NBTTagCompound toNbt() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        nbtTagCompound.func_74768_a("fadeIn", this.fadeIn);
        nbtTagCompound.func_74768_a("stay", this.stay);
        nbtTagCompound.func_74768_a("fadeOut", this.fadeOut);
        for (TitleType type : TitleType.values()) {
            TitleElement titleElement = this.elements[type.ordinal()];
            if (titleElement == null) continue;
            nbtTagCompound.func_74782_a(type.name().toLowerCase(), (NBTBase)titleElement.toNbt());
        }
        return nbtTagCompound;
    }

    public static TitleComponent fromCompound(NBTTagCompound tagCompound) {
        TitleComponent component = new TitleComponent();
        component.fadeIn = tagCompound.func_74762_e("fadeIn");
        component.stay = tagCompound.func_74762_e("stay");
        component.fadeOut = tagCompound.func_74762_e("fadeOut");
        for (TitleType type : TitleType.values()) {
            String key = type.name().toLowerCase();
            if (!tagCompound.func_74764_b(key)) continue;
            component.addElement(TitleElement.fromCompound(tagCompound.func_74775_l(key)));
        }
        return component;
    }

    public int getFadeIn() {
        return this.fadeIn;
    }

    public int getStay() {
        return this.stay;
    }

    public int getFadeOut() {
        return this.fadeOut;
    }

    public TitleElement[] getElements() {
        return this.elements;
    }

    public void setFadeIn(int fadeIn) {
        this.fadeIn = fadeIn;
    }

    public void setStay(int stay) {
        this.stay = stay;
    }

    public void setFadeOut(int fadeOut) {
        this.fadeOut = fadeOut;
    }

    public static TitleManager getTitleManager() {
        return titleManager;
    }

    public static void setTitleManager(TitleManager titleManager) {
        TitleComponent.titleManager = titleManager;
    }
}

