/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.necrotempus.api.bossbar;

import io.github.cruciblemc.necrotempus.api.bossbar.BossBar;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.UUID;

public abstract class BossBarManager {
    private static final LinkedHashMap<UUID, HashSet<UUID>> players = new LinkedHashMap();

    public static BossBarManager commonInstance() {
        return new BossBarManager(){

            @Override
            public void add(UUID target, BossBar bossBar) {
            }

            @Override
            public void remove(BossBar bossBar) {
            }

            @Override
            public void remove(UUID target, BossBar bossBar) {
            }
        };
    }

    public Set<UUID> getPlayers(BossBar bossBar) {
        return this.getOrCreatePlayers(bossBar);
    }

    public boolean hasPlayer(BossBar bossBar, UUID player) {
        return this.getPlayers(bossBar).contains(player);
    }

    public boolean hasPlayers(BossBar bossBar) {
        return !this.getPlayers(bossBar).isEmpty();
    }

    public void removePlayer(UUID player, BossBar bossBar) {
        this.getPlayers(bossBar).remove(player);
        this.remove(player, bossBar);
    }

    public void addPlayer(UUID player, BossBar bossBar) {
        this.getPlayers(bossBar).add(player);
        this.add(player, bossBar);
    }

    public void removeAllPlayers(BossBar bossBar) {
        this.getPlayers(bossBar).clear();
        this.remove(bossBar);
    }

    private Set<UUID> getOrCreatePlayers(BossBar bossBar) {
        if (!players.containsKey(bossBar.getUuid())) {
            players.put(bossBar.getUuid(), new HashSet());
        }
        return players.get(bossBar.getUuid());
    }

    public abstract void add(UUID var1, BossBar var2);

    public abstract void remove(BossBar var1);

    public abstract void remove(UUID var1, BossBar var2);

    public void deliver(Set<UUID> players, Object packet) {
    }

    public final void sync(BossBar bossBar) {
        for (UUID uuid : this.getPlayers(bossBar)) {
            this.add(uuid, bossBar);
        }
    }
}

