/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.necrotempus.api.bossbar;

import io.github.cruciblemc.necrotempus.utils.ColorUtils;

public enum BossBarColor {
    PINK("pink", 15466679),
    BLUE("blue", 47084),
    RED("red", 15480064),
    GREEN("green", 1960960),
    YELLOW("yellow", 15264768),
    PURPLE("purple", 8061164),
    WHITE("white", 0xFFFFFF),
    LAZY("lazy", 47084);

    private final String identifier;
    private int color;

    private BossBarColor(String colorIdentifier, int color) {
        this.identifier = colorIdentifier;
        this.color = color;
    }

    public static BossBarColor lazyOf(int color) {
        BossBarColor barColor = LAZY;
        barColor.color = color;
        return barColor;
    }

    public static BossBarColor lazyOf(String color) {
        BossBarColor barColor = LAZY;
        barColor.color = ColorUtils.decodeColor(color).getRGB();
        return barColor;
    }

    public int intValue() {
        return this.color;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public static BossBarColor valueOfString(String name) {
        if (name.startsWith("$")) {
            return BossBarColor.lazyOf(Integer.parseInt(name.substring(1)));
        }
        for (BossBarColor type : BossBarColor.values()) {
            if (!type.identifier.equalsIgnoreCase(name)) continue;
            return type;
        }
        return PINK;
    }

    public String toString() {
        return "BossBarColor{colorIdentifier='" + this.identifier + '\'' + ", color=" + this.color + '}';
    }
}

