/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.api.util;

import eu.usrv.legacylootgames.blocks.DungeonLightSource;
import eu.usrv.yamcore.auxiliary.ItemDescriptor;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ChestGenHooks;
import ru.timeconqueror.lootgames.LootGames;
import ru.timeconqueror.lootgames.api.minigame.LootGame;
import ru.timeconqueror.lootgames.common.config.base.RewardConfig;
import ru.timeconqueror.lootgames.common.config.base.StagedRewardConfig;
import ru.timeconqueror.lootgames.registry.LGBlocks;
import ru.timeconqueror.lootgames.utils.future.BlockPos;
import ru.timeconqueror.lootgames.utils.future.BlockState;
import ru.timeconqueror.lootgames.utils.future.WorldExt;
import ru.timeconqueror.timecore.api.util.HorizontalDirection;
import ru.timeconqueror.timecore.api.util.MathUtils;
import ru.timeconqueror.timecore.api.util.RandHelper;

public class RewardUtils {
    public static void spawnFourStagedReward(WorldServer world, LootGame<?, ?> game, BlockPos centralPos, int rewardLevel, StagedRewardConfig.FourStagedRewardConfig rewardConfig) {
        BlockState state = BlockState.of(LGBlocks.DUNGEON_LAMP, DungeonLightSource.State.NORMAL.ordinal());
        WorldExt.setBlockState((World)world, centralPos.offset(1, 0, 1), state);
        WorldExt.setBlockState((World)world, centralPos.offset(1, 0, -1), state);
        WorldExt.setBlockState((World)world, centralPos.offset(-1, 0, 1), state);
        WorldExt.setBlockState((World)world, centralPos.offset(-1, 0, -1), state);
        rewardLevel = MathUtils.coerceInRange(rewardLevel, 0, 4);
        if (rewardLevel > 0) {
            int counter = 0;
            for (HorizontalDirection direction : HorizontalDirection.values()) {
                if (counter >= rewardLevel) break;
                RewardUtils.spawnLootChest(world, centralPos, direction, SpawnChestData.fromRewardConfig(game, rewardConfig.getStageByIndex(counter)));
                ++counter;
            }
        }
    }

    public static void spawnLootChest(WorldServer world, BlockPos centralPos, HorizontalDirection horizontalDirection, SpawnChestData chestData) {
        EnumFacing direction = horizontalDirection.get();
        String lootTable = chestData.getLootTableKey();
        WeightedRandomChestContent[] randomLoot = ChestGenHooks.getItems((String)lootTable, (Random)RandHelper.RAND);
        BlockPos pos = centralPos.offset(direction.func_82601_c(), 0, direction.func_82599_e());
        WorldExt.setBlock((World)world, pos, (Block)Blocks.field_150486_ae, 3);
        IInventory chestTile = (IInventory)WorldExt.getTileEntity((World)world, pos);
        if (chestTile != null) {
            if (randomLoot.length == 0) {
                LootGames.LOGGER.error("Received LootTable '{}' is empty for {} stage. Skipping Chest-Gen to avoid NPE Crash", new Object[]{lootTable, chestData.getGameName()});
                ItemDescriptor sorryItem = ItemDescriptor.fromString((String)"minecraft:stone");
                String lore = String.join((CharSequence)"\",\"", "Modpack creator failed to configure", "the Loot Tables properly.", String.format("Please report that Loot Table [%s]", lootTable), String.format("for %s stage is broken.", chestData.getGameName()), "Thank you!");
                ItemStack sorryStack = sorryItem.getItemStackwNBT(1, String.format("{display:{Name:\"The Sorry-Stone\",Lore:[\"%s\"]}}", lore));
                chestTile.func_70299_a(0, sorryStack);
            } else {
                int count = RandHelper.RAND.nextInt(chestData.getMaxItems()) + chestData.getMinItems();
                WeightedRandomChestContent.func_76293_a((Random)RandHelper.RAND, (WeightedRandomChestContent[])randomLoot, (IInventory)chestTile, (int)count);
            }
        }
    }

    public static class SpawnChestData {
        private final String lootTableRL;
        private final String gameName;
        private final int minItems;
        private final int maxItems;

        public static SpawnChestData fromRewardConfig(LootGame<?, ?> game, RewardConfig rewardConfig) {
            return new SpawnChestData(game, rewardConfig.getLootTable(game.getWorld()), rewardConfig.minItems, rewardConfig.maxItems);
        }

        public SpawnChestData(LootGame<?, ?> game, String lootTableRL, int minItems, int maxItems) {
            this.lootTableRL = lootTableRL;
            this.minItems = minItems;
            this.maxItems = maxItems;
            this.gameName = game.getClass().getSimpleName();
        }

        private String getGameName() {
            return this.gameName;
        }

        private int getMaxItems() {
            return this.maxItems;
        }

        private int getMinItems() {
            return this.minItems;
        }

        private String getLootTableKey() {
            return this.lootTableRL;
        }
    }
}

