/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing.advanced;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.fluid.IFluidStore;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.tooltip.TooltipHelper;
import gregtech.common.misc.GTStructureChannels;
import gregtech.common.pollution.PollutionConfig;
import gregtech.common.tileentities.machines.MTEHatchOutputME;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class MTEAdvDistillationTower
extends GTPPMultiBlockBase<MTEAdvDistillationTower>
implements ISurvivalConstructable {
    private Mode mMode = Mode.DistillationTower;
    protected static final String STRUCTURE_PIECE_BASE = "base";
    protected static final String STRUCTURE_PIECE_LAYER = "layer";
    protected static final String STRUCTURE_PIECE_LAYER_HINT = "layerHint";
    protected static final String STRUCTURE_PIECE_TOP_HINT = "topHint";
    protected static final int DT_MODE_MAX_PARALLELS = 12;
    protected final List<List<MTEHatchOutput>> mOutputHatchesByLayer = new ArrayList<List<MTEHatchOutput>>();
    protected int mHeight;
    protected int mCasing;
    protected boolean mTopLayerFound;
    private static IStructureDefinition<MTEAdvDistillationTower> STRUCTURE_DEFINITION = null;

    public MTEAdvDistillationTower(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEAdvDistillationTower(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEAdvDistillationTower(this.mName);
    }

    @Override
    public IStructureDefinition<MTEAdvDistillationTower> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            IHatchElement<MTEAdvDistillationTower> layeredOutputHatch = HatchElement.OutputHatch.withCount(MTEAdvDistillationTower::getCurrentLayerOutputHatchCount).withAdder(MTEAdvDistillationTower::addLayerOutputHatch);
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_BASE, StructureUtility.transpose((String[][])new String[][]{{"b~b", "bbb", "bbb"}})).addShape(STRUCTURE_PIECE_LAYER, StructureUtility.transpose((String[][])new String[][]{{"lll", "lcl", "lll"}})).addShape(STRUCTURE_PIECE_LAYER_HINT, StructureUtility.transpose((String[][])new String[][]{{"lll", "l-l", "lll"}})).addShape(STRUCTURE_PIECE_TOP_HINT, StructureUtility.transpose((String[][])new String[][]{{"ttt", "ttt", "ttt"}})).addElement('b', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTEAdvDistillationTower.class).atLeast(HatchElement.Energy, HatchElement.OutputBus, HatchElement.InputHatch, HatchElement.InputBus, HatchElement.Maintenance).disallowOnly(ForgeDirection.UP).casingIndex(this.getCasingTextureId()).dot(1).build(), StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1)})).addElement('l', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTEAdvDistillationTower.class).atLeast(layeredOutputHatch, HatchElement.Energy, HatchElement.Maintenance).disallowOnly(ForgeDirection.UP, ForgeDirection.DOWN).casingIndex(this.getCasingTextureId()).dot(2).build(), GTStructureUtility.ofHatchAdder(GTPPMultiBlockBase::addMufflerToMachineList, this.getCasingTextureId(), 3), StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1)})).addElement('c', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(MTEAdvDistillationTower::onTopLayerFound, GTStructureUtility.ofHatchAdder(GTPPMultiBlockBase::addMufflerToMachineList, this.getCasingTextureId(), 3)), StructureUtility.onElementPass(MTEAdvDistillationTower::onTopLayerFound, GTStructureUtility.ofHatchAdder(GTPPMultiBlockBase::addOutputToMachineList, this.getCasingTextureId(), 3)), StructureUtility.onElementPass(MTEAdvDistillationTower::onTopLayerFound, GTStructureUtility.ofHatchAdder(GTPPMultiBlockBase::addMaintenanceToMachineList, this.getCasingTextureId(), 3)), StructureUtility.onElementPass(MTEAdvDistillationTower::onTopLayerFound, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1)), StructureUtility.isAir()})).addElement('t', GTStructureUtility.buildHatchAdder(MTEAdvDistillationTower.class).atLeast(layeredOutputHatch, HatchElement.Muffler).disallowOnly(ForgeDirection.DOWN).casingIndex(this.getCasingTextureId()).dot(2).buildAndChain(GregTechAPI.sBlockCasings4, 1)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    protected int getCurrentLayerOutputHatchCount() {
        return this.mOutputHatchesByLayer.size() < this.mHeight || this.mHeight <= 0 ? 0 : this.mOutputHatchesByLayer.get(this.mHeight - 1).size();
    }

    protected boolean addLayerOutputHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        MTEHatchOutput tHatch;
        IMetaTileEntity iMetaTileEntity;
        if (aTileEntity != null && !aTileEntity.isDead() && (iMetaTileEntity = aTileEntity.getMetaTileEntity()) instanceof MTEHatchOutput) {
            tHatch = (MTEHatchOutput)iMetaTileEntity;
        } else {
            return false;
        }
        while (this.mOutputHatchesByLayer.size() < this.mHeight) {
            this.mOutputHatchesByLayer.add(new ArrayList());
        }
        tHatch.updateTexture(aBaseCasingIndex);
        return this.mOutputHatchesByLayer.get(this.mHeight - 1).add(tHatch) && this.mOutputHatches.add(tHatch);
    }

    protected void onTopLayerFound() {
        this.mTopLayerFound = true;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Stats dictated by tower mode").addInfo("Right click the controller with screwdriver to change mode.").addSeparator().addInfo("Distillery Mode (requires full height tower)").addInfo(TooltipHelper.parallelText("8 * Voltage Tier") + " Parallels").addStaticSpeedInfo(2.0f).addStaticEuEffInfo(0.85f).addSeparator().addInfo("Distillation Tower Mode").addStaticParallelInfo(12).addStaticSpeedInfo(3.5f).addStaticEuEffInfo(1.0f).addPollutionAmount(this.getPollutionPerSecond(null)).beginVariableStructureBlock(3, 3, 3, 12, 3, 3, true).addController("Front bottom").addCasingInfoMin("Clean Stainless Steel Machine Casing", 7, false).addInputBus("Bottom Casing", 1).addOutputBus("Bottom Casing", 1).addInputHatch("Bottom Casing", 1).addMaintenanceHatch("Any Casing", 1).addEnergyHatch("Any Casing", 1).addOutputHatch("One per layer except bottom", 2).addMufflerHatch("Top Casing", 3).toolTipFinisher(new String[0]);
        return tt;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_BASE, stackSize, hintsOnly, 1, 0, 0);
        int tTotalHeight = GTStructureChannels.STRUCTURE_HEIGHT.getValueClamped(stackSize, 3, 12);
        for (int i = 1; i < tTotalHeight - 1; ++i) {
            this.buildPiece(STRUCTURE_PIECE_LAYER_HINT, stackSize, hintsOnly, 1, i, 0);
        }
        this.buildPiece(STRUCTURE_PIECE_TOP_HINT, stackSize, hintsOnly, 1, tTotalHeight - 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        this.mHeight = 0;
        int built = this.survivalBuildPiece(STRUCTURE_PIECE_BASE, stackSize, 1, 0, 0, elementBudget, env, false, true);
        if (built >= 0) {
            return built;
        }
        int tTotalHeight = GTStructureChannels.STRUCTURE_HEIGHT.getValueClamped(stackSize, 3, 12);
        for (int i = 1; i < tTotalHeight - 1; ++i) {
            this.mHeight = i;
            built = this.survivalBuildPiece(STRUCTURE_PIECE_LAYER_HINT, stackSize, 1, i, 0, elementBudget, env, false, true);
            if (built < 0) continue;
            return built;
        }
        this.mHeight = tTotalHeight - 1;
        return this.survivalBuildPiece(STRUCTURE_PIECE_TOP_HINT, stackSize, 1, tTotalHeight - 1, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        boolean check;
        this.mOutputHatchesByLayer.forEach(List::clear);
        this.mHeight = 1;
        this.mTopLayerFound = false;
        if (!this.checkPiece(STRUCTURE_PIECE_BASE, 1, 0, 0)) {
            return false;
        }
        while (this.mHeight < 12) {
            if (!this.checkPiece(STRUCTURE_PIECE_LAYER, 1, this.mHeight, 0)) {
                return false;
            }
            if (this.mOutputHatchesByLayer.size() < this.mHeight || this.mOutputHatchesByLayer.get(this.mHeight - 1).isEmpty()) {
                return false;
            }
            if (this.mTopLayerFound || !this.mMufflerHatches.isEmpty()) break;
            ++this.mHeight;
        }
        boolean bl = check = this.mTopLayerFound && this.mHeight >= 2 && this.checkHatch();
        if (check && this.mHeight < 11) {
            this.mMode = Mode.DistillationTower;
            this.mLastRecipe = null;
        }
        return check;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return this.mMode.getRecipeMap();
    }

    @Override
    @Nonnull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(RecipeMaps.distilleryRecipes, RecipeMaps.distillationTowerRecipes);
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        if (this.mMode == Mode.Distillery) {
            return PollutionConfig.pollutionPerSecondMultiAdvDistillationTower_ModeDistillery;
        }
        return PollutionConfig.pollutionPerSecondMultiAdvDistillationTower_ModeDT;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74774_a("mMode", (byte)this.mMode.ordinal());
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mMode = Mode.VALUES[aNBT.func_74771_c("mMode")];
        super.loadNBTData(aNBT);
    }

    @Override
    public void onModeChangeByScrewdriver(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.mHeight < 11) {
            GTUtility.sendChatToPlayer(aPlayer, "Cannot switch mode if not in full height.");
            return;
        }
        this.mMode = this.mMode.next();
        GTUtility.sendChatToPlayer(aPlayer, "Now running in " + (Object)((Object)this.mMode) + " Mode.");
        this.mLastRecipe = null;
    }

    @Override
    public boolean addOutput(FluidStack aLiquid) {
        if (aLiquid == null) {
            return false;
        }
        FluidStack copiedFluidStack = aLiquid.copy();
        for (List<MTEHatchOutput> hatches : this.mOutputHatchesByLayer) {
            if (!MTEAdvDistillationTower.dumpFluid(hatches, copiedFluidStack, true)) continue;
            return true;
        }
        for (List<MTEHatchOutput> hatches : this.mOutputHatchesByLayer) {
            if (!MTEAdvDistillationTower.dumpFluid(hatches, copiedFluidStack, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void addFluidOutputs(FluidStack[] outputFluids) {
        if (this.mMode == Mode.DistillationTower) {
            for (int i = 0; i < outputFluids.length && i < this.mOutputHatchesByLayer.size(); ++i) {
                FluidStack tStack = outputFluids[i].copy();
                if (MTEAdvDistillationTower.dumpFluid(this.mOutputHatchesByLayer.get(i), tStack, true)) continue;
                MTEAdvDistillationTower.dumpFluid(this.mOutputHatchesByLayer.get(i), tStack, false);
            }
        } else {
            for (FluidStack outputFluidStack : outputFluids) {
                this.addOutput(outputFluidStack);
            }
        }
    }

    @Override
    public List<? extends IFluidStore> getFluidOutputSlots(FluidStack[] toOutput) {
        return this.getFluidOutputSlotsByLayer(toOutput, this.mOutputHatchesByLayer);
    }

    @Override
    public String getMachineType() {
        return "Distillery, Distillation Tower";
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic().setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    protected void setupProcessingLogic(ProcessingLogic logic) {
        super.setupProcessingLogic(logic);
        logic.setEuModifier(this.mMode == Mode.Distillery ? (double)0.15f : 1.0);
        logic.setSpeedBonus(this.mMode == Mode.Distillery ? 0.5 : 0.2857142984867096);
    }

    @Override
    public int getMaxParallelRecipes() {
        int n;
        switch (this.mMode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DistillationTower: {
                n = 12;
                break;
            }
            case Distillery: {
                n = 8 * GTUtility.getTier(this.getMaxInputVoltage());
            }
        }
        return n;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE;
    }

    @Override
    protected IIconContainer getActiveGlowOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE_GLOW;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER;
    }

    @Override
    protected IIconContainer getInactiveGlowOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_GLOW;
    }

    @Override
    protected int getCasingTextureId() {
        return 49;
    }

    @Override
    public boolean canDumpFluidToME() {
        return this.mOutputHatchesByLayer.stream().allMatch(tLayerOutputHatches -> tLayerOutputHatches.stream().anyMatch(tHatch -> {
            MTEHatchOutputME tMEHatch;
            return tHatch instanceof MTEHatchOutputME && (tMEHatch = (MTEHatchOutputME)tHatch).canFillFluid();
        }));
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74778_a("mode", this.getMachineModeName());
    }

    @Override
    public String getMachineModeName() {
        return StatCollector.func_74838_a((String)("GT5U.GTPP_MULTI_ADV_DISTILLATION_TOWER.mode." + this.mMode.ordinal()));
    }

    private static enum Mode {
        DistillationTower(RecipeMaps.distillationTowerRecipes),
        Distillery(RecipeMaps.distilleryRecipes);

        static final Mode[] VALUES;
        private final RecipeMap<?> recipeMap;

        private Mode(RecipeMap<?> recipeMap) {
            this.recipeMap = recipeMap;
        }

        public RecipeMap<?> getRecipeMap() {
            return this.recipeMap;
        }

        public Mode next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        static {
            VALUES = Mode.values();
        }
    }
}

