/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.tooltip.TooltipHelper;
import gregtech.common.pollution.PollutionConfig;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEIndustrialArcFurnace
extends GTPPMultiBlockBase<MTEIndustrialArcFurnace>
implements ISurvivalConstructable {
    private static final int mCasingTextureID = TAE.getIndexFromPage(3, 3);
    public static String mCasingName = "Tempered Arc Furnace Casing";
    private boolean mPlasmaMode = false;
    private int mSize = 0;
    private int mCasing;
    private static IStructureDefinition<MTEIndustrialArcFurnace> STRUCTURE_DEFINITION = null;
    private static final String STRUCTURE_PIECE_FRONT = "front";
    private static final String STRUCTURE_PIECE_REST = "rest";
    private static final int MAX_TIER = 3;

    public MTEIndustrialArcFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEIndustrialArcFurnace(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEIndustrialArcFurnace(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Arc Furnace, Plasma Arc Furnace";
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo(TooltipHelper.parallelText("Width * Voltage Tier") + " Parallels").addInfo(TooltipHelper.parallelText("8x") + " Parallels in Plasma Mode").addStaticSpeedInfo(3.5f).addStaticEuEffInfo(1.0f).addInfo("Right-click controller with a Screwdriver to change modes").addInfo("Max Size required to process Plasma recipes").addPollutionAmount(this.getPollutionPerSecond(null)).addController("Top center").addStructureInfo("Size: nxnx3 [WxHxL] (Hollow)").addStructureInfo("n can be 3, 5 or 7").addCasingInfoMin(mCasingName, 10, false).addInputBus("Any Casing", 1).addOutputBus("Any Casing", 1).addInputHatch("Any Casing", 1).addOutputHatch("Any Casing", 1).addEnergyHatch("Any Casing", 1).addMaintenanceHatch("Any Casing", 1).addMufflerHatch("Any Casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IStructureDefinition<MTEIndustrialArcFurnace> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("front1", (String[][])new String[][]{{"CCC", "C~C", "CCC"}}).addShape("front2", (String[][])new String[][]{{"CCCCC", "C   C", "C   C", "C   C", "CCCCC"}}).addShape("front3", (String[][])new String[][]{{"CCCCCCC", "C     C", "C     C", "C     C", "C     C", "C     C", "CCCCCCC"}}).addShape("rest1", (String[][])new String[][]{{"CCC", "C-C", "CCC"}, {"CCC", "CCC", "CCC"}}).addShape("rest2", (String[][])new String[][]{{"CCCCC", "C---C", "C---C", "C---C", "CCCCC"}, {"CCCCC", "CCCCC", "CCCCC", "CCCCC", "CCCCC"}}).addShape("rest3", (String[][])new String[][]{{"CCCCCCC", "C-----C", "C-----C", "C-----C", "C-----C", "C-----C", "CCCCCCC"}, {"CCCCCCC", "CCCCCCC", "CCCCCCC", "CCCCCCC", "CCCCCCC", "CCCCCCC", "CCCCCCC"}}).addElement('C', GTStructureUtility.buildHatchAdder(MTEIndustrialArcFurnace.class).atLeast(HatchElement.InputBus, HatchElement.InputHatch, HatchElement.OutputBus, HatchElement.OutputHatch, HatchElement.Maintenance, HatchElement.Energy, HatchElement.Muffler).casingIndex(this.getCasingTextureIndex()).dot(1).allowOnly(ForgeDirection.NORTH).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings4Misc, (int)3)))).build();
        }
        return STRUCTURE_DEFINITION;
    }

    private int getTierFromHint(ItemStack stackSize) {
        if (stackSize.field_77994_a <= 0 || stackSize.field_77994_a >= 3) {
            return 3;
        }
        return stackSize.field_77994_a;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        int maxTier = this.getTierFromHint(stackSize);
        for (int tier = 1; tier <= maxTier; ++tier) {
            this.buildPiece(STRUCTURE_PIECE_FRONT + tier, stackSize, hintsOnly, tier, tier, 0);
        }
        this.buildPiece(STRUCTURE_PIECE_REST + maxTier, stackSize, hintsOnly, maxTier, maxTier, -1);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int maxTier = this.getTierFromHint(stackSize);
        for (int tier = 1; tier <= maxTier; ++tier) {
            int built = this.survivalBuildPiece(STRUCTURE_PIECE_FRONT + tier, stackSize, tier, tier, 0, elementBudget, env, false, true);
            if (built < 0) continue;
            return built;
        }
        return this.survivalBuildPiece(STRUCTURE_PIECE_REST + maxTier, stackSize, maxTier, maxTier, -1, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int tier;
        this.mCasing = 0;
        this.mSize = 0;
        for (tier = 0; tier < 3 && this.checkPiece(STRUCTURE_PIECE_FRONT + (tier + 1), tier + 1, tier + 1, 0); ++tier) {
        }
        if (tier <= 0) {
            return false;
        }
        if (this.checkPiece(STRUCTURE_PIECE_REST + tier, tier, tier, -1)) {
            this.mSize = 2 * tier + 1;
            return this.mCasing >= 10 && this.checkHatch();
        }
        return false;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.oMCDIndustrialArcFurnaceActive;
    }

    @Override
    protected IIconContainer getActiveGlowOverlay() {
        return TexturesGtBlock.oMCDIndustrialArcFurnaceActiveGlow;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.oMCDIndustrialArcFurnace;
    }

    @Override
    protected IIconContainer getInactiveGlowOverlay() {
        return TexturesGtBlock.oMCDIndustrialArcFurnaceGlow;
    }

    @Override
    protected int getCasingTextureId() {
        return mCasingTextureID;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return this.mPlasmaMode ? RecipeMaps.plasmaArcFurnaceRecipes : RecipeMaps.arcFurnaceRecipes;
    }

    @Override
    @Nonnull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(RecipeMaps.arcFurnaceRecipes, RecipeMaps.plasmaArcFurnaceRecipes);
    }

    @Override
    public int getRecipeCatalystPriority() {
        return -1;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic().setSpeedBonus(0.2857142984867096).setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    public int getMaxParallelRecipes() {
        return this.mSize * (this.mPlasmaMode ? 8 : 1) * GTUtility.getTier(this.getMaxInputVoltage());
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return PollutionConfig.pollutionPerSecondMultiIndustrialArcFurnace;
    }

    public Block getCasingBlock() {
        return ModBlocks.blockCasings4Misc;
    }

    public byte getCasingMeta() {
        return 3;
    }

    public byte getCasingTextureIndex() {
        return (byte)mCasingTextureID;
    }

    @Override
    public void onModeChangeByScrewdriver(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.mSize > 5) {
            boolean bl = this.mPlasmaMode = !this.mPlasmaMode;
            if (this.mPlasmaMode) {
                GTUtility.sendChatToPlayer(aPlayer, "[" + EnumChatFormatting.RED + "MODE" + EnumChatFormatting.RESET + "] " + EnumChatFormatting.LIGHT_PURPLE + "Plasma" + EnumChatFormatting.RESET);
            } else {
                GTUtility.sendChatToPlayer(aPlayer, "[" + EnumChatFormatting.RED + "MODE" + EnumChatFormatting.RESET + "] " + EnumChatFormatting.YELLOW + "Electric" + EnumChatFormatting.RESET);
            }
        } else {
            GTUtility.sendChatToPlayer(aPlayer, "[" + EnumChatFormatting.RED + "MODE" + EnumChatFormatting.RESET + "] " + EnumChatFormatting.GRAY + "Cannot change mode, structure not large enough." + EnumChatFormatting.RESET);
        }
        this.mLastRecipe = null;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("mPlasmaMode", this.mPlasmaMode);
        aNBT.func_74768_a("mSize", this.mSize);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mPlasmaMode = aNBT.func_74767_n("mPlasmaMode");
        this.mSize = aNBT.func_74762_e("mSize");
    }

    @Override
    public String getMachineModeName() {
        return StatCollector.func_74838_a((String)("GT5U.GTPP_MULTI_ARC_FURNACE.mode." + (this.mPlasmaMode ? 1 : 0)));
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74757_a("mode", this.mPlasmaMode);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_ARC_FURNACE_LOOP;
    }
}

