/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.generators;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicGenerator;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.common.pollution.Pollution;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ArrayUtils;
import tectech.util.TTUtility;

public class MTERTGenerator
extends MTEBasicGenerator {
    private long mTicksToBurnFor;
    private int mVoltage = 0;
    private GTRecipe mCurrentRecipe;
    private int mDaysRemaining = 0;
    private int mDayTick = 0;
    private byte mNewTier = 0;

    public int removeDayOfTime() {
        if (this.mDaysRemaining > 0) {
            return this.mDaysRemaining--;
        }
        return this.mDaysRemaining;
    }

    public static int convertDaysToTicks(float days) {
        return MathUtils.roundToClosestInt(1728000.0f * days);
    }

    public static long getTotalEUGenerated(int ticks, int voltage) {
        return (long)ticks * (long)voltage;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74772_a("mTicksToBurnFor", this.mTicksToBurnFor);
        aNBT.func_74768_a("mVoltage", this.mVoltage);
        aNBT.func_74768_a("mDaysRemaining", this.mDaysRemaining);
        aNBT.func_74768_a("mDayTick", this.mDayTick);
        aNBT.func_74774_a("mNewTier", this.mNewTier);
        if (this.mCurrentRecipe != null) {
            NBTTagList list = new NBTTagList();
            ItemStack stack = this.mCurrentRecipe.mInputs[0];
            if (stack != null) {
                NBTTagCompound data = new NBTTagCompound();
                stack.func_77955_b(data);
                data.func_74768_a("mSlot", 0);
                list.func_74742_a((NBTBase)data);
            }
            aNBT.func_74782_a("mRecipeItem", (NBTBase)list);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mTicksToBurnFor = aNBT.func_74763_f("mTicksToBurnFor");
        this.mVoltage = aNBT.func_74762_e("mVoltage");
        this.mDaysRemaining = aNBT.func_74762_e("mDaysRemaining");
        this.mDayTick = aNBT.func_74762_e("mDayTick");
        this.mNewTier = aNBT.func_74771_c("mNewTier");
        TTUtility.setTier(this.mNewTier, this);
        NBTTagList list = aNBT.func_150295_c("mRecipeItem", 10);
        NBTTagCompound data = list.func_150305_b(0);
        ItemStack lastUsedFuel = ItemStack.func_77949_a((NBTTagCompound)data);
        if (lastUsedFuel != null) {
            this.mCurrentRecipe = this.getRecipeMap().findRecipeQuery().items(lastUsedFuel).find();
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.mDayTick < 24000) {
                ++this.mDayTick;
            } else {
                this.mDayTick = 0;
                this.mDaysRemaining = this.removeDayOfTime();
            }
        }
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.isAllowedToWork() && aTick % 10L == 0L) {
            int tFuelValue;
            long tProducedEU = 0L;
            if (this.mFluid == null) {
                if (aBaseMetaTileEntity.getUniversalEnergyStored() < this.maxEUOutput() + this.getMinimumStoredEU()) {
                    this.mInventory[this.getStackDisplaySlot()] = null;
                } else {
                    if (this.mInventory[this.getStackDisplaySlot()] == null) {
                        this.mInventory[this.getStackDisplaySlot()] = new ItemStack((Block)Blocks.field_150480_ab, 1);
                    }
                    this.mInventory[this.getStackDisplaySlot()].func_151001_c("Generating: " + GTUtility.formatNumbers(aBaseMetaTileEntity.getUniversalEnergyStored() - this.getMinimumStoredEU()) + " EU");
                }
            } else {
                long tFluidAmountToUse;
                tFuelValue = this.getFuelValue(this.mFluid);
                int tConsumed = this.consumedFluidPerOperation(this.mFluid);
                if (tFuelValue > 0 && tConsumed > 0 && this.mFluid.amount > tConsumed && (tFluidAmountToUse = Math.min((long)(this.mFluid.amount / tConsumed), (this.maxEUStore() - aBaseMetaTileEntity.getUniversalEnergyStored()) / (long)tFuelValue)) > 0L && aBaseMetaTileEntity.increaseStoredEnergyUnits(tFluidAmountToUse * (long)tFuelValue, true)) {
                    tProducedEU = tFluidAmountToUse * (long)tFuelValue;
                    FluidStack tmp260_257 = this.mFluid;
                    tmp260_257.amount = (int)((long)tmp260_257.amount - tFluidAmountToUse * (long)tConsumed);
                }
            }
            if (this.mInventory[this.getInputSlot()] != null && aBaseMetaTileEntity.getUniversalEnergyStored() < this.maxEUOutput() * 20L + this.getMinimumStoredEU() && GTUtility.getFluidForFilledItem(this.mInventory[this.getInputSlot()], true) == null && (tFuelValue = this.getFuelValue(this.mInventory[this.getInputSlot()])) > 0) {
                ItemStack tEmptyContainer = this.getEmptyContainer(this.mInventory[this.getInputSlot()]);
                if (aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), tEmptyContainer)) {
                    aBaseMetaTileEntity.increaseStoredEnergyUnits(tFuelValue, true);
                    aBaseMetaTileEntity.func_70298_a(this.getInputSlot(), 1);
                    tProducedEU = tFuelValue;
                }
            }
            if (tProducedEU > 0L && this.getPollution() > 0) {
                Pollution.addPollution(aBaseMetaTileEntity, (int)(tProducedEU * (long)this.getPollution() / 500L * (long)this.mTier + 1L));
            }
        }
        if (aBaseMetaTileEntity.isServerSide()) {
            aBaseMetaTileEntity.setActive(aBaseMetaTileEntity.isAllowedToWork() && aBaseMetaTileEntity.getUniversalEnergyStored() >= this.maxEUOutput() + this.getMinimumStoredEU());
        }
    }

    @Override
    public String[] getDescription() {
        return (String[])ArrayUtils.addAll((Object[])this.mDescriptionArray, (Object[])new String[]{"Fuel is measured in minecraft days (Check with Scanner)", "RTG changes output voltage depending on fuel", "Generates power at " + GTUtility.formatNumbers(this.getEfficiency()) + "% Efficiency per tick", "Output Voltage: " + GTUtility.formatNumbers(this.getOutputTier()) + " EU/t", GTPPCore.GT_Tooltip.get()});
    }

    public MTERTGenerator(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, "Requires RTG Pellets", new ITexture[0]);
    }

    private byte getTier() {
        int voltage = this.mVoltage;
        if (voltage >= 512) {
            return 4;
        }
        if (voltage >= 128) {
            return 3;
        }
        if (voltage >= 32) {
            return 2;
        }
        if (voltage >= 8) {
            return 1;
        }
        return 0;
    }

    public MTERTGenerator(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return side.offsetY == 0 && side != this.getBaseMetaTileEntity().getFrontFacing() && side != this.getBaseMetaTileEntity().getBackFacing();
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTERTGenerator(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.rtgFuels;
    }

    @Override
    public int getCapacity() {
        return 0;
    }

    @Override
    public int getEfficiency() {
        return 100;
    }

    @Override
    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_RTG)};
    }

    @Override
    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_RTG)};
    }

    @Override
    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_RTG)};
    }

    @Override
    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_RTG)};
    }

    @Override
    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_RTG), Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI_2A[this.getTier()]};
    }

    @Override
    public ITexture[] getFrontActive(byte aColor) {
        return new ITexture[]{TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_RTG_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_RTG_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getBackActive(byte aColor) {
        return new ITexture[]{TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_RTG_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_RTG_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_RTG_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_RTG_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_RTG_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_RTG_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_RTG_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_RTG_ACTIVE_GLOW).glow().build(), Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI_2A[this.getTier()]};
    }

    @Override
    public int getPollution() {
        return 0;
    }

    @Override
    public int getFuelValue(ItemStack aStack) {
        if (GTUtility.isStackInvalid(aStack) || this.getRecipeMap() == null) {
            return 0;
        }
        GTRecipe tFuel = this.getRecipeMap().findRecipeQuery().items(aStack).find();
        if (tFuel != null) {
            int voltage;
            this.mCurrentRecipe = tFuel;
            this.mVoltage = voltage = tFuel.mEUt;
            try {
                int mTier2 = ItemStack.func_77989_b((ItemStack)tFuel.mInputs[0], (ItemStack)GregtechItemList.Pellet_RTG_AM241.get(1L, new Object[0])) ? 1 : (ItemStack.func_77989_b((ItemStack)tFuel.mInputs[0], (ItemStack)GregtechItemList.Pellet_RTG_PO210.get(1L, new Object[0])) ? 3 : (ItemStack.func_77989_b((ItemStack)tFuel.mInputs[0], (ItemStack)GregtechItemList.Pellet_RTG_PU238.get(1L, new Object[0])) ? 2 : (ItemStack.func_77989_b((ItemStack)tFuel.mInputs[0], (ItemStack)GregtechItemList.Pellet_RTG_SR90.get(1L, new Object[0])) ? 1 : 0)));
                TTUtility.setTier(mTier2, this);
                this.mNewTier = (byte)mTier2;
            }
            catch (Exception e) {
                Logger.WARNING("Failed setting mTier.");
                e.printStackTrace();
            }
            this.mTicksToBurnFor = MTERTGenerator.getTotalEUGenerated(MTERTGenerator.convertDaysToTicks(tFuel.mSpecialValue), voltage);
            if (this.mTicksToBurnFor >= Integer.MAX_VALUE) {
                this.mTicksToBurnFor = Integer.MAX_VALUE;
                Logger.WARNING("Fuel went over Int limit, setting to MAX_VALUE.");
            }
            this.mDaysRemaining = MathUtils.roundToClosestInt(this.mTicksToBurnFor / 20L / 60L / 3L);
            Logger.WARNING("step | " + (int)(this.mTicksToBurnFor * (long)this.getEfficiency() / 100L));
            return (int)(this.mTicksToBurnFor * (long)this.getEfficiency() / 100L);
        }
        Logger.WARNING("Not sure");
        return 0;
    }

    @Override
    public long maxEUOutput() {
        return this.getBaseMetaTileEntity().isAllowedToWork() ? (long)this.mVoltage : 0L;
    }

    @Override
    public long getOutputTier() {
        if (this.mCurrentRecipe != null) {
            this.mVoltage = this.mCurrentRecipe.mEUt;
            return this.mVoltage;
        }
        return 0L;
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        return new String[]{StatCollector.func_74837_a((String)"gtpp.infodata.rtg.running_at", (Object[])new Object[]{this.mTier}), StatCollector.func_74837_a((String)"gtpp.infodata.rtg.active", (Object[])new Object[]{this.getBaseMetaTileEntity().isActive()}), StatCollector.func_74837_a((String)"gtpp.infodata.rtg.output", (Object[])new Object[]{GTUtility.formatNumbers(this.mVoltage)}), StatCollector.func_74837_a((String)"gtpp.infodata.rtg.remaining.days", (Object[])new Object[]{GTUtility.formatNumbers(this.mTicksToBurnFor / 20L / 60L / 20L)}), StatCollector.func_74837_a((String)"gtpp.infodata.rtg.remaining.hours", (Object[])new Object[]{GTUtility.formatNumbers(this.mTicksToBurnFor / 20L / 60L / 60L)}), StatCollector.func_74837_a((String)"gtpp.infodata.rtg.remaining.ticks", (Object[])new Object[]{this.mVoltage, this.mTicksToBurnFor}), this.mCurrentRecipe.mInputs[0].func_82833_r() + " x1"};
    }
}

