/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import com.cricketcraft.chisel.api.IFacade;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.covers.CoverRegistry;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IDebugableBlock;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IColoredTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IDebugableTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GTGenericBlock;
import gregtech.api.items.MetaBaseItem;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.BaseTileEntity;
import gregtech.api.metatileentity.CoverableTileEntity;
import gregtech.api.objects.GTItemStack;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GTBaseCrop;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.ItemMachines;
import gregtech.common.blocks.MaterialMachines;
import gregtech.common.covers.Cover;
import gregtech.common.render.GTRendererBlock;
import gregtech.common.tileentities.storage.MTEQuantumChest;
import gtPlusPlus.xmod.gregtech.common.tileentities.redstone.MTERedstoneBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="com.cricketcraft.chisel.api.IFacade", modid="ChiselAPI")
public class BlockMachines
extends GTGenericBlock
implements IDebugableBlock,
ITileEntityProvider,
IFacade {
    private static final ThreadLocal<IGregTechTileEntity> mTemporaryTileEntity = new ThreadLocal();
    private boolean renderAsNormalBlock;

    public BlockMachines() {
        this(ItemMachines.class, "gt.blockmachines", new MaterialMachines());
    }

    protected BlockMachines(Class<? extends ItemBlock> aItemClass, String aName, Material aMaterial) {
        super(aItemClass, aName, aMaterial);
        GregTechAPI.registerMachineBlock((Block)this, -1);
        this.func_149711_c(1.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(field_149777_j);
        this.func_149647_a(GregTechAPI.TAB_GREGTECH);
        this.field_149758_A = true;
        this.renderAsNormalBlock = true;
        this.field_149783_u = true;
    }

    public String getHarvestTool(int aMeta) {
        if (aMeta >= 8 && aMeta <= 11) {
            return "cutter";
        }
        return "wrench";
    }

    public int getHarvestLevel(int aMeta) {
        return aMeta % 4;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public void onNeighborChange(IBlockAccess aWorld, int aX, int aY, int aZ, int aTileX, int aTileY, int aTileZ) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof BaseTileEntity) {
            ((BaseTileEntity)tTileEntity).onAdjacentBlockChange(aTileX, aTileY, aTileZ);
        }
    }

    public void func_149695_a(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof BaseMetaPipeEntity) {
            ((BaseMetaPipeEntity)tTileEntity).onNeighborBlockChange(aX, aY, aZ);
        }
    }

    public void func_149726_b(World aWorld, int aX, int aY, int aZ) {
        super.func_149726_b(aWorld, aX, aY, aZ);
        if (GregTechAPI.isMachineBlock(this, aWorld.func_72805_g(aX, aY, aZ))) {
            GregTechAPI.causeMachineUpdate(aWorld, aX, aY, aZ);
        }
    }

    public String func_149739_a() {
        return "gt.blockmachines";
    }

    public String func_149732_F() {
        return StatCollector.func_74838_a((String)(this.func_149739_a() + ".name"));
    }

    public int getFlammability(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection face) {
        return 0;
    }

    public int getFireSpreadSpeed(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection face) {
        return GregTechAPI.sMachineFlammable && aWorld.func_72805_g(aX, aY, aZ) == 0 ? 100 : 0;
    }

    public int func_149645_b() {
        return GTRendererBlock.RENDER_ID;
    }

    public boolean isFireSource(World aWorld, int aX, int aY, int aZ, ForgeDirection side) {
        return GregTechAPI.sMachineFlammable && aWorld.func_72805_g(aX, aY, aZ) == 0;
    }

    public boolean isFlammable(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection face) {
        return GregTechAPI.sMachineFlammable && aWorld.func_72805_g(aX, aY, aZ) == 0;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    public boolean canConnectRedstone(IBlockAccess aWorld, int aX, int aY, int aZ, int ordinalSide) {
        BaseMetaTileEntity bmte;
        ForgeDirection forgeDirection;
        switch (ordinalSide) {
            case -2: {
                forgeDirection = ForgeDirection.DOWN;
                break;
            }
            case -1: {
                forgeDirection = ForgeDirection.UP;
                break;
            }
            case 0: {
                forgeDirection = ForgeDirection.NORTH;
                break;
            }
            case 2: {
                forgeDirection = ForgeDirection.SOUTH;
                break;
            }
            case 3: {
                forgeDirection = ForgeDirection.WEST;
                break;
            }
            case 1: {
                forgeDirection = ForgeDirection.EAST;
                break;
            }
            default: {
                forgeDirection = ForgeDirection.UNKNOWN;
            }
        }
        ForgeDirection forgeSide = forgeDirection;
        TileEntity machineEntity = aWorld.func_147438_o(aX, aY, aZ);
        return machineEntity instanceof BaseMetaTileEntity && ((bmte = (BaseMetaTileEntity)machineEntity).hasCoverAtSide(forgeSide) || bmte.getMetaTileEntity() instanceof MTERedstoneBase);
    }

    public boolean canRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    public boolean isNormalCube(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    public boolean hasTileEntity(int aMeta) {
        return true;
    }

    public boolean func_149740_M() {
        return true;
    }

    public boolean func_149686_d() {
        return this.renderAsNormalBlock;
    }

    public BlockMachines setRenderAsNormalBlock(boolean aBool) {
        this.renderAsNormalBlock = aBool;
        return this;
    }

    public boolean func_149744_f() {
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public TileEntity func_149915_a(World aWorld, int aMeta) {
        return this.createTileEntity(aWorld, aMeta);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess aIBlockAccess, int aX, int aY, int aZ, int ordinalSide) {
        return Textures.BlockIcons.MACHINE_LV_SIDE.getIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int ordinalSide, int aMeta) {
        return Textures.BlockIcons.MACHINE_LV_SIDE.getIcon();
    }

    public boolean func_149696_a(World aWorld, int aX, int aY, int aZ, int aData1, int aData2) {
        super.func_149696_a(aWorld, aX, aY, aZ, aData1, aData2);
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return tTileEntity != null && tTileEntity.func_145842_c(aData1, aData2);
    }

    public void func_149743_a(World aWorld, int aX, int aY, int aZ, AxisAlignedBB inputAABB, List<AxisAlignedBB> outputAABB, Entity collider) {
        IGregTechTileEntity gtTE;
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity && (gtTE = (IGregTechTileEntity)tTileEntity).canAccessData()) {
            gtTE.getMetaTileEntity().addCollisionBoxesToList(aWorld, aX, aY, aZ, inputAABB, outputAABB, collider);
            return;
        }
        super.func_149743_a(aWorld, aX, aY, aZ, inputAABB, outputAABB, collider);
    }

    public AxisAlignedBB func_149668_a(World aWorld, int aX, int aY, int aZ) {
        IGregTechTileEntity gtTE;
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity && (gtTE = (IGregTechTileEntity)tTileEntity).canAccessData()) {
            return gtTE.getMetaTileEntity().getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ);
        }
        return super.func_149668_a(aWorld, aX, aY, aZ);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World aWorld, int aX, int aY, int aZ) {
        IGregTechTileEntity gtTE;
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity && (gtTE = (IGregTechTileEntity)tTileEntity).canAccessData()) {
            return gtTE.getMetaTileEntity().getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ);
        }
        return super.func_149633_g(aWorld, aX, aY, aZ);
    }

    public void func_149719_a(IBlockAccess blockAccess, int aX, int aY, int aZ) {
        IGregTechTileEntity gtTE;
        TileEntity tTileEntity = blockAccess.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity && (gtTE = (IGregTechTileEntity)tTileEntity).canAccessData()) {
            AxisAlignedBB bbb = gtTE.getMetaTileEntity().getCollisionBoundingBoxFromPool(gtTE.getWorld(), 0, 0, 0);
            this.field_149759_B = bbb.field_72340_a;
            this.field_149760_C = bbb.field_72338_b;
            this.field_149754_D = bbb.field_72339_c;
            this.field_149755_E = bbb.field_72336_d;
            this.field_149756_F = bbb.field_72337_e;
            this.field_149757_G = bbb.field_72334_f;
            return;
        }
        super.func_149719_a(blockAccess, aX, aY, aZ);
    }

    public void func_149683_g() {
        super.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void func_149670_a(World aWorld, int aX, int aY, int aZ, Entity collider) {
        IGregTechTileEntity gtTE;
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity && (gtTE = (IGregTechTileEntity)tTileEntity).canAccessData()) {
            gtTE.getMetaTileEntity().onEntityCollidedWithBlock(aWorld, aX, aY, aZ, collider);
            return;
        }
        super.func_149670_a(aWorld, aX, aY, aZ, collider);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister aIconRegister) {
        if (!GregTechAPI.sPostloadFinished) {
            return;
        }
        GTLog.out.println("GTMod: Setting up Icon Register for Blocks");
        GregTechAPI.setBlockIconRegister(aIconRegister);
        GTLog.out.println("GTMod: Registering MetaTileEntity specific Textures");
        try {
            for (int i = 1; i < GregTechAPI.METATILEENTITIES.length; ++i) {
                if (GregTechAPI.METATILEENTITIES[i] == null) continue;
                GregTechAPI.METATILEENTITIES[i].registerIcons(aIconRegister);
            }
        }
        catch (Exception e) {
            e.printStackTrace(GTLog.err);
        }
        GTLog.out.println("GTMod: Registering Crop specific Textures");
        try {
            for (GTBaseCrop tCrop : GTBaseCrop.sCropList) {
                tCrop.registerSprites(aIconRegister);
            }
        }
        catch (Exception e) {
            e.printStackTrace(GTLog.err);
        }
        GTLog.out.println("GTMod: Starting Block Icon Load Phase");
        GTMod.GT_FML_LOGGER.info("GTMod: Starting Block Icon Load Phase");
        try {
            for (Runnable tRunnable : GregTechAPI.sGTBlockIconload) {
                tRunnable.run();
            }
        }
        catch (Exception e) {
            e.printStackTrace(GTLog.err);
        }
        GTLog.out.println("GTMod: Finished Block Icon Load Phase");
        GTMod.GT_FML_LOGGER.info("GTMod: Finished Block Icon Load Phase");
    }

    public float func_149737_a(EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return tTileEntity instanceof BaseMetaTileEntity && ((BaseMetaTileEntity)tTileEntity).privateAccess() && !((BaseMetaTileEntity)tTileEntity).playerOwnsThis(aPlayer, true) ? -1.0f : super.func_149737_a(aPlayer, aWorld, aX, aY, aZ);
    }

    public boolean func_149727_a(World aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer, int ordinalSide, float aOffsetX, float aOffsetY, float aOffsetZ) {
        MetaBaseItem mbItem;
        Item item;
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity == null) {
            return false;
        }
        ItemStack tCurrentItem = aPlayer.field_71071_by.func_70448_g();
        if (!(!aPlayer.func_70093_af() || tCurrentItem == null || GTUtility.isStackInList(tCurrentItem, (Collection<GTItemStack>)GregTechAPI.sScrewdriverList) || GTUtility.isStackInList(tCurrentItem, (Collection<GTItemStack>)GregTechAPI.sWrenchList) || GTUtility.isStackInList(tCurrentItem, (Collection<GTItemStack>)GregTechAPI.sWireCutterList) || GTUtility.isStackInList(tCurrentItem, (Collection<GTItemStack>)GregTechAPI.sSolderingToolList) || GTUtility.isStackInList(tCurrentItem, (Collection<GTItemStack>)GregTechAPI.sJackhammerList) || GTUtility.isStackInList(tCurrentItem, (Collection<GTItemStack>)GregTechAPI.sHardHammerList) || CoverRegistry.isCover(tCurrentItem))) {
            return false;
        }
        ForgeDirection side = ForgeDirection.getOrientation((int)ordinalSide);
        if (tCurrentItem != null && (item = tCurrentItem.func_77973_b()) instanceof MetaBaseItem && (mbItem = (MetaBaseItem)item).forEachBehavior(tCurrentItem, behavior -> behavior.shouldInterruptBlockActivation(aPlayer, tTileEntity, side))) {
            return false;
        }
        if (tTileEntity instanceof IGregTechTileEntity) {
            IGregTechTileEntity gtTE = (IGregTechTileEntity)tTileEntity;
            if (gtTE.getTimer() < 1L) {
                return false;
            }
            if (!aWorld.field_72995_K && !gtTE.func_70300_a(aPlayer)) {
                return true;
            }
            return gtTE.onRightclick(aPlayer, side, aOffsetX, aOffsetY, aOffsetZ);
        }
        return false;
    }

    public void func_149699_a(World aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            IGregTechTileEntity gtTE = (IGregTechTileEntity)tTileEntity;
            gtTE.onLeftclick(aPlayer);
        }
    }

    public int func_149643_k(World aWorld, int aX, int aY, int aZ) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            IGregTechTileEntity gtTE = (IGregTechTileEntity)tTileEntity;
            return gtTE.getMetaTileID();
        }
        return 0;
    }

    public void onBlockExploded(World aWorld, int aX, int aY, int aZ, Explosion aExplosion) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof BaseMetaTileEntity) {
            BaseMetaTileEntity baseTE = (BaseMetaTileEntity)tTileEntity;
            GTLog.exp.printf("Explosion at : %d | %d | %d DIMID: %s due to near explosion!%n", aX, aY, aZ, aWorld.field_73011_w.field_76574_g);
            baseTE.doEnergyExplosion();
        }
        super.onBlockExploded(aWorld, aX, aY, aZ, aExplosion);
    }

    public void func_149749_a(World aWorld, int aX, int aY, int aZ, Block aBlock, int aMetadata) {
        IGregTechTileEntity gtTE;
        GregTechAPI.causeMachineUpdate(aWorld, aX, aY, aZ);
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity && (gtTE = (IGregTechTileEntity)tTileEntity).canAccessData()) {
            IMetaTileEntity mte = gtTE.getMetaTileEntity();
            mte.onBlockDestroyed();
            mTemporaryTileEntity.set(gtTE);
            if (!(mte instanceof MTEQuantumChest)) {
                for (int i = 0; i < gtTE.func_70302_i_(); ++i) {
                    ItemStack tItem = gtTE.func_70301_a(i);
                    if (tItem == null || tItem.field_77994_a <= 0 || !gtTE.isValidSlot(i) || !mte.shouldDropItemAt(i)) continue;
                    EntityItem tItemEntity = new EntityItem(aWorld, (double)((float)aX + XSTR.XSTR_INSTANCE.nextFloat() * 0.8f + 0.1f), (double)((float)aY + XSTR.XSTR_INSTANCE.nextFloat() * 0.8f + 0.1f), (double)((float)aZ + XSTR.XSTR_INSTANCE.nextFloat() * 0.8f + 0.1f), new ItemStack(tItem.func_77973_b(), tItem.field_77994_a, tItem.func_77960_j()));
                    if (tItem.func_77942_o()) {
                        tItemEntity.func_92059_d().func_77982_d((NBTTagCompound)tItem.func_77978_p().func_74737_b());
                    }
                    tItemEntity.field_70159_w = XSTR.XSTR_INSTANCE.nextGaussian() * 0.05;
                    tItemEntity.field_70181_x = XSTR.XSTR_INSTANCE.nextGaussian() * 0.25;
                    tItemEntity.field_70179_y = XSTR.XSTR_INSTANCE.nextGaussian() * 0.05;
                    aWorld.func_72838_d((Entity)tItemEntity);
                    tItem.field_77994_a = 0;
                    gtTE.func_70299_a(i, null);
                }
            }
        }
        super.func_149749_a(aWorld, aX, aY, aZ, aBlock, aMetadata);
        aWorld.func_147475_p(aX, aY, aZ);
    }

    public ArrayList<ItemStack> getDrops(World aWorld, int aX, int aY, int aZ, int aMeta, int aFortune) {
        ArrayList<Object> tDrops;
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            IGregTechTileEntity gtTE = (IGregTechTileEntity)tTileEntity;
            IMetaTileEntity gtMTE = gtTE.getMetaTileEntity();
            if (gtMTE != null && gtMTE.getDroppedItem() != null) {
                return gtMTE.getDroppedItem();
            }
            return gtTE.getDrops();
        }
        IGregTechTileEntity tGregTechTileEntity = mTemporaryTileEntity.get();
        if (tGregTechTileEntity == null) {
            tDrops = new ArrayList();
        } else {
            tDrops = tGregTechTileEntity.getDrops();
            mTemporaryTileEntity.remove();
        }
        return tDrops;
    }

    public boolean removedByPlayer(World aWorld, EntityPlayer aPlayer, int aX, int aY, int aZ, boolean aWillHarvest) {
        return aWillHarvest || super.removedByPlayer(aWorld, aPlayer, aX, aY, aZ, false);
    }

    public void func_149636_a(World aWorld, EntityPlayer aPlayer, int aX, int aY, int aZ, int aMeta) {
        super.func_149636_a(aWorld, aPlayer, aX, aY, aZ, aMeta);
        aWorld.func_147468_f(aX, aY, aZ);
    }

    public int func_149736_g(World aWorld, int aX, int aY, int aZ, int ordinalSide) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            IGregTechTileEntity gtTE = (IGregTechTileEntity)tTileEntity;
            return gtTE.getComparatorValue(ForgeDirection.getOrientation((int)ordinalSide));
        }
        return 0;
    }

    public int func_149709_b(IBlockAccess aWorld, int aX, int aY, int aZ, int ordinalSide) {
        if (ordinalSide < 0 || ordinalSide > 5) {
            return 0;
        }
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            IGregTechTileEntity gtTE = (IGregTechTileEntity)tTileEntity;
            return gtTE.getOutputRedstoneSignal(ForgeDirection.getOrientation((int)ordinalSide).getOpposite());
        }
        return 0;
    }

    public int func_149748_c(IBlockAccess aWorld, int aX, int aY, int aZ, int ordinalSide) {
        if (ordinalSide < 0 || ordinalSide > 5) {
            return 0;
        }
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            IGregTechTileEntity gtTE = (IGregTechTileEntity)tTileEntity;
            return gtTE.getStrongOutputRedstoneSignal(ForgeDirection.getOrientation((int)ordinalSide).getOpposite());
        }
        return 0;
    }

    public void func_149690_a(World aWorld, int aX, int aY, int aZ, int aMetadata, float chance, int aFortune) {
        if (!aWorld.field_72995_K) {
            TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
            if (tTileEntity != null && chance < 1.0f) {
                if (tTileEntity instanceof BaseMetaTileEntity) {
                    BaseMetaTileEntity bmte = (BaseMetaTileEntity)tTileEntity;
                    if (GregTechAPI.sMachineNonWrenchExplosions) {
                        GTLog.exp.printf("Explosion at : %d | %d | %d DIMID: %s NonWrench picking/Rain!%n", aX, aY, aZ, aWorld.field_73011_w.field_76574_g);
                        bmte.doEnergyExplosion();
                    }
                }
            } else {
                super.func_149690_a(aWorld, aX, aY, aZ, aMetadata, chance, aFortune);
            }
        }
    }

    public boolean isSideSolid(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection side) {
        if (aWorld.func_72805_g(aX, aY, aZ) == 0) {
            return true;
        }
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity != null) {
            if (tTileEntity instanceof BaseMetaTileEntity) {
                return true;
            }
            if (tTileEntity instanceof BaseMetaPipeEntity && (((BaseMetaPipeEntity)tTileEntity).mConnections & 0xFFFFFFC0) != 0) {
                return true;
            }
            return tTileEntity instanceof ICoverable && ((ICoverable)tTileEntity).hasCoverAtSide(side);
        }
        return false;
    }

    public boolean func_149637_q() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_149685_I() {
        return this.func_149686_d() ? 0.2f : 0.5f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        IGregTechTileEntity gtTE;
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity && (gtTE = (IGregTechTileEntity)tTileEntity).canAccessData()) {
            gtTE.getMetaTileEntity().onRandomDisplayTick(gtTE);
        }
    }

    public int getLightOpacity(IBlockAccess aWorld, int aX, int aY, int aZ) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            return ((IGregTechTileEntity)tTileEntity).getLightOpacity();
        }
        return aWorld.func_72805_g(aX, aY, aZ) == 0 ? 255 : 0;
    }

    public int getLightValue(IBlockAccess aWorld, int aX, int aY, int aZ) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof BaseMetaTileEntity) {
            return ((BaseMetaTileEntity)tTileEntity).getLightValue();
        }
        return 0;
    }

    public TileEntity createTileEntity(World aWorld, int aMeta) {
        return GregTechAPI.createTileEntity(aMeta);
    }

    public float getExplosionResistance(Entity entity, World aWorld, int aX, int aY, int aZ, double explosionX, double explosionY, double explosionZ) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        IMetaTileEntity mte = GTUtility.getMetaTileEntity(tTileEntity);
        if (mte != null) {
            return mte.getExplosionResistance(ForgeDirection.UNKNOWN);
        }
        return 10.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs aCreativeTab, List<ItemStack> outputSubBlocks) {
        for (int i = 1; i < GregTechAPI.METATILEENTITIES.length; ++i) {
            if (GregTechAPI.METATILEENTITIES[i] == null) continue;
            outputSubBlocks.add(new ItemStack(item, 1, i));
        }
    }

    public void func_149689_a(World aWorld, int aX, int aY, int aZ, EntityLivingBase aPlayer, ItemStack aStack) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (!(tTileEntity instanceof IGregTechTileEntity)) {
            return;
        }
        IGregTechTileEntity iGregTechTileEntity = (IGregTechTileEntity)tTileEntity;
        iGregTechTileEntity.setFrontFacing(BaseTileEntity.getSideForPlayerPlacing((Entity)aPlayer, ForgeDirection.UP, iGregTechTileEntity.getValidFacings()));
    }

    @Override
    public ArrayList<String> getDebugInfo(EntityPlayer aPlayer, int aX, int aY, int aZ, int aLogLevel) {
        TileEntity tTileEntity = aPlayer.field_70170_p.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IDebugableTileEntity) {
            return ((IDebugableTileEntity)tTileEntity).getDebugInfo(aPlayer, aLogLevel);
        }
        return new ArrayList<String>();
    }

    public boolean recolourBlock(World aWorld, int aX, int aY, int aZ, ForgeDirection side, int aColor) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IColoredTileEntity) {
            IColoredTileEntity coloredTE = (IColoredTileEntity)tTileEntity;
            if (coloredTE.getColorization() == (byte)(~aColor & 0xF)) {
                return false;
            }
            coloredTE.setColorization((byte)(~aColor & 0xF));
            return true;
        }
        return false;
    }

    public Block getFacade(IBlockAccess aWorld, int aX, int aY, int aZ, int ordinalSide) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof CoverableTileEntity) {
            CoverableTileEntity tile = (CoverableTileEntity)tTileEntity;
            ForgeDirection dir = ForgeDirection.getOrientation((int)ordinalSide);
            if (dir != ForgeDirection.UNKNOWN) {
                Block facadeBlock = tile.getCoverAtSide(dir).getFacadeBlock();
                if (facadeBlock != null) {
                    return facadeBlock;
                }
            } else {
                for (ForgeDirection tSide : ForgeDirection.VALID_DIRECTIONS) {
                    Block facadeBlock = tile.getCoverAtSide(tSide).getFacadeBlock();
                    if (facadeBlock == null) continue;
                    return facadeBlock;
                }
            }
        }
        return Blocks.field_150350_a;
    }

    public int getFacadeMetadata(IBlockAccess aWorld, int aX, int aY, int aZ, int ordinalSide) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof CoverableTileEntity) {
            CoverableTileEntity tile = (CoverableTileEntity)tTileEntity;
            ForgeDirection dir = ForgeDirection.getOrientation((int)ordinalSide);
            if (ordinalSide != -1) {
                Cover cover = tile.getCoverAtSide(dir);
                Block facadeBlock = cover.getFacadeBlock();
                if (facadeBlock != null) {
                    return cover.getFacadeMeta();
                }
            } else {
                for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                    Cover cover = tile.getCoverAtSide(d);
                    Block facadeBlock = cover.getFacadeBlock();
                    if (facadeBlock == null) continue;
                    return cover.getFacadeMeta();
                }
            }
        }
        return 0;
    }
}

