/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.interfaces;

import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.util.IGTHatchAdder;
import java.util.List;
import java.util.function.ToLongFunction;

class HatchElement<T>
implements IHatchElement<T> {
    private final List<Class<? extends IMetaTileEntity>> mClasses;
    private final IGTHatchAdder<? super T> mAdder;
    private final String mName;
    private final String mDisplayName;
    private final IHatchElement<? super T> mBacking;
    private final ToLongFunction<? super T> mCount;

    public HatchElement(List<Class<? extends IMetaTileEntity>> aMteClasses, IGTHatchAdder<? super T> aAdder, String aName, String aDisplayName, ToLongFunction<? super T> aCount, IHatchElement<? super T> aBacking) {
        this.mClasses = aMteClasses;
        this.mAdder = aAdder;
        this.mName = aName;
        this.mDisplayName = aDisplayName;
        this.mCount = aCount;
        this.mBacking = aBacking;
    }

    @Override
    public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
        return this.mClasses == null ? this.mBacking.mteClasses() : this.mClasses;
    }

    @Override
    public IGTHatchAdder<? super T> adder() {
        return this.mAdder == null ? this.mBacking.adder() : this.mAdder;
    }

    @Override
    public String name() {
        return this.mName == null ? this.mBacking.name() : this.mName;
    }

    @Override
    public String getDisplayName() {
        return this.mDisplayName == null ? this.mBacking.getDisplayName() : this.mDisplayName;
    }

    @Override
    public long count(T t) {
        return this.mCount == null ? this.mBacking.count(t) : this.mCount.applyAsLong(t);
    }

    @Override
    public <T2 extends T> IHatchElement<T2> withMteClasses(List<Class<? extends IMetaTileEntity>> aClasses) {
        if (aClasses == null) {
            throw new IllegalArgumentException();
        }
        return new HatchElement<T>(aClasses, this.mAdder, this.mName, this.mDisplayName, this.mCount, this.mBacking);
    }

    @Override
    public <T2 extends T> IHatchElement<T2> withAdder(IGTHatchAdder<T2> aAdder) {
        if (aAdder == null) {
            throw new IllegalArgumentException();
        }
        return new HatchElement<T>(this.mClasses, aAdder, this.mName, this.mDisplayName, this.mCount, this.mBacking);
    }

    @Override
    public IHatchElement<T> withName(String aName) {
        if (aName == null) {
            throw new IllegalArgumentException();
        }
        return new HatchElement<T>(this.mClasses, this.mAdder, aName, this.mDisplayName, this.mCount, this.mBacking);
    }

    @Override
    public IHatchElement<T> withDisplayName(String aDisplayName) {
        if (aDisplayName == null) {
            throw new IllegalArgumentException();
        }
        return new HatchElement<T>(this.mClasses, this.mAdder, this.mName, aDisplayName, this.mCount, this.mBacking);
    }

    @Override
    public <T2 extends T> IHatchElement<T2> withCount(ToLongFunction<T2> aCount) {
        if (aCount == null) {
            throw new IllegalArgumentException();
        }
        return new HatchElement<T>(this.mClasses, this.mAdder, this.mName, this.mDisplayName, aCount, this.mBacking);
    }
}

