/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.api;

import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.api.mappings.RegistryMapping;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.core.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class StrippedLogRegistry {
    private static final Map<RegistryMapping<Block>, RegistryMapping<Block>> strippedLogs = new HashMap<RegistryMapping<Block>, RegistryMapping<Block>>();

    public static void addLog(Block from, int fromMeta, Block to, int toMeta) {
        StrippedLogRegistry.addLog(new RegistryMapping<Block>(from, fromMeta & 3), new RegistryMapping<Block>(to, toMeta & 3));
    }

    private static void addLog(RegistryMapping<Block> from, RegistryMapping<Block> to) {
        if (!Utils.isMetaInBlockBoundsIgnoreWildcard(from.getMeta()) || !Utils.isMetaInBlockBoundsIgnoreWildcard(to.getMeta())) {
            throw new IllegalArgumentException("Meta must be between " + Utils.getMinMetadata() + " and " + Utils.getMaxMetadata() + " (inclusive).");
        }
        strippedLogs.put(from, to);
    }

    public static boolean hasLog(Block block, int meta) {
        return StrippedLogRegistry.hasLog(RegistryMapping.getKeyFor(block, meta & 3));
    }

    private static boolean hasLog(RegistryMapping<Block> map) {
        return strippedLogs.containsKey(map);
    }

    public static RegistryMapping<Block> getLog(Block block, int meta) {
        return StrippedLogRegistry.getLog(RegistryMapping.getKeyFor(block, meta & 3));
    }

    private static RegistryMapping<Block> getLog(RegistryMapping<Block> map) {
        return strippedLogs.get(map);
    }

    public static Map<RegistryMapping<Block>, RegistryMapping<Block>> getLogMap() {
        return strippedLogs;
    }

    public static void init() {
        if (ModBlocks.LOG_STRIPPED.isEnabled()) {
            StrippedLogRegistry.addLog(Blocks.field_150364_r, 0, ModBlocks.LOG_STRIPPED.get(), 0);
            StrippedLogRegistry.addLog(Blocks.field_150364_r, 1, ModBlocks.LOG_STRIPPED.get(), 1);
            StrippedLogRegistry.addLog(Blocks.field_150364_r, 2, ModBlocks.LOG_STRIPPED.get(), 2);
            StrippedLogRegistry.addLog(Blocks.field_150364_r, 3, ModBlocks.LOG_STRIPPED.get(), 3);
        }
        if (ModBlocks.LOG2_STRIPPED.isEnabled()) {
            StrippedLogRegistry.addLog(Blocks.field_150363_s, 0, ModBlocks.LOG2_STRIPPED.get(), 0);
            StrippedLogRegistry.addLog(Blocks.field_150363_s, 1, ModBlocks.LOG2_STRIPPED.get(), 1);
        }
        if (ModBlocks.BARK.isEnabled() && ModBlocks.WOOD_STRIPPED.isEnabled()) {
            StrippedLogRegistry.addLog(ModBlocks.BARK.get(), 0, ModBlocks.WOOD_STRIPPED.get(), 0);
            StrippedLogRegistry.addLog(ModBlocks.BARK.get(), 1, ModBlocks.WOOD_STRIPPED.get(), 1);
            StrippedLogRegistry.addLog(ModBlocks.BARK.get(), 2, ModBlocks.WOOD_STRIPPED.get(), 2);
            StrippedLogRegistry.addLog(ModBlocks.BARK.get(), 3, ModBlocks.WOOD_STRIPPED.get(), 3);
        }
        if (ModBlocks.BARK2.isEnabled() && ModBlocks.WOOD2_STRIPPED.isEnabled()) {
            StrippedLogRegistry.addLog(ModBlocks.BARK2.get(), 0, ModBlocks.WOOD2_STRIPPED.get(), 0);
            StrippedLogRegistry.addLog(ModBlocks.BARK2.get(), 1, ModBlocks.WOOD2_STRIPPED.get(), 1);
        }
        if (ModBlocks.CRIMSON_STEM.isEnabled() && ConfigBlocksItems.enableStrippedLogs) {
            StrippedLogRegistry.addLog(ModBlocks.CRIMSON_STEM.get(), 0, ModBlocks.CRIMSON_STEM.get(), 2);
            if (ConfigBlocksItems.enableBarkLogs) {
                StrippedLogRegistry.addLog(ModBlocks.CRIMSON_STEM.get(), 1, ModBlocks.CRIMSON_STEM.get(), 3);
            }
        }
        if (ModBlocks.WARPED_STEM.isEnabled() && ConfigBlocksItems.enableStrippedLogs) {
            StrippedLogRegistry.addLog(ModBlocks.WARPED_STEM.get(), 0, ModBlocks.WARPED_STEM.get(), 2);
            if (ConfigBlocksItems.enableBarkLogs) {
                StrippedLogRegistry.addLog(ModBlocks.WARPED_STEM.get(), 1, ModBlocks.WARPED_STEM.get(), 3);
            }
        }
        if (ModBlocks.MANGROVE_LOG.isEnabled() && ConfigBlocksItems.enableStrippedLogs) {
            StrippedLogRegistry.addLog(ModBlocks.MANGROVE_LOG.get(), 0, ModBlocks.MANGROVE_LOG.get(), 2);
            if (ConfigBlocksItems.enableBarkLogs) {
                StrippedLogRegistry.addLog(ModBlocks.MANGROVE_LOG.get(), 1, ModBlocks.MANGROVE_LOG.get(), 3);
            }
        }
        if (ModBlocks.CHERRY_LOG.isEnabled() && ConfigBlocksItems.enableStrippedLogs) {
            StrippedLogRegistry.addLog(ModBlocks.CHERRY_LOG.get(), 0, ModBlocks.CHERRY_LOG.get(), 2);
            if (ConfigBlocksItems.enableBarkLogs) {
                StrippedLogRegistry.addLog(ModBlocks.CHERRY_LOG.get(), 1, ModBlocks.CHERRY_LOG.get(), 3);
            }
        }
        if (ModBlocks.BAMBOO_BLOCK.isEnabled() && ConfigBlocksItems.enableStrippedLogs) {
            StrippedLogRegistry.addLog(ModBlocks.BAMBOO_BLOCK.get(), 0, ModBlocks.BAMBOO_BLOCK.get(), 1);
        }
    }
}

