/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.api;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.registry.GameRegistry;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.api.mappings.RegistryMapping;
import ganymedes01.etfuturum.compat.ModsList;
import ganymedes01.etfuturum.recipes.ModRecipes;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class PistonBehaviorRegistry {
    private static final Map<RegistryMapping<Block>, PistonAction> BEHAVIOR_REGISTRY = Maps.newHashMap();

    public static void addPistonBehavior(Block block, PistonAction action) {
        PistonBehaviorRegistry.addPistonBehavior(block, Short.MAX_VALUE, action);
    }

    public static void addPistonBehavior(Block block, int meta, PistonAction action) {
        if ((meta < 0 || meta > 15) && meta != Short.MAX_VALUE) {
            throw new IllegalArgumentException("Meta must be between 0 and 15 (inclusive)");
        }
        if (block != null && block != Blocks.field_150350_a) {
            BEHAVIOR_REGISTRY.put(new RegistryMapping<Block>(block, meta), action);
        }
    }

    public static void addPistonBehavior(Block block, String action) {
        PistonBehaviorRegistry.addPistonBehavior(block, Short.MAX_VALUE, PistonAction.valueOf(action));
    }

    public static void addPistonBehavior(Block block, int meta, String action) {
        if (!(action.equals("NON_STICKY") || action.equals("BOUNCES_ENTITIES") || action.equals("PULLS_ENTITIES"))) {
            throw new IllegalArgumentException("Action must be NON_STICKY, BOUNCES_ENTITIES, or PULLS_ENTITIES");
        }
        PistonBehaviorRegistry.addPistonBehavior(block, meta, PistonAction.valueOf(action));
    }

    public static void remove(Block block, int meta) {
        BEHAVIOR_REGISTRY.remove(new RegistryMapping<Block>(block, meta));
    }

    public static boolean isNonStickyBlock(Block block, int meta) {
        return BEHAVIOR_REGISTRY.get(new RegistryMapping<Block>(block, meta)) == PistonAction.NON_STICKY;
    }

    public static boolean isStickyBlock(Block block, int meta) {
        PistonAction action = BEHAVIOR_REGISTRY.get(new RegistryMapping<Block>(block, meta));
        return action == PistonAction.BOUNCES_ENTITIES || action == PistonAction.PULLS_ENTITIES;
    }

    public static boolean pullsEntities(Block block, int meta) {
        return BEHAVIOR_REGISTRY.get(new RegistryMapping<Block>(block, meta)) == PistonAction.PULLS_ENTITIES;
    }

    public static boolean bouncesEntities(Block block, int meta) {
        return BEHAVIOR_REGISTRY.get(new RegistryMapping<Block>(block, meta)) == PistonAction.BOUNCES_ENTITIES;
    }

    public static void init() {
        if (ModBlocks.SLIME.isEnabled()) {
            PistonBehaviorRegistry.addPistonBehavior(ModBlocks.SLIME.get(), PistonAction.BOUNCES_ENTITIES);
        }
        if (ModBlocks.HONEY_BLOCK.isEnabled()) {
            PistonBehaviorRegistry.addPistonBehavior(ModBlocks.HONEY_BLOCK.get(), PistonAction.PULLS_ENTITIES);
        }
        for (ModBlocks mb : ModBlocks.TERRACOTTA) {
            if (!mb.isEnabled()) continue;
            PistonBehaviorRegistry.addPistonBehavior(mb.get(), PistonAction.NON_STICKY);
        }
        Block block = GameRegistry.findBlock((String)"VillageNames", (String)"glazedTerracotta");
        if (block != null) {
            PistonBehaviorRegistry.addPistonBehavior(block, PistonAction.NON_STICKY);
        }
        if ((block = GameRegistry.findBlock((String)"VillageNames", (String)"glazedTerracotta2")) != null) {
            PistonBehaviorRegistry.addPistonBehavior(block, PistonAction.NON_STICKY);
        }
        if ((block = GameRegistry.findBlock((String)"VillageNames", (String)"glazedTerracotta3")) != null) {
            PistonBehaviorRegistry.addPistonBehavior(block, PistonAction.NON_STICKY);
        }
        if ((block = GameRegistry.findBlock((String)"VillageNames", (String)"glazedTerracotta4")) != null) {
            PistonBehaviorRegistry.addPistonBehavior(block, PistonAction.NON_STICKY);
        }
        for (String color : ModRecipes.dye_names) {
            block = GameRegistry.findBlock((String)"uptodate", (String)("glazed_terracotta_" + color));
            if (block == null) continue;
            PistonBehaviorRegistry.addPistonBehavior(block, PistonAction.NON_STICKY);
        }
        if (ModsList.TINKERS_CONSTRUCT.isLoaded()) {
            PistonBehaviorRegistry.addPistonBehavior(GameRegistry.findBlock((String)"TConstruct", (String)"slime.gel"), PistonAction.BOUNCES_ENTITIES);
            PistonBehaviorRegistry.addPistonBehavior(GameRegistry.findBlock((String)"TConstruct", (String)"GlueBlock"), PistonAction.PULLS_ENTITIES);
        }
        if (ModsList.MINEFACTORY_RELOADED.isLoaded()) {
            PistonBehaviorRegistry.addPistonBehavior(GameRegistry.findBlock((String)"MineFactoryReloaded", (String)"pinkslime.block"), PistonAction.BOUNCES_ENTITIES);
        }
        if (ModsList.BIOMES_O_PLENTY.isLoaded()) {
            PistonBehaviorRegistry.addPistonBehavior(GameRegistry.findBlock((String)"BiomesOPlenty", (String)"honeyBlock"), PistonAction.PULLS_ENTITIES);
        }
    }

    public static enum PistonAction {
        NON_STICKY,
        BOUNCES_ENTITIES,
        PULLS_ENTITIES;

    }
}

