/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.waila;

import buildcraft.compat.CompatModuleWAILA;
import buildcraft.compat.waila.BuilderDebugDataProvider;
import buildcraft.compat.waila.EntityRobotDataProvider;
import buildcraft.compat.waila.PowerModeEnergyDataProvider;
import buildcraft.compat.waila.PowerModeTransportDataProvider;
import buildcraft.core.BlockEngine;
import buildcraft.robotics.EntityRobot;
import buildcraft.transport.BlockGenericPipe;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.block.Block;

public final class WailaCallback {
    private WailaCallback() {
    }

    public static void callback(IWailaRegistrar registry) {
        if (Loader.isModLoaded((String)"BuildCraft|Energy")) {
            WailaCallback.callbackEnergy(registry);
        }
        if (Loader.isModLoaded((String)"BuildCraft|Robotics")) {
            WailaCallback.callbackRobotics(registry);
        }
        if (Loader.isModLoaded((String)"BuildCraft|Transport")) {
            WailaCallback.callbackTransport(registry);
        }
        if (CompatModuleWAILA.ENABLE_BUILDER_DEBUG) {
            registry.registerTailProvider((IWailaDataProvider)new BuilderDebugDataProvider(), Block.class);
        }
    }

    @Optional.Method(modid="BuildCraft|Energy")
    private static void callbackEnergy(IWailaRegistrar registry) {
        registry.registerBodyProvider((IWailaDataProvider)new PowerModeEnergyDataProvider(), BlockEngine.class);
    }

    @Optional.Method(modid="BuildCraft|Transport")
    private static void callbackTransport(IWailaRegistrar registry) {
        registry.registerBodyProvider((IWailaDataProvider)new PowerModeTransportDataProvider(), BlockGenericPipe.class);
    }

    @Optional.Method(modid="BuildCraft|Robotics")
    private static void callbackRobotics(IWailaRegistrar registry) {
        registry.registerBodyProvider((IWailaEntityProvider)new EntityRobotDataProvider(), EntityRobot.class);
        registry.registerNBTProvider((IWailaEntityProvider)new EntityRobotDataProvider(), EntityRobot.class);
    }
}

