/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.FuzzyMode;
import appeng.api.config.LevelType;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.crafting.ICraftingWatcher;
import appeng.api.networking.crafting.ICraftingWatcherHost;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergyWatcher;
import appeng.api.networking.energy.IEnergyWatcherHost;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.client.texture.CableBusTextures;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.sync.GuiBridge;
import appeng.me.GridAccessException;
import appeng.parts.automation.PartUpgradeable;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Random;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PartLevelEmitter
extends PartUpgradeable
implements IEnergyWatcherHost,
IStackWatcherHost,
ICraftingWatcherHost,
IMEMonitorHandlerReceiver<IAEItemStack>,
ICraftingProvider,
IGridTickable {
    private static final int FLAG_ON = 8;
    private final AppEngInternalAEInventory config = new AppEngInternalAEInventory(this, 1);
    private boolean prevState = false;
    private long lastReportedValue = 0L;
    private long reportingValue = 0L;
    private IStackWatcher myWatcher;
    private IEnergyWatcher myEnergyWatcher;
    private ICraftingWatcher myCraftingWatcher;
    private double centerX;
    private double centerY;
    private double centerZ;
    private int lastWorkingTick = 0;
    private boolean delayedUpdatesQueued = false;

    public PartLevelEmitter(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_EMITTER, RedstoneMode.HIGH_SIGNAL);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.LEVEL_TYPE, LevelType.ITEM_LEVEL);
        this.getConfigManager().registerSetting(Settings.CRAFT_VIA_REDSTONE, YesNo.NO);
        if (MinecraftServer.func_71276_C() != null) {
            this.delayedUpdatesQueued = true;
            this.lastWorkingTick = MinecraftServer.func_71276_C().func_71259_af();
        }
    }

    public long getReportingValue() {
        return this.reportingValue;
    }

    public void setReportingValue(long v) {
        this.reportingValue = v;
        if (this.getConfigManager().getSetting(Settings.LEVEL_TYPE) == LevelType.ENERGY_LEVEL) {
            this.configureWatchers();
        } else {
            this.updateState();
        }
    }

    @MENetworkEventSubscribe
    public void powerChanged(MENetworkPowerStatusChange c) {
        this.updateState();
    }

    private void updateState() {
        boolean isOn = this.isLevelEmitterOn();
        if (this.prevState != isOn) {
            this.getHost().markForUpdate();
            TileEntity te = this.getHost().getTile();
            this.prevState = isOn;
            Platform.notifyBlocksOfNeighbors(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e);
            Platform.notifyBlocksOfNeighbors(te.func_145831_w(), te.field_145851_c + this.getSide().offsetX, te.field_145848_d + this.getSide().offsetY, te.field_145849_e + this.getSide().offsetZ);
        }
    }

    private boolean isLevelEmitterOn() {
        boolean flipState;
        if (Platform.isClient()) {
            return (this.getClientFlags() & 8) == 8;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (this.getInstalledUpgrades(Upgrades.CRAFTING) > 0) {
            try {
                return this.getProxy().getCrafting().isRequesting(this.config.getAEStackInSlot(0));
            }
            catch (GridAccessException gridAccessException) {
                return this.prevState;
            }
        }
        boolean bl = flipState = this.getConfigManager().getSetting(Settings.REDSTONE_EMITTER) == RedstoneMode.LOW_SIGNAL;
        return flipState ? this.reportingValue >= this.lastReportedValue + 1L : this.reportingValue < this.lastReportedValue + 1L;
    }

    @MENetworkEventSubscribe
    public void channelChanged(MENetworkChannelsChanged c) {
        this.updateState();
    }

    @Override
    protected int populateFlags(int cf) {
        return cf | (this.prevState ? 8 : 0);
    }

    @Override
    public IIcon getBreakingTexture() {
        return this.getItemStack().func_77954_c();
    }

    @Override
    public void updateWatcher(ICraftingWatcher newWatcher) {
        this.myCraftingWatcher = newWatcher;
        this.configureWatchers();
    }

    @Override
    public void onRequestChange(ICraftingGrid craftingGrid, IAEItemStack what) {
        this.updateState();
    }

    private void configureWatchers() {
        IAEItemStack myStack = this.config.getAEStackInSlot(0);
        if (this.myWatcher != null) {
            this.myWatcher.clear();
        }
        if (this.myEnergyWatcher != null) {
            this.myEnergyWatcher.clear();
        }
        if (this.myCraftingWatcher != null) {
            this.myCraftingWatcher.clear();
        }
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCraftingPatternChange(this, this.getProxy().getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        if (this.getInstalledUpgrades(Upgrades.CRAFTING) > 0) {
            if (this.myCraftingWatcher != null && myStack != null) {
                this.myCraftingWatcher.add(myStack);
            }
            return;
        }
        if (this.getConfigManager().getSetting(Settings.LEVEL_TYPE) == LevelType.ENERGY_LEVEL) {
            if (this.myEnergyWatcher != null) {
                this.myEnergyWatcher.add(Double.valueOf(this.reportingValue));
            }
            try {
                this.lastReportedValue = (long)this.getProxy().getEnergy().getStoredPower();
                this.updateState();
                this.getProxy().getStorage().getItemInventory().removeListener(this);
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return;
        }
        try {
            if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0 || myStack == null) {
                this.getProxy().getStorage().getItemInventory().addListener(this, this.getProxy().getGrid());
            } else {
                this.getProxy().getStorage().getItemInventory().removeListener(this);
                if (this.myWatcher != null) {
                    this.myWatcher.add(myStack);
                }
            }
            this.updateReportingValue(this.getProxy().getStorage().getItemInventory());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void updateReportingValue(IMEMonitor<IAEItemStack> monitor) {
        IAEItemStack myStack = this.config.getAEStackInSlot(0);
        if (myStack == null) {
            this.lastReportedValue = 0L;
            for (IAEItemStack st : monitor.getStorageList()) {
                this.lastReportedValue += st.getStackSize();
            }
        } else if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0) {
            this.lastReportedValue = 0L;
            FuzzyMode fzMode = (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE);
            Collection<IAEItemStack> fuzzyList = monitor.getStorageList().findFuzzy(myStack, fzMode);
            for (IAEItemStack st : fuzzyList) {
                this.lastReportedValue += st.getStackSize();
            }
        } else {
            IAEItemStack r = monitor.getStorageList().findPrecise(myStack);
            this.lastReportedValue = r == null ? 0L : r.getStackSize();
        }
        this.updateState();
    }

    @Override
    public void updateWatcher(IStackWatcher newWatcher) {
        this.myWatcher = newWatcher;
        this.configureWatchers();
    }

    @Override
    public void onStackChange(IItemList o, IAEStack fullStack, IAEStack diffStack, BaseActionSource src, StorageChannel chan) {
        if (chan == StorageChannel.ITEMS && fullStack.equals(this.config.getAEStackInSlot(0)) && this.getInstalledUpgrades(Upgrades.FUZZY) == 0) {
            this.lastReportedValue = fullStack.getStackSize();
            this.updateState();
        }
    }

    @Override
    public void updateWatcher(IEnergyWatcher newWatcher) {
        this.myEnergyWatcher = newWatcher;
        this.configureWatchers();
    }

    @Override
    public void onThresholdPass(IEnergyGrid energyGrid) {
        this.lastReportedValue = (long)energyGrid.getStoredPower();
        this.updateState();
    }

    @Override
    public boolean isValid(Object effectiveGrid) {
        try {
            return this.getProxy().getGrid() == effectiveGrid;
        }
        catch (GridAccessException e) {
            return false;
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(AEConfig.instance.levelEmitterDelay / 2, AEConfig.instance.levelEmitterDelay, !this.delayedUpdatesQueued, true);
    }

    private boolean canDoWork() {
        int currentTick = MinecraftServer.func_71276_C().func_71259_af();
        return currentTick - this.lastWorkingTick > AEConfig.instance.levelEmitterDelay;
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        if (this.delayedUpdatesQueued && this.canDoWork()) {
            this.delayedUpdatesQueued = false;
            this.lastWorkingTick = MinecraftServer.func_71276_C().func_71259_af();
            this.onListUpdate();
        }
        return this.delayedUpdatesQueued ? TickRateModulation.IDLE : TickRateModulation.SLEEP;
    }

    @Override
    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, BaseActionSource actionSource) {
        if (this.canDoWork()) {
            if (this.delayedUpdatesQueued) {
                this.delayedUpdatesQueued = false;
                try {
                    this.getProxy().getTick().sleepDevice(this.getProxy().getNode());
                }
                catch (GridAccessException e) {
                    AELog.error(e, "Couldn't put level emitter to sleep after cancelling delayed updates");
                }
            }
            this.lastWorkingTick = MinecraftServer.func_71276_C().func_71259_af();
            this.updateReportingValue((IMEMonitor)monitor);
        } else if (!this.delayedUpdatesQueued) {
            this.delayedUpdatesQueued = true;
            try {
                this.getProxy().getTick().alertDevice(this.getProxy().getNode());
            }
            catch (GridAccessException e) {
                AELog.error(e, "Couldn't wake up level emitter for delayed updates");
            }
        }
    }

    @Override
    public void onListUpdate() {
        try {
            this.updateReportingValue(this.getProxy().getStorage().getItemInventory());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(7.0, 7.0, 11.0, 9.0, 9.0, 16.0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setTexture(this.getItemStack().func_77954_c());
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        this.renderTorchAtAngle(0.0, -0.5, 0.0);
        tess.func_78381_a();
    }

    private void renderTorchAtAngle(double baseX, double baseY, double baseZ) {
        boolean isOn = this.isLevelEmitterOn();
        IIcon offTexture = this.getItemStack().func_77954_c();
        IIcon IIcon2 = isOn ? CableBusTextures.LevelEmitterTorchOn.getIcon() : offTexture;
        this.centerX = baseX + 0.5;
        this.centerY = baseY + 0.5;
        this.centerZ = baseZ + 0.5;
        baseY += 0.4375;
        float var16 = IIcon2.func_94209_e();
        float var17 = IIcon2.func_94212_f();
        float var18 = IIcon2.func_94206_g();
        float var19 = IIcon2.func_94210_h();
        double var20b = offTexture.func_94214_a(7.0);
        double var24b = offTexture.func_94214_a(9.0);
        double var20 = IIcon2.func_94214_a(7.0);
        double var24 = IIcon2.func_94214_a(9.0);
        double var22 = IIcon2.func_94207_b(6.0 + (isOn ? 0.0 : 1.0));
        double var26 = IIcon2.func_94207_b(8.0 + (isOn ? 0.0 : 1.0));
        double var28 = IIcon2.func_94214_a(7.0);
        double var30 = IIcon2.func_94207_b(13.0);
        double var32 = IIcon2.func_94214_a(9.0);
        double var34 = IIcon2.func_94207_b(15.0);
        double var22b = IIcon2.func_94207_b(9.0);
        double var26b = IIcon2.func_94207_b(11.0);
        double var36 = (baseX += 0.5) - 0.5;
        double var38 = baseX + 0.5;
        double var40 = (baseZ += 0.5) - 0.5;
        double var42 = baseZ + 0.5;
        double toff = 0.0;
        if (!isOn) {
            toff = 0.0625;
        }
        Tessellator var12 = Tessellator.field_78398_a;
        if (isOn) {
            var12.func_78386_a(1.0f, 1.0f, 1.0f);
            var12.func_78380_c(0xB000B0);
        }
        double TorchLen = 0.625;
        double var44 = 0.0625;
        double Zero = 0.0;
        double par10 = 0.0;
        this.addVertexWithUV(baseX + 0.0 - 0.0625, baseY + 0.625 - toff, baseZ + 0.0 - 0.0625, var20, var22);
        this.addVertexWithUV(baseX + 0.0 - 0.0625, baseY + 0.625 - toff, baseZ + 0.0 + 0.0625, var20, var26);
        this.addVertexWithUV(baseX + 0.0 + 0.0625, baseY + 0.625 - toff, baseZ + 0.0 + 0.0625, var24, var26);
        this.addVertexWithUV(baseX + 0.0 + 0.0625, baseY + 0.625 - toff, baseZ + 0.0 - 0.0625, var24, var22);
        double var422 = 0.254;
        this.addVertexWithUV(baseX + 0.0 + 0.0625, baseY + 0.254, baseZ + 0.0 - 0.0625, var24b, var22b);
        this.addVertexWithUV(baseX + 0.0 + 0.0625, baseY + 0.254, baseZ + 0.0 + 0.0625, var24b, var26b);
        this.addVertexWithUV(baseX + 0.0 - 0.0625, baseY + 0.254, baseZ + 0.0 + 0.0625, var20b, var26b);
        this.addVertexWithUV(baseX + 0.0 - 0.0625, baseY + 0.254, baseZ + 0.0 - 0.0625, var20b, var22b);
        this.addVertexWithUV(baseX + 0.0625 + 0.0, baseY, baseZ - 0.0625 + 0.0, var32, var30);
        this.addVertexWithUV(baseX + 0.0625 + 0.0, baseY, baseZ + 0.0625 + 0.0, var32, var34);
        this.addVertexWithUV(baseX - 0.0625 + 0.0, baseY, baseZ + 0.0625 + 0.0, var28, var34);
        this.addVertexWithUV(baseX - 0.0625 + 0.0, baseY, baseZ - 0.0625 + 0.0, var28, var30);
        this.addVertexWithUV(baseX - 0.0625, baseY + 1.0, var40, var16, var18);
        this.addVertexWithUV(baseX - 0.0625 + 0.0, baseY + 0.0, var40 + 0.0, var16, var19);
        this.addVertexWithUV(baseX - 0.0625 + 0.0, baseY + 0.0, var42 + 0.0, var17, var19);
        this.addVertexWithUV(baseX - 0.0625, baseY + 1.0, var42, var17, var18);
        this.addVertexWithUV(baseX + 0.0625, baseY + 1.0, var42, var16, var18);
        this.addVertexWithUV(baseX + 0.0 + 0.0625, baseY + 0.0, var42 + 0.0, var16, var19);
        this.addVertexWithUV(baseX + 0.0 + 0.0625, baseY + 0.0, var40 + 0.0, var17, var19);
        this.addVertexWithUV(baseX + 0.0625, baseY + 1.0, var40, var17, var18);
        this.addVertexWithUV(var36, baseY + 1.0, baseZ + 0.0625, var16, var18);
        this.addVertexWithUV(var36 + 0.0, baseY + 0.0, baseZ + 0.0625 + 0.0, var16, var19);
        this.addVertexWithUV(var38 + 0.0, baseY + 0.0, baseZ + 0.0625 + 0.0, var17, var19);
        this.addVertexWithUV(var38, baseY + 1.0, baseZ + 0.0625, var17, var18);
        this.addVertexWithUV(var38, baseY + 1.0, baseZ - 0.0625, var16, var18);
        this.addVertexWithUV(var38 + 0.0, baseY + 0.0, baseZ - 0.0625 + 0.0, var16, var19);
        this.addVertexWithUV(var36 + 0.0, baseY + 0.0, baseZ - 0.0625 + 0.0, var17, var19);
        this.addVertexWithUV(var36, baseY + 1.0, baseZ - 0.0625, var17, var18);
    }

    private void addVertexWithUV(double x, double y, double z, double u, double v) {
        double m;
        Tessellator var12 = Tessellator.field_78398_a;
        x -= this.centerX;
        y -= this.centerY;
        z -= this.centerZ;
        if (this.getSide() == ForgeDirection.DOWN) {
            y = -y;
            z = -z;
        }
        if (this.getSide() == ForgeDirection.EAST) {
            m = x;
            x = y;
            y = m;
            y = -y;
        }
        if (this.getSide() == ForgeDirection.WEST) {
            m = x;
            x = -y;
            y = m;
        }
        if (this.getSide() == ForgeDirection.SOUTH) {
            m = z;
            z = y;
            y = m;
            y = -y;
        }
        if (this.getSide() == ForgeDirection.NORTH) {
            m = z;
            z = -y;
            y = m;
        }
        var12.func_78374_a(x += this.centerX, y += this.centerY, z += this.centerZ, u, v);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setTexture(this.getItemStack().func_77954_c());
        renderer.field_147837_f = true;
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78380_c(rh.getBlock().func_149677_c((IBlockAccess)this.getHost().getTile().func_145831_w(), x, y, z));
        tess.func_78386_a(1.0f, 1.0f, 1.0f);
        this.renderTorchAtAngle(x, y, z);
        renderer.field_147837_f = false;
        rh.setBounds(7.0f, 7.0f, 11.0f, 9.0f, 9.0f, 12.0f);
        this.renderLights(x, y, z, rh, renderer);
    }

    @Override
    public int isProvidingStrongPower() {
        return this.prevState ? 15 : 0;
    }

    @Override
    public int isProvidingWeakPower() {
        return this.prevState ? 15 : 0;
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random r) {
        if (this.isLevelEmitterOn()) {
            ForgeDirection d = this.getSide();
            double d0 = (double)((float)d.offsetX * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double d1 = (double)((float)d.offsetY * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double d2 = (double)((float)d.offsetZ * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            world.func_72869_a("reddust", 0.5 + (double)x + d0, 0.5 + (double)y + d1, 0.5 + (double)z + d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public int cableConnectionRenderTo() {
        return 16;
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        if (!player.func_70093_af()) {
            if (Platform.isClient()) {
                return true;
            }
            Platform.openGUI(player, this.getHost().getTile(), this.getSide(), GuiBridge.GUI_LEVEL_EMITTER);
            return true;
        }
        return false;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        this.configureWatchers();
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        if (inv == this.config) {
            this.configureWatchers();
        }
        super.onChangeInventory(inv, slot, mc, removedStack, newStack);
    }

    @Override
    public void upgradesChanged() {
        this.configureWatchers();
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.lastReportedValue = data.func_74763_f("lastReportedValue");
        this.reportingValue = data.func_74763_f("reportingValue");
        this.prevState = data.func_74767_n("prevState");
        this.config.readFromNBT(data, "config");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74772_a("lastReportedValue", this.lastReportedValue);
        data.func_74772_a("reportingValue", this.reportingValue);
        data.func_74757_a("prevState", this.prevState);
        this.config.writeToNBT(data, "config");
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.config;
        }
        return super.getInventoryByName(name);
    }

    @Override
    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        return false;
    }

    @Override
    public boolean isBusy() {
        return true;
    }

    @Override
    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        IAEItemStack what;
        if (this.getInstalledUpgrades(Upgrades.CRAFTING) > 0 && this.getConfigManager().getSetting(Settings.CRAFT_VIA_REDSTONE) == YesNo.YES && (what = this.config.getAEStackInSlot(0)) != null) {
            craftingTracker.setEmitable(what);
        }
    }
}

