/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.EntityLivingBase;
import org.joml.Math;
import org.joml.Vector3d;

public class IrisExclusiveUniforms {
    public static void addIrisExclusiveUniforms(UniformHolder uniforms) {
        WorldInfoUniforms.addWorldInfoUniforms(uniforms);
        uniforms.uniform1f(UniformUpdateFrequency.PER_FRAME, "thunderStrength", IrisExclusiveUniforms::getThunderStrength);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "currentPlayerHealth", IrisExclusiveUniforms::getCurrentHealth);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "maxPlayerHealth", IrisExclusiveUniforms::getMaxHealth);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "currentPlayerHunger", IrisExclusiveUniforms::getCurrentHunger);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "maxPlayerHunger", () -> 20);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "currentPlayerAir", IrisExclusiveUniforms::getCurrentAir);
        uniforms.uniform1f(UniformUpdateFrequency.PER_TICK, "maxPlayerAir", IrisExclusiveUniforms::getMaxAir);
        uniforms.uniform1b(UniformUpdateFrequency.PER_FRAME, "firstPersonCamera", IrisExclusiveUniforms::isFirstPersonCamera);
        uniforms.uniform1b(UniformUpdateFrequency.PER_TICK, "isSpectator", IrisExclusiveUniforms::isSpectator);
        uniforms.uniform3d(UniformUpdateFrequency.PER_FRAME, "eyePosition", IrisExclusiveUniforms::getEyePosition);
    }

    private static float getThunderStrength() {
        return Math.clamp((float)0.0f, (float)1.0f, (float)Minecraft.func_71410_x().field_71441_e.field_73017_q);
    }

    private static float getCurrentHealth() {
        if (Minecraft.func_71410_x().field_71439_g == null || !Minecraft.func_71410_x().field_71442_b.func_78763_f()) {
            return -1.0f;
        }
        return Minecraft.func_71410_x().field_71439_g.func_110143_aJ() / Minecraft.func_71410_x().field_71439_g.func_110138_aP();
    }

    private static float getCurrentHunger() {
        if (Minecraft.func_71410_x().field_71439_g == null || !Minecraft.func_71410_x().field_71442_b.func_78763_f()) {
            return -1.0f;
        }
        return (float)Minecraft.func_71410_x().field_71439_g.func_71024_bL().func_75116_a() / 20.0f;
    }

    private static float getCurrentAir() {
        if (Minecraft.func_71410_x().field_71439_g == null || !Minecraft.func_71410_x().field_71442_b.func_78763_f()) {
            return -1.0f;
        }
        return (float)Minecraft.func_71410_x().field_71439_g.func_70086_ai() / (float)Minecraft.func_71410_x().field_71439_g.func_70086_ai();
    }

    private static float getMaxAir() {
        if (Minecraft.func_71410_x().field_71439_g == null || !Minecraft.func_71410_x().field_71442_b.func_78763_f()) {
            return -1.0f;
        }
        return 300.0f;
    }

    private static float getMaxHealth() {
        if (Minecraft.func_71410_x().field_71439_g == null || !Minecraft.func_71410_x().field_71442_b.func_78763_f()) {
            return -1.0f;
        }
        return Minecraft.func_71410_x().field_71439_g.func_110138_aP();
    }

    private static boolean isFirstPersonCamera() {
        return Minecraft.func_71410_x().field_71474_y.field_74320_O == 1;
    }

    private static boolean isSpectator() {
        PlayerControllerMP controller = Minecraft.func_71410_x().field_71442_b;
        if (controller == null) {
            return false;
        }
        return controller.field_78779_k.func_77148_a() == 3;
    }

    private static Vector3d getEyePosition() {
        EntityLivingBase eye = Minecraft.func_71410_x().field_71451_h;
        return new Vector3d(eye.field_70165_t, eye.field_70163_u, eye.field_70161_v);
    }

    public static class WorldInfoUniforms {
        public static void addWorldInfoUniforms(UniformHolder uniforms) {
            WorldClient level = Minecraft.func_71410_x().field_71441_e;
            uniforms.uniform1i(UniformUpdateFrequency.PER_FRAME, "bedrockLevel", () -> 0);
            uniforms.uniform1f(UniformUpdateFrequency.PER_FRAME, "cloudHeight", () -> {
                if (level != null && level.field_73011_w != null) {
                    return level.field_73011_w.func_76571_f();
                }
                return 192.0;
            });
            uniforms.uniform1i(UniformUpdateFrequency.PER_FRAME, "heightLimit", () -> {
                if (level != null && level.field_73011_w != null) {
                    return level.field_73011_w.getHeight();
                }
                return 256;
            });
            uniforms.uniform1b(UniformUpdateFrequency.PER_FRAME, "hasCeiling", () -> {
                if (level != null && level.field_73011_w != null) {
                    return level.field_73011_w.field_76576_e;
                }
                return false;
            });
            uniforms.uniform1b(UniformUpdateFrequency.PER_FRAME, "hasSkylight", () -> {
                if (level != null && level.field_73011_w != null) {
                    return !level.field_73011_w.field_76576_e;
                }
                return true;
            });
            uniforms.uniform1f(UniformUpdateFrequency.PER_FRAME, "ambientLight", () -> {
                if (level != null && level.field_73011_w != null) {
                    return level.field_73011_w.field_76573_f[0];
                }
                return 0.0f;
            });
        }
    }
}

