/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.pipeline;

import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.ModelQuad;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.ModelQuadView;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.ModelQuadViewMutable;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.properties.ModelQuadFacing;
import com.gtnewhorizon.gtnhlib.client.renderer.util.DirectionUtil;
import com.gtnewhorizon.gtnhlib.client.renderer.util.WorldUtil;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import java.util.Arrays;
import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.util.color.ColorARGB;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import org.joml.Math;
import org.joml.Vector3d;

public class FluidRenderer {
    private static final float EPSILON = 0.001f;
    private final LightPipelineProvider lpp;
    private final BlockPos scratchPos = new BlockPos();
    private final ModelQuadViewMutable quad = new ModelQuad();
    private final QuadLightData quadLightData = new QuadLightData();
    private boolean useSeparateAo;
    private final int[] quadColors = new int[4];
    private final int[] biomeColors = new int[4];
    private final TextureAtlasSprite missingTex = Minecraft.func_71410_x().func_147117_R().func_110572_b("minecraft:missing");

    public FluidRenderer(LightPipelineProvider lpp) {
        int normal = Norm3b.pack(0.0f, 1.0f, 0.0f);
        for (int i = 0; i < 4; ++i) {
            this.quad.setNormal(i, normal);
        }
        this.lpp = lpp;
    }

    private boolean isFluidOccluded(IBlockAccess world, int x, int y, int z, ForgeDirection d, Fluid fluid) {
        boolean tmp;
        Block block = world.func_147439_a(x, y, z);
        boolean bl = tmp = WorldUtil.getFluid((Block)world.func_147439_a(x + d.offsetX, y + d.offsetY, z + d.offsetZ)) == fluid;
        if (block.func_149688_o().func_76218_k()) {
            return tmp || block.isSideSolid(world, x, y, z, d);
        }
        return tmp;
    }

    private boolean isSideExposed(IBlockAccess world, int x, int y, int z, ForgeDirection dir, float height) {
        BlockPos pos = this.scratchPos.set(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        Block block = world.func_147439_a(pos.x, pos.y, pos.z);
        if (block.func_149688_o().func_76218_k()) {
            boolean renderAsFullCube = block.func_149686_d();
            if (renderAsFullCube) {
                return dir == ForgeDirection.UP;
            }
            return true;
        }
        return true;
    }

    public boolean render(IBlockAccess world, WorldSlice slice, Block block, BlockPos pos, ChunkModelBuffers buffers) {
        this.useSeparateAo = AngelicaConfig.enableIris && BlockRenderingSettings.INSTANCE.shouldUseSeparateAo();
        int posX = pos.x;
        int posY = pos.y;
        int posZ = pos.z;
        Fluid fluid = WorldUtil.getFluid((Block)block);
        if (fluid == null) {
            return false;
        }
        boolean sfUp = this.isFluidOccluded(world, posX, posY, posZ, ForgeDirection.UP, fluid);
        boolean sfDown = this.isFluidOccluded(world, posX, posY, posZ, ForgeDirection.DOWN, fluid) || !this.isSideExposed(world, posX, posY, posZ, ForgeDirection.DOWN, 0.8888889f);
        boolean sfNorth = this.isFluidOccluded(world, posX, posY, posZ, ForgeDirection.NORTH, fluid);
        boolean sfSouth = this.isFluidOccluded(world, posX, posY, posZ, ForgeDirection.SOUTH, fluid);
        boolean sfWest = this.isFluidOccluded(world, posX, posY, posZ, ForgeDirection.WEST, fluid);
        boolean sfEast = this.isFluidOccluded(world, posX, posY, posZ, ForgeDirection.EAST, fluid);
        if (sfUp && sfDown && sfEast && sfWest && sfNorth && sfSouth) {
            return false;
        }
        TextureAtlasSprite[] sprites = new TextureAtlasSprite[]{(TextureAtlasSprite)fluid.getStillIcon(), (TextureAtlasSprite)fluid.getFlowingIcon(), null};
        TextureAtlasSprite textureAtlasSprite = sprites[0] == null ? this.missingTex : sprites[0];
        sprites[0] = textureAtlasSprite;
        sprites[1] = sprites[1] == null ? this.missingTex : sprites[1];
        boolean hc = fluid.getColor() != -1;
        boolean rendered = false;
        float h1 = this.getCornerHeight(world, posX, posY, posZ, fluid);
        float h2 = this.getCornerHeight(world, posX, posY, posZ + 1, fluid);
        float h3 = this.getCornerHeight(world, posX + 1, posY, posZ + 1, fluid);
        float h4 = this.getCornerHeight(world, posX + 1, posY, posZ, fluid);
        float yOffset = sfDown ? 0.0f : 0.001f;
        ModelQuadViewMutable quad = this.quad;
        LightMode mode = hc && Minecraft.func_71379_u() ? LightMode.SMOOTH : LightMode.FLAT;
        LightPipeline lighter = this.lpp.getLighter(mode);
        quad.setFlags(0);
        if (!sfUp && this.isSideExposed(world, posX, posY, posZ, ForgeDirection.UP, java.lang.Math.min(java.lang.Math.min(h1, h2), java.lang.Math.min(h3, h4)))) {
            float v4;
            float u4;
            float v3;
            float u3;
            float v2;
            float u2;
            float v1;
            float u1;
            ModelQuadFacing facing;
            TextureAtlasSprite sprite;
            h1 -= 0.001f;
            h2 -= 0.001f;
            h3 -= 0.001f;
            h4 -= 0.001f;
            Vector3d velocity = WorldUtil.getVelocity((IBlockAccess)world, (int)pos.x, (int)pos.y, (int)pos.z, (Block)block);
            if (velocity.x == 0.0 && velocity.z == 0.0) {
                sprite = sprites[0];
                facing = ModelQuadFacing.UP;
                u1 = sprite.func_94214_a(0.0);
                v1 = sprite.func_94207_b(0.0);
                u2 = u1;
                v2 = sprite.func_94207_b(16.0);
                u3 = sprite.func_94214_a(16.0);
                v3 = v2;
                u4 = u3;
                v4 = v1;
            } else {
                sprite = sprites[1];
                facing = ModelQuadFacing.UNASSIGNED;
                float dir = (float)java.lang.Math.atan2(velocity.z, velocity.x) - 1.5707964f;
                float sin = MathHelper.func_76126_a((float)dir) * 0.25f;
                float cos = MathHelper.func_76134_b((float)dir) * 0.25f;
                u1 = sprite.func_94214_a((double)(8.0f + (-cos - sin) * 16.0f));
                v1 = sprite.func_94207_b((double)(8.0f + (-cos + sin) * 16.0f));
                u2 = sprite.func_94214_a((double)(8.0f + (-cos + sin) * 16.0f));
                v2 = sprite.func_94207_b((double)(8.0f + (cos + sin) * 16.0f));
                u3 = sprite.func_94214_a((double)(8.0f + (cos + sin) * 16.0f));
                v3 = sprite.func_94207_b((double)(8.0f + (cos - sin) * 16.0f));
                u4 = sprite.func_94214_a((double)(8.0f + (cos - sin) * 16.0f));
                v4 = sprite.func_94207_b((double)(8.0f + (-cos - sin) * 16.0f));
            }
            float uAvg = (u1 + u2 + u3 + u4) / 4.0f;
            float vAvg = (v1 + v2 + v3 + v4) / 4.0f;
            float s1 = (float)sprites[0].func_94211_a() / (sprites[0].func_94212_f() - sprites[0].func_94209_e());
            float s2 = (float)sprites[0].func_94216_b() / (sprites[0].func_94210_h() - sprites[0].func_94206_g());
            float s3 = 4.0f / java.lang.Math.max(s2, s1);
            u1 = Math.lerp((float)u1, (float)uAvg, (float)s3);
            u2 = Math.lerp((float)u2, (float)uAvg, (float)s3);
            u3 = Math.lerp((float)u3, (float)uAvg, (float)s3);
            u4 = Math.lerp((float)u4, (float)uAvg, (float)s3);
            v1 = Math.lerp((float)v1, (float)vAvg, (float)s3);
            v2 = Math.lerp((float)v2, (float)vAvg, (float)s3);
            v3 = Math.lerp((float)v3, (float)vAvg, (float)s3);
            v4 = Math.lerp((float)v4, (float)vAvg, (float)s3);
            quad.setSprite(sprite);
            this.setVertex(quad, 0, 0.0f, h1, 0.0f, u1, v1);
            this.setVertex(quad, 1, 0.0f, h2, 1.0f, u2, v2);
            this.setVertex(quad, 2, 1.0f, h3, 1.0f, u3, v3);
            this.setVertex(quad, 3, 1.0f, h4, 0.0f, u4, v4);
            this.calculateQuadColors((ModelQuadView)quad, pos, lighter, ForgeDirection.UP, 1.0f, hc, slice);
            this.flushQuad(buffers, (ModelQuadView)quad, facing, false);
            if (WorldUtil.method_15756((IBlockAccess)slice, (BlockPos)this.scratchPos.set(posX, posY + 1, posZ), (Fluid)fluid)) {
                this.setVertex(quad, 3, 0.0f, h1, 0.0f, u1, v1);
                this.setVertex(quad, 2, 0.0f, h2, 1.0f, u2, v2);
                this.setVertex(quad, 1, 1.0f, h3, 1.0f, u3, v3);
                this.setVertex(quad, 0, 1.0f, h4, 0.0f, u4, v4);
                this.flushQuad(buffers, (ModelQuadView)quad, ModelQuadFacing.DOWN, true);
            }
            rendered = true;
        }
        if (!sfDown) {
            TextureAtlasSprite sprite = sprites[0];
            float minU = sprite.func_94209_e();
            float maxU = sprite.func_94212_f();
            float minV = sprite.func_94206_g();
            float maxV = sprite.func_94210_h();
            quad.setSprite(sprite);
            this.setVertex(quad, 0, 0.0f, yOffset, 1.0f, minU, maxV);
            this.setVertex(quad, 1, 0.0f, yOffset, 0.0f, minU, minV);
            this.setVertex(quad, 2, 1.0f, yOffset, 0.0f, maxU, minV);
            this.setVertex(quad, 3, 1.0f, yOffset, 1.0f, maxU, maxV);
            this.calculateQuadColors((ModelQuadView)quad, pos, lighter, ForgeDirection.DOWN, 1.0f, hc, slice);
            this.flushQuad(buffers, (ModelQuadView)quad, ModelQuadFacing.DOWN, false);
            rendered = true;
        }
        quad.setFlags(4);
        block6: for (ForgeDirection dir : DirectionUtil.HORIZONTAL_DIRECTIONS) {
            Block adjBlock;
            float z2;
            float z1;
            float x2;
            float x1;
            float c2;
            float c1;
            switch (dir) {
                case NORTH: {
                    if (sfNorth) continue block6;
                    c1 = h1;
                    c2 = h4;
                    x1 = 0.0f;
                    x2 = 1.0f;
                    z2 = z1 = 0.001f;
                    break;
                }
                case SOUTH: {
                    if (sfSouth) continue block6;
                    c1 = h3;
                    c2 = h2;
                    x1 = 1.0f;
                    x2 = 0.0f;
                    z2 = z1 = 0.999f;
                    break;
                }
                case WEST: {
                    if (sfWest) continue block6;
                    c1 = h2;
                    c2 = h1;
                    x2 = x1 = 0.001f;
                    z1 = 1.0f;
                    z2 = 0.0f;
                    break;
                }
                case EAST: {
                    if (sfEast) continue block6;
                    c1 = h4;
                    c2 = h3;
                    x2 = x1 = 0.999f;
                    z1 = 0.0f;
                    z2 = 1.0f;
                    break;
                }
                default: {
                    continue block6;
                }
            }
            if (!this.isSideExposed(world, posX, posY, posZ, dir, java.lang.Math.max(c1, c2))) continue;
            int adjX = posX + dir.offsetX;
            int adjY = posY + dir.offsetY;
            int adjZ = posZ + dir.offsetZ;
            TextureAtlasSprite sprite = sprites[1];
            TextureAtlasSprite oSprite = sprites[2];
            if (oSprite != null && WorldUtil.shouldDisplayFluidOverlay((Block)(adjBlock = world.func_147439_a(adjX, adjY, adjZ)))) {
                sprite = oSprite;
            }
            float u1 = sprite.func_94214_a(0.0);
            float u2 = sprite.func_94214_a(8.0);
            float v1 = sprite.func_94207_b((double)((1.0f - c1) * 16.0f * 0.5f));
            float v2 = sprite.func_94207_b((double)((1.0f - c2) * 16.0f * 0.5f));
            float v3 = sprite.func_94207_b(8.0);
            quad.setSprite(sprite);
            this.setVertex(quad, 0, x2, c2, z2, u2, v2);
            this.setVertex(quad, 1, x2, yOffset, z2, u2, v3);
            this.setVertex(quad, 2, x1, yOffset, z1, u1, v3);
            this.setVertex(quad, 3, x1, c1, z1, u1, v1);
            float br = dir.offsetZ != 0 ? 0.8f : 0.6f;
            ModelQuadFacing facing = ModelQuadFacing.fromDirection((ForgeDirection)dir);
            this.calculateQuadColors((ModelQuadView)quad, pos, lighter, dir, br, hc, slice);
            this.flushQuad(buffers, (ModelQuadView)quad, facing, false);
            if (sprite != oSprite) {
                this.setVertex(quad, 0, x1, c1, z1, u1, v1);
                this.setVertex(quad, 1, x1, yOffset, z1, u1, v3);
                this.setVertex(quad, 2, x2, yOffset, z2, u2, v3);
                this.setVertex(quad, 3, x2, c2, z2, u2, v2);
                this.flushQuad(buffers, (ModelQuadView)quad, facing.getOpposite(), true);
            }
            rendered = true;
        }
        return rendered;
    }

    private void calculateQuadColors(ModelQuadView quad, BlockPos pos, LightPipeline lighter, ForgeDirection dir, float brightness, boolean colorized, WorldSlice slice) {
        QuadLightData light = this.quadLightData;
        lighter.calculate(quad, pos, light, null, dir, false);
        if (colorized) {
            int color = slice.func_147439_a(pos.x, pos.y, pos.z).func_149720_d((IBlockAccess)slice, pos.x, pos.y, pos.z);
            Arrays.fill(this.biomeColors, ColorARGB.toABGR(color));
        }
        for (int i = 0; i < 4; ++i) {
            int color = colorized ? this.biomeColors[i] : -1;
            float ao = light.br[i] * brightness;
            if (this.useSeparateAo) {
                color &= 0xFFFFFF;
                color |= (int)(ao * 255.0f) << 24;
            } else {
                color = ColorABGR.mul(color, ao);
            }
            this.quadColors[i] = color;
        }
    }

    private void flushQuad(ChunkModelBuffers buffers, ModelQuadView quad, ModelQuadFacing facing, boolean flip) {
        int lightOrder;
        int vertexIdx;
        if (flip) {
            vertexIdx = 3;
            lightOrder = -1;
        } else {
            vertexIdx = 0;
            lightOrder = 1;
        }
        ModelVertexSink sink = buffers.getSink(facing);
        sink.ensureCapacity(4);
        for (int i = 0; i < 4; ++i) {
            float x = quad.getX(i);
            float y = quad.getY(i);
            float z = quad.getZ(i);
            int color = this.quadColors[vertexIdx];
            float u = quad.getTexU(i);
            float v = quad.getTexV(i);
            int light = this.quadLightData.lm[vertexIdx];
            sink.writeQuad(x, y, z, color, u, v, light, -1);
            vertexIdx += lightOrder;
        }
        TextureAtlasSprite sprite = quad.rubidium$getSprite();
        if (sprite != null) {
            buffers.getRenderData().addSprite(sprite);
        }
        sink.flush();
    }

    private void setVertex(ModelQuadViewMutable quad, int i, float x, float y, float z, float u, float v) {
        quad.setX(i, x);
        quad.setY(i, y);
        quad.setZ(i, z);
        quad.setTexU(i, u);
        quad.setTexV(i, v);
    }

    private float getCornerHeight(IBlockAccess world, int x, int y, int z, Fluid fluid) {
        int samples = 0;
        float totalHeight = 0.0f;
        for (int i = 0; i < 4; ++i) {
            int x2 = x - (i & 1);
            int z2 = z - (i >> 1 & 1);
            Block block = world.func_147439_a(x2, y + 1, z2);
            if (WorldUtil.getFluid((Block)block) == fluid) {
                return 1.0f;
            }
            BlockPos pos = this.scratchPos.set(x2, y, z2);
            block = world.func_147439_a(pos.x, pos.y, pos.z);
            int meta = world.func_72805_g(pos.x, pos.y, pos.z);
            Fluid fluid2 = WorldUtil.getFluid((Block)block);
            if (fluid2 == fluid) {
                float height = WorldUtil.getFluidHeight((Fluid)fluid2, (int)meta);
                if (height >= 0.8f) {
                    totalHeight += height * 10.0f;
                    samples += 10;
                    continue;
                }
                totalHeight += height;
                ++samples;
                continue;
            }
            if (block.func_149688_o().func_76220_a()) continue;
            ++samples;
        }
        return totalHeight / (float)samples;
    }
}

