/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.lib.multiblock;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import mantle.world.CoordTuple;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import tmechworks.lib.multiblock.IMultiblockMember;
import tmechworks.lib.multiblock.MultiblockRegistry;

public abstract class MultiblockMasterBaseLogic {
    protected World worldObj;
    protected Set<CoordTuple> connectedBlocks;
    protected LinkedList<CoordTuple> pendingRemovalBlocks;
    protected CoordTuple referenceCoord;
    protected CoordTuple minimumCoord;
    protected CoordTuple maximumCoord;
    protected boolean forceRecheck;
    protected boolean forceRevisit;
    protected boolean chunksHaveLoaded;
    protected boolean doUpdates;

    protected MultiblockMasterBaseLogic(World world) {
        this.worldObj = world;
        this.connectedBlocks = new CopyOnWriteArraySet<CoordTuple>();
        this.pendingRemovalBlocks = new LinkedList();
        this.referenceCoord = null;
        this.minimumCoord = new CoordTuple(0.0, 0.0, 0.0);
        this.maximumCoord = new CoordTuple(0.0, 0.0, 0.0);
        this.forceRecheck = false;
        this.chunksHaveLoaded = false;
        this.doUpdates = true;
    }

    public void restore(NBTTagCompound savedData) {
        this.readFromNBT(savedData);
        MultiblockRegistry.register(this);
    }

    public boolean hasBlock(CoordTuple blockCoord) {
        return this.connectedBlocks.contains(blockCoord);
    }

    public void attachBlock(IMultiblockMember member) {
        CoordTuple coords = member.getCoordInWorld();
        boolean newMultiblock = this.connectedBlocks.isEmpty();
        if (this.connectedBlocks.contains(coords)) {
            return;
        }
        this.connectedBlocks.add(coords);
        member.onAttached(this);
        this.onBlockAdded(member);
        this.worldObj.func_147471_g(coords.x, coords.y, coords.z);
        if (newMultiblock) {
            MultiblockRegistry.register(this);
        }
        if (this.referenceCoord == null) {
            this.referenceCoord = coords;
            member.becomeMultiblockSaveDelegate();
        } else if (coords.compareTo((Object)this.referenceCoord) < 0) {
            TileEntity te = this.worldObj.func_147438_o(this.referenceCoord.x, this.referenceCoord.y, this.referenceCoord.z);
            ((IMultiblockMember)te).forfeitMultiblockSaveDelegate();
            this.referenceCoord = coords;
            member.becomeMultiblockSaveDelegate();
        }
        this.forceRecheck = true;
    }

    protected abstract void onBlockAdded(IMultiblockMember var1);

    protected abstract void onBlockRemoved(IMultiblockMember var1);

    public void detachBlock(IMultiblockMember member, boolean chunkUnloading) {
        this._detachBlock(member, chunkUnloading);
        if (!chunkUnloading && this.forceRecheck) {
            this.revisitBlocks();
        }
    }

    private void _detachBlock(IMultiblockMember member, boolean chunkUnloading) {
        CoordTuple coords = member.getCoordInWorld();
        if (chunkUnloading) {
            this.disableUpdates();
        }
        if (this.connectedBlocks.contains(coords)) {
            member.onDetached(this);
            this.connectedBlocks.remove(coords);
            this.onBlockRemoved(member);
            if (this.referenceCoord != null && this.referenceCoord.equals((Object)coords)) {
                member.forfeitMultiblockSaveDelegate();
                this.referenceCoord = null;
            }
        }
        if (this.connectedBlocks.isEmpty()) {
            MultiblockRegistry.unregister(this);
            return;
        }
        if (!this.forceRecheck && chunkUnloading) {
            this.chunksHaveLoaded = true;
        } else if (this.chunksHaveLoaded) {
            this.chunksHaveLoaded = chunkUnloading;
        }
        this.forceRecheck = true;
        if (this.referenceCoord == null) {
            if (!this.connectedBlocks.isEmpty()) {
                for (CoordTuple tcoord : this.connectedBlocks) {
                    TileEntity te = this.worldObj.func_147438_o(tcoord.x, tcoord.y, tcoord.z);
                    if (te == null) continue;
                    if (this.referenceCoord == null) {
                        this.referenceCoord = tcoord;
                        continue;
                    }
                    if (tcoord.compareTo((Object)this.referenceCoord) >= 0) continue;
                    this.referenceCoord = tcoord;
                }
            }
            if (this.referenceCoord != null) {
                TileEntity te = this.worldObj.func_147438_o(this.referenceCoord.x, this.referenceCoord.y, this.referenceCoord.z);
                ((IMultiblockMember)te).becomeMultiblockSaveDelegate();
            }
        }
    }

    private void disableUpdates() {
        this.doUpdates = false;
    }

    private void enableUpdates() {
        this.doUpdates = true;
    }

    private boolean getUpdateState() {
        return this.doUpdates;
    }

    public void beginMerging() {
    }

    public void merge(MultiblockMasterBaseLogic other) {
        if (this.referenceCoord.compareTo((Object)other.referenceCoord) >= 0) {
            throw new IllegalArgumentException("You're doing it wrong");
        }
        CopyOnWriteArraySet<CoordTuple> acquiredMembers = new CopyOnWriteArraySet<CoordTuple>(other.connectedBlocks);
        other.onMergedIntoOtherMaster(this);
        for (CoordTuple coord : acquiredMembers) {
            this.connectedBlocks.add(coord);
            TileEntity te = this.worldObj.func_147438_o(coord.x, coord.y, coord.z);
            IMultiblockMember acquiredMember = (IMultiblockMember)te;
            acquiredMember.onMasterMerged(this);
            this.onBlockAdded(acquiredMember);
        }
    }

    private void onMergedIntoOtherMaster(MultiblockMasterBaseLogic newMaster) {
        this.disableUpdates();
        if (this.referenceCoord != null) {
            TileEntity te = this.worldObj.func_147438_o(this.referenceCoord.x, this.referenceCoord.y, this.referenceCoord.z);
            if (te instanceof IMultiblockMember) {
                ((IMultiblockMember)te).forfeitMultiblockSaveDelegate();
            }
            this.referenceCoord = null;
        }
        this.connectedBlocks.clear();
        MultiblockRegistry.unregister(this);
        this.onDataMerge(newMaster);
    }

    protected abstract void onDataMerge(MultiblockMasterBaseLogic var1);

    public void endMerging() {
    }

    public final void doMultiblockTick() {
        if (this.forceRevisit) {
            this.forceRevisit = false;
            while (!this.pendingRemovalBlocks.isEmpty()) {
                CoordTuple deadCoords = this.pendingRemovalBlocks.removeFirst();
                if (!this.connectedBlocks.contains(deadCoords)) continue;
                if (this.referenceCoord.equals((Object)deadCoords)) {
                    this.referenceCoord = null;
                }
                this.connectedBlocks.remove(deadCoords);
            }
            if (this.referenceCoord == null) {
                if (!this.connectedBlocks.isEmpty()) {
                    for (CoordTuple tcoord : this.connectedBlocks) {
                        TileEntity te = this.worldObj.func_147438_o(tcoord.x, tcoord.y, tcoord.z);
                        if (!(te instanceof IMultiblockMember)) continue;
                        if (this.referenceCoord == null) {
                            this.referenceCoord = tcoord;
                            continue;
                        }
                        if (tcoord.compareTo((Object)this.referenceCoord) >= 0) continue;
                        this.referenceCoord = tcoord;
                    }
                }
                if (this.referenceCoord != null) {
                    TileEntity te = this.worldObj.func_147438_o(this.referenceCoord.x, this.referenceCoord.y, this.referenceCoord.z);
                    ((IMultiblockMember)te).becomeMultiblockSaveDelegate();
                }
            }
            this.revisitBlocks();
            this.forceRecheck = true;
        }
        if (this.connectedBlocks.isEmpty()) {
            MultiblockRegistry.unregister(this);
            return;
        }
        if (this.forceRecheck) {
            this.doStructureCheck();
            this.forceRecheck = false;
        }
        if (!this.doUpdates || this.doUpdate()) {
            // empty if block
        }
    }

    public void doStructureCheck() {
    }

    public boolean doUpdate() {
        return false;
    }

    public void revisitBlocks() {
        if (this.referenceCoord != null && this.worldObj.func_147438_o(this.referenceCoord.x, this.referenceCoord.y, this.referenceCoord.z) == null) {
            this.referenceCoord = null;
        }
        for (CoordTuple coord : this.connectedBlocks) {
            TileEntity te;
            if (!this.worldObj.func_72863_F().func_73149_a(coord.x >> 4, coord.z >> 4) || !((te = this.worldObj.func_147438_o(coord.x, coord.y, coord.z)) instanceof IMultiblockMember)) continue;
            ((IMultiblockMember)te).setUnivisted();
            if (this.referenceCoord == null) {
                this.referenceCoord = coord;
                continue;
            }
            if (coord.compareTo((Object)this.referenceCoord) >= 0) continue;
            this.referenceCoord = coord;
        }
        if (this.referenceCoord == null) {
            return;
        }
        LinkedList<IMultiblockMember> membersToCheck = new LinkedList<IMultiblockMember>();
        IMultiblockMember[] nearbyMembers = null;
        IMultiblockMember member = (IMultiblockMember)this.worldObj.func_147438_o(this.referenceCoord.x, this.referenceCoord.y, this.referenceCoord.z);
        membersToCheck.add(member);
        while (!membersToCheck.isEmpty()) {
            member = (IMultiblockMember)membersToCheck.removeFirst();
            member.setVisited();
            for (IMultiblockMember nearbyMember : nearbyMembers = member.getNeighboringMembers()) {
                if (nearbyMember.getMultiblockMaster() != this || nearbyMember.isVisited()) continue;
                nearbyMember.setVisited();
                membersToCheck.add(nearbyMember);
            }
        }
        LinkedList<IMultiblockMember> orphans = new LinkedList<IMultiblockMember>();
        ArrayList<CoordTuple> deadBlocks = new ArrayList<CoordTuple>();
        for (CoordTuple coord : this.connectedBlocks) {
            if (!this.worldObj.func_72863_F().func_73149_a(coord.x >> 4, coord.z >> 4)) {
                deadBlocks.add(coord);
                continue;
            }
            member = (IMultiblockMember)this.worldObj.func_147438_o(coord.x, coord.y, coord.z);
            if (member == null) {
                deadBlocks.add(coord);
                continue;
            }
            if (member.isVisited()) continue;
            orphans.add(member);
        }
        this.connectedBlocks.removeAll(deadBlocks);
        for (IMultiblockMember orphan : orphans) {
            this._detachBlock(orphan, false);
        }
        for (IMultiblockMember orphan : orphans) {
            if (orphan.isConnected()) continue;
            orphan.onOrphaned();
        }
    }

    public CoordTuple getReferenceCoord() {
        return this.referenceCoord;
    }

    public int getNumConnectedBlocks() {
        return this.connectedBlocks.size();
    }

    public abstract void writeToNBT(NBTTagCompound var1);

    public abstract void readFromNBT(NBTTagCompound var1);

    public abstract void formatDescriptionPacket(NBTTagCompound var1);

    public abstract void decodeDescriptionPacket(NBTTagCompound var1);

    public void scheduleRemoveAndRevisit(IMultiblockMember remove) {
        this.forceRevisit = true;
        this.pendingRemovalBlocks.add(remove.getCoordInWorld());
    }
}

