/*
 * Decompiled with CFR 0.152.
 */
package serverutils.invsee.inventories;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import serverutils.invsee.inventories.IModdedInventory;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.icon.Icon;
import serverutils.lib.icon.ItemIcon;

public class EnderInventory
implements IModdedInventory {
    private static final Icon ENDER_CHEST_ICON = ItemIcon.getItemIcon(Blocks.field_150477_bB);

    @Override
    @Nullable
    public IInventory loadOnlineInventory(EntityPlayerMP player) {
        return player.func_71005_bN();
    }

    @Override
    @Nullable
    public IInventory loadOfflineInventory(ForgePlayer player) {
        InventoryEnderChest enderInv = new InventoryEnderChest();
        enderInv.func_70486_a(player.getPlayerNBT().func_150295_c("EnderItems", 10));
        return enderInv;
    }

    @Override
    @NotNull
    public IInventory createInventory(EntityPlayer player, int size) {
        return new InventoryEnderChest();
    }

    @Override
    @NotNull
    public Icon getButtonIcon() {
        return ENDER_CHEST_ICON;
    }

    @Override
    @NotNull
    public String getButtonText() {
        return "Ender Chest";
    }

    @Override
    public void saveInventory(ForgePlayer player, IInventory inventory) {
        if (player.isOnline()) {
            return;
        }
        NBTTagCompound tag = player.getPlayerNBT();
        InventoryEnderChest enderInv = (InventoryEnderChest)inventory;
        tag.func_74782_a("EnderItems", (NBTBase)enderInv.func_70487_g());
        player.setPlayerNBT(tag);
    }
}

