/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.recipedebugger;

import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.CustomInteractable;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.ComponentLabel;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.Tooltip;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.recipedebugger.RecipeHandler;
import com.github.dcysteine.neicustomdiagram.main.Lang;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechOreDictUtil;
import java.util.EnumMap;

class LabelHandler {
    private final EnumMap<RecipeHandler.RecipeMap, ItemComponent> componentMap = new EnumMap(RecipeHandler.RecipeMap.class);

    LabelHandler() {
    }

    void initialize() {
        for (RecipeHandler.RecipeMap recipeMap : RecipeHandler.RecipeMap.values()) {
            this.componentMap.put(recipeMap, GregTechOreDictUtil.getComponent(recipeMap.item));
        }
    }

    CustomInteractable buildLabel(RecipeHandler.RecipeMap recipeMap, Point pos) {
        ComponentLabel label = ComponentLabel.create(this.componentMap.get((Object)recipeMap), pos);
        Tooltip tooltip = Tooltip.create(Lang.GREGTECH_5_RECIPE_DEBUGGER.trans(recipeMap.tooltipKey), Tooltip.INFO_FORMATTING);
        return CustomInteractable.builder(label).setTooltip(tooltip).build();
    }
}

