/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.factorization.handlers;

import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.ReflectionHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.factorization.FactorizationHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.factorization.Crystallizer")
public class Crystallizer {
    public static final String name = "Factorization Crystallizer";

    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack output, IItemStack solution, double output_count) {
        Object recipe = FactorizationHelper.getCrystallizerRecipe(InputHelper.toStack(input), InputHelper.toStack(output), InputHelper.toStack(solution), (float)output_count);
        MineTweakerAPI.apply((IUndoableAction)new Add(recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        LinkedList<Object> recipes = new LinkedList<Object>();
        for (Object r : FactorizationHelper.crystallizer) {
            ItemStack out;
            if (r == null || (out = (ItemStack)ReflectionHelper.getObject(r, "output")) == null || !StackHelper.matches(output, InputHelper.toIItemStack(out))) continue;
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, output.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<Object> {
        public Remove(List<Object> recipes) {
            super(Crystallizer.name, FactorizationHelper.crystallizer, recipes);
        }

        @Override
        public String getRecipeInfo(Object recipe) {
            return LogHelper.getStackDescription((ItemStack)ReflectionHelper.getObject(recipe, "output"));
        }
    }

    private static class Add
    extends BaseListAddition<Object> {
        public Add(Object recipe) {
            super(Crystallizer.name, FactorizationHelper.crystallizer);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(Object recipe) {
            return LogHelper.getStackDescription((ItemStack)ReflectionHelper.getObject(recipe, "output"));
        }
    }
}

