/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome;

import chylex.hee.entity.technical.EntityTechnicalBiomeInteraction;
import chylex.hee.init.BlockList;
import chylex.hee.mechanics.causatum.CausatumMeters;
import chylex.hee.mechanics.causatum.CausatumUtils;
import chylex.hee.system.collections.CustomArrayList;
import chylex.hee.system.collections.WeightedList;
import chylex.hee.system.collections.weight.IWeightProvider;
import chylex.hee.system.util.CollectionUtil;
import chylex.hee.system.util.DragonUtil;
import chylex.hee.system.util.MathUtil;
import chylex.hee.world.structure.island.biome.IslandBiomeBurningMountains;
import chylex.hee.world.structure.island.biome.IslandBiomeEnchantedIsland;
import chylex.hee.world.structure.island.biome.IslandBiomeInfestedForest;
import chylex.hee.world.structure.island.biome.data.AbstractBiomeInteraction;
import chylex.hee.world.structure.island.biome.data.BiomeContentVariation;
import chylex.hee.world.structure.island.biome.data.BiomeRandomDeviation;
import chylex.hee.world.structure.island.biome.data.IslandBiomeData;
import chylex.hee.world.structure.island.biome.decorator.IslandBiomeDecorator;
import chylex.hee.world.structure.util.pregen.LargeStructureWorld;
import chylex.hee.world.util.SpawnEntry;
import gnu.trove.map.hash.TByteObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public abstract class IslandBiomeBase {
    public static final IslandBiomeBase infestedForest = new IslandBiomeInfestedForest(0);
    public static final IslandBiomeBase burningMountains = new IslandBiomeBurningMountains(1);
    public static final IslandBiomeBase enchantedIsland = new IslandBiomeEnchantedIsland(2);
    public static final List<IslandBiomeBase> biomeList = CollectionUtil.newList(infestedForest, burningMountains, enchantedIsland);
    public final byte biomeID;
    private final TByteObjectHashMap<WeightedList<SpawnEntry>> spawnEntries;
    protected final TByteObjectHashMap<CustomArrayList<AbstractBiomeInteraction.BiomeInteraction>> interactions;
    protected final WeightedList<BiomeContentVariation> contentVariations;
    protected final List<BiomeRandomDeviation> randomDeviations;
    protected IslandBiomeData data;

    public static final IslandBiomeBase pickRandomBiome(Random rand) {
        return biomeList.get(rand.nextInt(biomeList.size()));
    }

    protected IslandBiomeBase(int biomeID) {
        this.biomeID = (byte)biomeID;
        this.spawnEntries = new TByteObjectHashMap();
        this.interactions = new TByteObjectHashMap();
        this.contentVariations = new WeightedList((IWeightProvider[])new BiomeContentVariation[0]);
        this.randomDeviations = new ArrayList<BiomeRandomDeviation>();
    }

    public Collection<WeightedList<SpawnEntry>> getAllSpawnEntries() {
        return this.spawnEntries.valueCollection();
    }

    public WeightedList<SpawnEntry> getSpawnEntries(BiomeContentVariation contentVariation) {
        this.spawnEntries.putIfAbsent(contentVariation.id, (Object)new WeightedList((IWeightProvider[])new SpawnEntry[0]));
        return (WeightedList)this.spawnEntries.get(contentVariation.id);
    }

    public CustomArrayList<AbstractBiomeInteraction.BiomeInteraction> getInteractions(BiomeContentVariation contentVariation) {
        this.interactions.putIfAbsent(contentVariation.id, new CustomArrayList());
        return (CustomArrayList)this.interactions.get(contentVariation.id);
    }

    public final IslandBiomeData generateData(Random rand) {
        BiomeContentVariation contentVariation = this.contentVariations.getRandomItem(rand);
        ArrayList<BiomeRandomDeviation> available = new ArrayList<BiomeRandomDeviation>();
        ArrayList<BiomeRandomDeviation> selected = new ArrayList<BiomeRandomDeviation>();
        for (BiomeRandomDeviation deviation : this.randomDeviations) {
            if (!deviation.isCompatible(contentVariation)) continue;
            available.add(deviation);
        }
        int deviationAmt = available.isEmpty() ? 0 : MathUtil.clamp(MathUtil.floor((rand.nextGaussian() + 0.4) * (double)available.size() * (0.5 + 0.5 * rand.nextDouble())), 0, available.size());
        for (int deviationAttempt = 0; deviationAttempt < deviationAmt; ++deviationAttempt) {
            selected.add((BiomeRandomDeviation)available.remove(rand.nextInt(available.size())));
        }
        return new IslandBiomeData(contentVariation, selected.toArray(new BiomeRandomDeviation[selected.size()]));
    }

    public final IslandBiomeData getData() {
        return this.data;
    }

    public void prepareDecoration(IslandBiomeData data) {
        this.data = data;
    }

    public final void decorateGen(LargeStructureWorld world, Random rand, int centerX, int centerZ) {
        this.getDecorator().begin(world, rand, centerX, centerZ, this.data);
        this.decorate(world, rand, centerX, centerZ);
        this.getDecorator().end();
    }

    protected abstract void decorate(LargeStructureWorld var1, Random var2, int var3, int var4);

    public boolean isValidMetadata(int meta) {
        for (BiomeContentVariation variation : this.contentVariations) {
            if (variation.id != meta) continue;
            return true;
        }
        return false;
    }

    public void updateCore(World world, int x, int y, int z, int meta) {
        if (world.field_73010_i.isEmpty()) {
            return;
        }
        if (world.field_73012_v.nextInt(3) == 0) {
            SpawnEntry entry;
            int halfsz = 104;
            int playerCheck = halfsz * 2;
            SpawnEntry spawnEntry = entry = this.spawnEntries.containsKey((byte)meta) ? (SpawnEntry)((WeightedList)this.spawnEntries.get((byte)meta)).getRandomItem(world.field_73012_v) : null;
            if (entry == null) {
                return;
            }
            if (world.field_73013_u == EnumDifficulty.PEACEFUL && entry.isMob) {
                return;
            }
            int currentAmount = world.func_72872_a(entry.getMobClass(), AxisAlignedBB.func_72330_a((double)(x - halfsz), (double)y, (double)(z - halfsz), (double)(x + halfsz), (double)(y + 100), (double)(z + halfsz))).size();
            if (currentAmount >= entry.getMaxAmount() || world.field_73012_v.nextFloat() * 1.1f < (float)currentAmount / (float)entry.getMaxAmount()) {
                return;
            }
            int playerAmount = world.field_73010_i.size();
            block0: for (int a = 0; a < Math.min(entry.getMaxAmount() >> 2, world.field_73012_v.nextInt(1 + entry.getMaxAmount() - currentAmount)); ++a) {
                EntityLiving e = entry.createMob(world);
                for (int attempt = 0; attempt < 20 + Math.min(10, playerAmount); ++attempt) {
                    double posZ;
                    EntityPlayer player = (EntityPlayer)world.field_73010_i.get(world.field_73012_v.nextInt(playerAmount));
                    if (MathUtil.distance(player.field_70165_t - (double)x, player.field_70161_v - (double)z) > (double)playerCheck) continue;
                    double ang = world.field_73012_v.nextDouble() * 2.0 * Math.PI;
                    double len = 19.0 + (double)world.field_73012_v.nextInt(55) + Math.abs(world.field_73012_v.nextGaussian() * 12.0);
                    double posX = player.field_70165_t + Math.cos(ang) * len;
                    if (MathUtil.distance(posX - (double)x + 0.5, (posZ = player.field_70161_v + Math.sin(ang) * len) - (double)z + 0.5) > 150.0) continue;
                    for (int yAttempt = 0; yAttempt < 28; ++yAttempt) {
                        e.func_70012_b(posX, (double)MathUtil.floor(player.field_70163_u + (world.field_73012_v.nextDouble() - 0.65) * (double)(yAttempt + 4) * 3.0) + 0.01, posZ, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                        if (IslandBiomeBase.hasEntitySpace(world, (Entity)e)) break;
                    }
                    int xx = MathUtil.floor(e.field_70165_t);
                    int zz = MathUtil.floor(e.field_70161_v);
                    boolean hasBlockBelow = false;
                    int yy = (int)e.field_70163_u - 1;
                    while ((double)yy > e.field_70163_u - 4.0) {
                        if (world.func_147439_a(xx, yy, zz).func_149662_c()) {
                            hasBlockBelow = true;
                            break;
                        }
                        --yy;
                    }
                    if (!hasBlockBelow || DragonUtil.getTopBlockY(world, BlockList.end_terrain, xx, zz, 120) <= 30) continue;
                    e.func_70634_a(e.field_70165_t, e.field_70163_u + 0.01, e.field_70161_v);
                    world.func_72838_d((Entity)e);
                    continue block0;
                }
            }
        }
        BiomeContentVariation variation = null;
        for (BiomeContentVariation contentVariation : this.contentVariations) {
            if (contentVariation.id != meta) continue;
            variation = contentVariation;
            break;
        }
        if (variation != null && this.interactions.containsKey(variation.id) && world.field_73012_v.nextInt(5) == 0) {
            for (AbstractBiomeInteraction.BiomeInteraction interaction : (CustomArrayList)this.interactions.get(variation.id)) {
                AbstractBiomeInteraction interactionInstance;
                if (world.field_73012_v.nextInt(interaction.getRNG()) != 0) continue;
                List list = world.func_72872_a(EntityTechnicalBiomeInteraction.class, AxisAlignedBB.func_72330_a((double)(x - 1), (double)(y - 1), (double)(z - 1), (double)(x + 2), (double)(y + 2), (double)(z + 2)));
                int instances = 0;
                for (EntityTechnicalBiomeInteraction interactionEntity : list) {
                    if (!interactionEntity.getInteraction().getIdentifier().equals(interaction.getIdentifier())) continue;
                    instances = (byte)(instances + 1);
                }
                if (instances >= interaction.getMaxInstances() || (interactionInstance = interaction.create()) == null) continue;
                world.func_72838_d((Entity)new EntityTechnicalBiomeInteraction(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, interactionInstance));
            }
        }
        for (EntityPlayer player : world.field_73010_i) {
            int iz;
            int iy;
            int ix;
            if (!IslandBiomeBase.isPlayerMoving(player) || !(player instanceof EntityPlayerMP) || world.func_147439_a(ix = (int)player.field_70165_t, iy = (int)player.field_70163_u - 1, iz = (int)player.field_70161_v) != IslandBiomeBase.getTopBlock() || world.func_72805_g(ix, iy, iz) != this.getTopBlockMeta()) continue;
            CausatumUtils.increase(player, CausatumMeters.END_EXPLORATION, 0.6f);
            if (((EntityPlayerMP)player).func_147099_x().func_77443_a(this.getAchievement())) continue;
            player.func_71064_a((StatBase)this.getAchievement(), 1);
        }
    }

    private static final boolean hasEntitySpace(World world, Entity entity) {
        return world.func_72855_b(entity.field_70121_D) && world.func_72945_a(entity, entity.field_70121_D).isEmpty() && !world.func_72953_d(entity.field_70121_D);
    }

    private static final boolean isPlayerMoving(EntityPlayer player) {
        return Math.abs(player.field_70142_S - player.field_70165_t) > 1.0E-4 || Math.abs(player.field_70136_U - player.field_70161_v) > 1.0E-4;
    }

    public float getIslandSurfaceHeightMultiplier() {
        return 1.0f;
    }

    public float getIslandMassHeightMultiplier() {
        return 1.0f;
    }

    public float getIslandFillFactor() {
        return 1.0f;
    }

    public float getCaveAmountMultiplier() {
        return 1.0f;
    }

    public float getCaveBranchingChance() {
        return 0.04f;
    }

    public float getOreAmountMultiplier() {
        return 1.0f;
    }

    protected abstract IslandBiomeDecorator getDecorator();

    protected abstract Achievement getAchievement();

    public abstract int getTopBlockMeta();

    public static final Block getTopBlock() {
        return BlockList.end_terrain;
    }
}

