/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.baubles;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import baubles.common.container.InventoryBaubles;
import baubles.common.lib.PlayerHandler;
import com.dreammaster.main.MainRegistry;
import com.dreammaster.main.NHItems;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import eu.usrv.yamcore.auxiliary.Hacks;
import eu.usrv.yamcore.client.Notification;
import eu.usrv.yamcore.client.NotificationTickHandler;
import eu.usrv.yamcore.iface.IExtendedModItem;
import gregtech.api.damagesources.GTDamageSources;
import gregtech.api.enums.Mods;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xonin.backhand.api.core.BackhandUtils;

public final class OvenGlove
extends Item
implements IBauble,
IExtendedModItem<OvenGlove> {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final String NBTTAG_DURABILITY = "Durability";
    private final String _mItemName;
    private final String _mCreativeTab;
    private static final int MaxDurability = 1000;
    private static boolean checkPopup = false;
    private static long prevTime = Long.MIN_VALUE;
    private static int curRand = -1;
    public IIcon[] icons = new IIcon[2];

    public OvenGlove getConstructedItem() {
        return (OvenGlove)((Object)NHItems.OVEN_GLOVE.get());
    }

    public String getCreativeTabName() {
        return this._mCreativeTab;
    }

    public String getUnlocalizedNameForRegistration() {
        return super.func_77658_a();
    }

    public OvenGlove(String pItemName, String pCreativeTab) {
        this._mItemName = pItemName;
        this._mCreativeTab = pCreativeTab;
        super.func_111206_d(String.format("%s:item%s", "dreamcraft", this._mItemName));
        super.func_77655_b(this._mItemName);
        super.func_77656_e(0);
        super.func_77627_a(true);
    }

    public String func_77667_c(ItemStack stack) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            long curTime = System.currentTimeMillis();
            if (curTime - prevTime > 1000L || curRand == -1) {
                curRand = MainRegistry.Rnd.nextInt(4);
            }
            prevTime = curTime;
            return String.format("%s_%d_%d", this.func_77658_a(), stack.func_77960_j(), curRand);
        }
        return super.func_77667_c(stack);
    }

    public void func_94581_a(IIconRegister reg) {
        for (int i = 0; i < 2; ++i) {
            this.icons[i] = reg.func_94245_a(String.format("%s:item%s_%d", "dreamcraft", this._mItemName, i));
        }
    }

    public IIcon func_77617_a(int meta) {
        return this.icons[meta];
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 2; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public boolean canEquip(ItemStack arg0, EntityLivingBase arg1) {
        return true;
    }

    public boolean canUnequip(ItemStack arg0, EntityLivingBase arg1) {
        return true;
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.RING;
    }

    public void onWornTick(ItemStack itemStack, EntityLivingBase entity) {
        if (!this.shouldNotify(entity)) {
            return;
        }
        if (checkPopup) {
            InventoryBaubles baubles = PlayerHandler.getPlayerBaubles((EntityPlayer)((EntityPlayer)entity));
            ItemStack ring1 = baubles.stackList[1];
            ItemStack ring2 = baubles.stackList[2];
            if (ring1 == null || ring2 == null || !(ring1.func_77973_b() instanceof OvenGlove) || !(ring2.func_77973_b() instanceof OvenGlove)) {
                return;
            }
            if (ring1.func_77960_j() != 0 || ring2.func_77960_j() != 1) {
                Notification noti = new Notification(ring1, "Wrong place", "The gloves feel weird...");
                NotificationTickHandler.guiNotification.queueNotification(noti);
            }
            checkPopup = false;
        }
    }

    private boolean shouldNotify(EntityLivingBase entity) {
        return entity instanceof EntityPlayer && entity.field_70170_p.field_72995_K && entity == Hacks.safeCast((Object)Minecraft.func_71410_x().field_71439_g);
    }

    public void onEquipped(ItemStack arg0, EntityLivingBase entity) {
        if (!this.shouldNotify(entity)) {
            return;
        }
        checkPopup = true;
    }

    public void onUnequipped(ItemStack arg0, EntityLivingBase pEntityBase) {
    }

    public void func_77622_d(ItemStack pItemStack, World pWorld, EntityPlayer pEntityPlayer) {
        this.createOrInitNBTTag(pItemStack);
    }

    private static int getNBTDurability(ItemStack pItemStack) {
        return pItemStack.field_77990_d.func_74762_e(NBTTAG_DURABILITY);
    }

    private static void damageItem(ItemStack pItemStack) {
        int tCurrentDura = OvenGlove.getNBTDurability(pItemStack);
        if (tCurrentDura > 0) {
            pItemStack.field_77990_d.func_74768_a(NBTTAG_DURABILITY, --tCurrentDura);
        }
    }

    public void func_77624_a(ItemStack pItemStack, EntityPlayer pWorld, List list, boolean par4) {
        this.createOrInitNBTTag(pItemStack);
        list.add("Protecting your fingers since 1890");
        list.add(String.format("Durability: %d/%d", OvenGlove.getNBTDurability(pItemStack), 1000));
        if (pItemStack.field_77990_d.func_74762_e(NBTTAG_DURABILITY) <= 1) {
            list.add("This glove is too damaged to protect you. You need to repair it");
        }
    }

    private void createOrInitNBTTag(ItemStack pItemStack) {
        if (pItemStack.field_77990_d == null) {
            pItemStack.func_77982_d(new NBTTagCompound());
            pItemStack.field_77990_d.func_74768_a(NBTTAG_DURABILITY, 1000);
        }
    }

    public static class EventHandler {
        @SubscribeEvent
        public void onDamage(LivingAttackEvent event) {
            boolean cancelled;
            Entity entity = event.entity;
            if (!(entity instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)entity;
            if (!(event.source instanceof GTDamageSources.DamageSourceHotItem)) {
                return;
            }
            if (player.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
                event.setCanceled(true);
                return;
            }
            InventoryBaubles baubles = PlayerHandler.getPlayerBaubles((EntityPlayer)player);
            ItemStack cause = ((GTDamageSources.DamageSourceHotItem)event.source).getDamagingStack();
            boolean bl = cancelled = cause == player.func_70694_bm();
            if (!cancelled && Mods.Backhand.isModLoaded() && cause == BackhandUtils.getOffhandItem((EntityPlayer)player)) {
                cancelled = true;
            }
            if (!cancelled) {
                return;
            }
            ItemStack ring1 = baubles.stackList[1];
            ItemStack ring2 = baubles.stackList[2];
            if (ring1 == null || ring2 == null || !(ring1.func_77973_b() instanceof OvenGlove) || !(ring2.func_77973_b() instanceof OvenGlove)) {
                return;
            }
            if (ring1.func_77960_j() != 0 || ring2.func_77960_j() != 1) {
                return;
            }
            if (ring1.field_77990_d == null || ring2.field_77990_d == null) {
                return;
            }
            if (ring1.field_77990_d.func_74762_e(OvenGlove.NBTTAG_DURABILITY) <= 1 || ring2.field_77990_d.func_74762_e(OvenGlove.NBTTAG_DURABILITY) <= 1) {
                return;
            }
            event.setCanceled(true);
            int randomDamage = MainRegistry.Rnd.nextInt(10);
            if (randomDamage == 1) {
                OvenGlove.damageItem(ring1);
            } else if (randomDamage == 2) {
                OvenGlove.damageItem(ring2);
            }
        }
    }
}

