/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api.placeholders;

import betterquesting.api.placeholders.EntityPlaceholder;
import betterquesting.api.placeholders.FluidPlaceholder;
import betterquesting.api.placeholders.ItemPlaceholder;
import betterquesting.api.utils.BigItemStack;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class PlaceholderConverter {
    public static Entity convertEntity(Entity orig, World world, NBTTagCompound nbt) {
        Entity entity = orig;
        if (orig == null) {
            entity = new EntityPlaceholder(world);
            ((EntityPlaceholder)entity).SetOriginalTags(nbt);
        } else if (orig instanceof EntityPlaceholder) {
            EntityPlaceholder p = (EntityPlaceholder)orig;
            Entity tmp = EntityList.func_75615_a((NBTTagCompound)p.GetOriginalTags(), (World)world);
            entity = tmp != null ? tmp : p;
        }
        return entity;
    }

    public static BigItemStack convertItem(Item item, String name, int count, int damage, String oreDict, NBTTagCompound nbt) {
        if (item == null) {
            BigItemStack stack = new BigItemStack(ItemPlaceholder.placeholder, count, damage).setOreDict(oreDict);
            stack.SetTagCompound(new NBTTagCompound());
            stack.GetTagCompound().func_74778_a("orig_id", name);
            stack.GetTagCompound().func_74768_a("orig_meta", damage);
            if (nbt != null) {
                stack.GetTagCompound().func_74782_a("orig_tag", (NBTBase)nbt);
            }
            return stack;
        }
        if (item == ItemPlaceholder.placeholder && nbt != null) {
            String idName = nbt.func_74779_i("orig_id");
            Item restored = (Item)Item.field_150901_e.func_82594_a(idName);
            if (restored == null) {
                try {
                    restored = Item.func_150899_d((int)Short.parseShort(idName));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (restored != null) {
                BigItemStack stack = new BigItemStack(restored, count, nbt.func_74764_b("orig_meta") ? nbt.func_74762_e("orig_meta") : damage).setOreDict(oreDict);
                if (nbt.func_74764_b("orig_tag")) {
                    stack.SetTagCompound(nbt.func_74775_l("orig_tag"));
                }
                return stack;
            }
            if (damage > 0 && !nbt.func_74764_b("orig_meta")) {
                nbt.func_74768_a("orig_meta", damage);
                damage = 0;
            }
        }
        BigItemStack stack = new BigItemStack(item, count, damage).setOreDict(oreDict);
        if (nbt != null) {
            stack.SetTagCompound(nbt);
        }
        return stack;
    }

    public static FluidStack convertFluid(Fluid fluid, String name, int amount, NBTTagCompound nbt) {
        Fluid restored;
        if (fluid == null) {
            FluidStack stack = new FluidStack(FluidPlaceholder.fluidPlaceholder, amount);
            NBTTagCompound orig = new NBTTagCompound();
            orig.func_74778_a("orig_id", name);
            if (nbt != null) {
                orig.func_74782_a("orig_tag", (NBTBase)nbt);
            }
            stack.tag = orig;
            return stack;
        }
        if (fluid == FluidPlaceholder.fluidPlaceholder && nbt != null && (restored = FluidRegistry.getFluid((String)nbt.func_74779_i("orig_id"))) != null) {
            FluidStack stack = new FluidStack(restored, amount);
            if (nbt.func_74764_b("orig_tag")) {
                stack.tag = nbt.func_74775_l("orig_tag");
            }
            return stack;
        }
        FluidStack stack = new FluidStack(fluid, amount);
        if (nbt != null) {
            stack.tag = nbt;
        }
        return stack;
    }
}

