/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.enfs.dir;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import pro.gravit.utils.enfs.dir.FileEntry;

public class CachedFile
extends FileEntry {
    private final FileEntry delegate;
    private volatile SoftReference<byte[]> cache;

    public CachedFile(FileEntry fileEntry) {
        this.delegate = fileEntry;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        byte[] byArray;
        byte[] byArray2 = byArray = this.cache == null ? null : this.cache.get();
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        InputStream inputStream = this.tryCache();
        if (inputStream != null) {
            return inputStream;
        }
        return this.delegate.getInputStream();
    }

    private synchronized InputStream tryCache() throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (Object object = this.delegate.getInputStream();){
                ((InputStream)object).transferTo(byteArrayOutputStream);
            }
            object = byteArrayOutputStream.toByteArray();
            this.cache = new SoftReference<Object>(object);
            return new ByteArrayInputStream((byte[])object);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return null;
        }
    }

    @Override
    public long getContentLength() {
        return 0L;
    }
}

